/*
 * Decompiled with CFR 0.152.
 */
package jcckit.transformation;

import jcckit.data.DataPoint;
import jcckit.graphic.GraphPoint;
import jcckit.transformation.Transformation;
import jcckit.util.Util;

public class CartesianTransformation
implements Transformation {
    private final boolean _xLogScale;
    private final double _xOffset;
    private final double _xScale;
    private final boolean _yLogScale;
    private final double _yOffset;
    private final double _yScale;

    public CartesianTransformation(boolean xLogScale, boolean yLogScale, DataPoint dataPoint1, GraphPoint graphPoint1, DataPoint dataPoint2, GraphPoint graphPoint2) {
        this._xLogScale = xLogScale;
        double d1 = Util.log(dataPoint1.getX(), xLogScale);
        double dd = Util.log(dataPoint2.getX(), xLogScale) - d1;
        this.check(dd, "data", "x", d1);
        this._xScale = (graphPoint2.getX() - graphPoint1.getX()) / dd;
        this.check(this._xScale, "graphical", "x", graphPoint1.getX());
        this._xOffset = graphPoint1.getX() - d1 * this._xScale;
        this._yLogScale = yLogScale;
        d1 = Util.log(dataPoint1.getY(), yLogScale);
        dd = Util.log(dataPoint2.getY(), yLogScale) - d1;
        this.check(dd, "data", "y", d1);
        this._yScale = (graphPoint2.getY() - graphPoint1.getY()) / dd;
        this.check(this._yScale, "graphical", "y", graphPoint1.getY());
        this._yOffset = graphPoint1.getY() - d1 * this._yScale;
    }

    private void check(double valueToCheck, String type, String axis, double value) {
        if (valueToCheck == 0.0) {
            throw new IllegalArgumentException("The " + type + " reference points in " + axis + " must be different; both are " + value);
        }
    }

    @Override
    public GraphPoint transformToGraph(DataPoint point) {
        return new GraphPoint(this._xOffset + Util.log(point.getX(), this._xLogScale) * this._xScale, this._yOffset + Util.log(point.getY(), this._yLogScale) * this._yScale);
    }

    @Override
    public DataPoint transformToData(GraphPoint point) {
        return new DataPoint(Util.exp((point.getX() - this._xOffset) / this._xScale, this._xLogScale), Util.exp((point.getY() - this._yOffset) / this._yScale, this._yLogScale));
    }
}

