/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.PrintStream;
import net.sourceforge.plantuml.ErrorStatus;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.Stdrpt;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.eggs.PSystemWelcome;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.utils.Log;

public class StdrptV1
implements Stdrpt {
    @Override
    public void printInfo(PrintStream output, Diagram sys) {
        if (sys instanceof PSystemWelcome) {
            sys = null;
        }
        if (sys == null || sys instanceof PSystemError) {
            this.out(output, (PSystemError)sys);
        }
    }

    @Override
    public void errorLine(int lineError, File file) {
        Log.error("Error line " + (lineError + 1) + " in file: " + file.getPath());
    }

    private void out(PrintStream output, PSystemError err) {
        output.println("protocolVersion=1");
        if (this.empty(err)) {
            output.println("status=NO_DATA");
        } else {
            output.println("status=ERROR");
            output.println("lineNumber=" + (err.getLineLocation().getPosition() + 1));
            for (ErrorUml er : err.getErrorsUml()) {
                output.println("label=" + er.getError());
            }
        }
        output.flush();
    }

    private boolean empty(PSystemError err) {
        if (err == null) {
            return true;
        }
        for (ErrorUml er : err.getErrorsUml()) {
            if (!"Empty description".equals(er.getError())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void finalMessage(ErrorStatus error) {
        if (error.hasError()) {
            Log.error("Some diagram description contains errors");
        }
        if (error.isNoData()) {
            Log.error("No diagram found");
        }
    }
}

