/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.aso;

import java.util.Arrays;
import oracle.net.aso.AsoException;
import oracle.net.aso.CipherBlockProcessor;
import oracle.net.aso.EncryptionEngine;
import oracle.net.aso.PaddedCipher;

class ZerosPadding
extends PaddedCipher {
    private final byte[] tempBuffer;

    ZerosPadding(int blockSize, EncryptionEngine engine, CipherBlockProcessor blockProcessor) {
        super(blockSize, engine, blockProcessor);
        this.tempBuffer = new byte[blockSize];
    }

    @Override
    public byte[] encrypt(byte[] buffer) throws AsoException {
        int length = buffer.length;
        byte padding = (byte)(length % this.blockSize == 0 ? 0 : this.blockSize - length % this.blockSize);
        int elength = length + padding;
        byte[] result = new byte[elength];
        if (this.coreEngine.canProcessBulk(elength)) {
            byte[] input = new byte[elength];
            System.arraycopy(buffer, 0, input, 0, length);
            this.coreEngine.encrypt(input, 0, elength, result);
        } else {
            for (int i = 0; i < length; i += this.blockSize) {
                if (i <= length - this.blockSize) {
                    System.arraycopy(buffer, i, this.tempBuffer, 0, this.blockSize);
                } else {
                    System.arraycopy(buffer, i, this.tempBuffer, 0, buffer.length - i);
                    Arrays.fill(this.tempBuffer, buffer.length - i, this.blockSize, (byte)0);
                }
                byte[] output = this.blockProcessor.encrypt(this.tempBuffer);
                System.arraycopy(output, 0, result, i, this.blockSize);
            }
        }
        return result;
    }

    @Override
    public byte[] decrypt(byte[] ebuffer) throws AsoException {
        int encryptedDataLength = ebuffer.length;
        if (encryptedDataLength % this.blockSize != 0) {
            throw new AsoException(103);
        }
        byte[] result = new byte[encryptedDataLength];
        if (this.coreEngine.canProcessBulk(encryptedDataLength)) {
            byte[] temp = new byte[encryptedDataLength];
            this.coreEngine.decrypt(ebuffer, 0, encryptedDataLength, temp);
            System.arraycopy(temp, 0, result, 0, encryptedDataLength);
        } else {
            int i = 0;
            while (i + this.blockSize < encryptedDataLength) {
                System.arraycopy(ebuffer, i, this.tempBuffer, 0, this.blockSize);
                byte[] output = this.blockProcessor.decrypt(this.tempBuffer);
                System.arraycopy(output, 0, result, i, this.blockSize);
                i += this.blockSize;
            }
        }
        return result;
    }
}

