/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.AQMessageI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.JMSMessagePropertiesI;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIaqi;
import oracle.jdbc.driver.T4CTTIaqo;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.JMSDequeueOptions;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.internal.JMSFactory;
import oracle.jdbc.internal.JMSMessage;
import oracle.jdbc.internal.JMSMessageProperties;

class T4CTTCaqa
extends T4CTTIfun {
    private static final String CLASS_NAME = T4CTTCaqa.class.getName();
    static final int AQXDEF_ENQ = 1;
    static final int AQXDEF_DEQ = 2;
    static final int AQXDEF_ARR = 3;
    static final int AQXDEF_RETMID = 1;
    static final int AQXDEF_DYNDAT = 2;
    static final int AQXDEF_ORGMID = 4;
    T4CConnection connection;
    T4CTTIaqi[] aqiArray;
    T4CTTIaqo[] aqoArray;
    private long aqxrflg = 0L;
    private int aqxaqopt = 0;
    private long aqxiters = 0L;
    private JMSEnqueueOptions jmsEnqueueOptions;
    private AQMessagePropertiesI[] messageProperties;
    private JMSMessage[] jmsMesgs;
    private boolean isAQMsgs = false;
    private AQMessage[] aqMesgs;
    private AQEnqueueOptions aqEnqueueOptions;
    private JMSDequeueOptions jmsDequeueOptions = null;
    private AQDequeueOptions aqDequeueOptions = null;

    T4CTTCaqa(T4CConnection _connection) throws IOException, SQLException {
        super(_connection, (byte)3);
        this.setFunCode((short)145);
        this.connection = _connection;
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINER)
    int doJMSEnq(String string, JMSEnqueueOptions jMSEnqueueOptions, JMSMessage[] jMSMessageArray, AQMessagePropertiesI[] aQMessagePropertiesIArray) throws SQLException, IOException {
        try {
            void _mesgs;
            void _messageProperties;
            void _enqueueOptions;
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CTTCaqa", "doJMSEnq", "entering args ({0}, {1}, {2}, {3})", (String)null, null, new Object[]{string, jMSEnqueueOptions, jMSMessageArray, aQMessagePropertiesIArray});
            this.jmsEnqueueOptions = _enqueueOptions;
            this.messageProperties = _messageProperties;
            this.jmsMesgs = _mesgs;
            this.aqxaqopt = 1;
            this.isAQMsgs = false;
            this.aqxiters = ((void)_mesgs).length;
            this.aqEnqueueOptions = null;
            this.aqMesgs = null;
            this.aqiArray = new T4CTTIaqi[(int)this.aqxiters];
            int i = 0;
            while ((long)i < this.aqxiters) {
                void _queueName;
                this.aqiArray[i] = new T4CTTIaqi(this.connection, this.aqxaqopt, (String)_queueName, (JMSEnqueueOptions)_enqueueOptions, (JMSMessage)_mesgs[i], (AQMessagePropertiesI)_messageProperties[i], _mesgs[i].getJMSMessageProperties(), null);
                ++i;
            }
            this.setFlag();
            this.doRPC();
            int n = (int)this.aqxiters;
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CTTCaqa", "doJMSEnq", "returning {0}", (String)null, null, new Object[]{n});
            return n;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CTTCaqa", "doJMSEnq", "throwing", (String)null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINER)
    JMSMessage[] doJMSDeq(String string, JMSDequeueOptions jMSDequeueOptions, int n, AQMessagePropertiesI[] aQMessagePropertiesIArray, JMSMessagePropertiesI jMSMessagePropertiesI) throws SQLException, IOException {
        try {
            void _jmsProp;
            void _jmsDequeueOpt;
            void _size;
            void _messageProperties;
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CTTCaqa", "doJMSDeq", "entering args ({0}, {1}, {2}, {3}, {4})", (String)null, null, new Object[]{string, jMSDequeueOptions, n, aQMessagePropertiesIArray, jMSMessagePropertiesI});
            this.jmsEnqueueOptions = null;
            this.messageProperties = _messageProperties;
            JMSMessage[] mesgs = null;
            this.aqxaqopt = 2;
            this.isAQMsgs = false;
            this.aqxiters = (long)_size;
            this.jmsDequeueOptions = _jmsDequeueOpt;
            this.aqEnqueueOptions = null;
            this.aqMesgs = null;
            this.aqDequeueOptions = null;
            this.aqiArray = new T4CTTIaqi[(int)this.aqxiters];
            int i = 0;
            while ((long)i < this.aqxiters) {
                void _queueName;
                this.aqiArray[i] = new T4CTTIaqi(this.connection, this.aqxaqopt, (String)_queueName, null, null, (AQMessagePropertiesI)_messageProperties[i], (JMSMessageProperties)_jmsProp, (JMSDequeueOptions)_jmsDequeueOpt);
                ++i;
            }
            this.setFlag();
            this.doRPC();
            if (this.aqoArray != null && this.aqoArray.length > 0) {
                mesgs = new JMSMessage[this.aqoArray.length];
                for (i = 0; i < this.aqoArray.length; ++i) {
                    JMSMessage msg = JMSFactory.createJMSMessage((JMSMessageProperties)_jmsProp);
                    msg.setPayload(this.aqoArray[i].getPayload());
                    msg.setMessageId(this.aqoArray[i].getMsgId());
                    msg.setJMSMessageProperties((JMSMessageProperties)_jmsProp);
                    msg.setAQMessageProperties((AQMessageProperties)_messageProperties[i]);
                    mesgs[i] = msg;
                }
            }
            JMSMessage[] jMSMessageArray = mesgs;
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CTTCaqa", "doJMSDeq", "returning {0}", (String)null, null, new Object[]{jMSMessageArray});
            return jMSMessageArray;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CTTCaqa", "doJMSDeq", "throwing", (String)null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINER)
    int doAQEnq(String string, AQEnqueueOptions aQEnqueueOptions, AQMessage[] aQMessageArray) throws SQLException, IOException {
        try {
            void _mesgs;
            void _aqEnqueueOptions;
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CTTCaqa", "doAQEnq", "entering args ({0}, {1}, {2})", (String)null, null, new Object[]{string, aQEnqueueOptions, aQMessageArray});
            this.aqEnqueueOptions = _aqEnqueueOptions;
            this.aqMesgs = _mesgs;
            this.aqxaqopt = 1;
            this.isAQMsgs = true;
            this.aqxiters = ((void)_mesgs).length;
            this.jmsEnqueueOptions = null;
            this.jmsMesgs = null;
            this.aqDequeueOptions = null;
            this.jmsDequeueOptions = null;
            this.aqiArray = new T4CTTIaqi[(int)this.aqxiters];
            this.messageProperties = new AQMessagePropertiesI[(int)this.aqxiters];
            int i = 0;
            while ((long)i < this.aqxiters) {
                void _queueName;
                AQMessageI imesg = (AQMessageI)_mesgs[i];
                this.messageProperties[i] = imesg.getMessagePropertiesI();
                this.aqiArray[i] = new T4CTTIaqi(this.connection, this.aqxaqopt, (String)_queueName, (AQEnqueueOptions)_aqEnqueueOptions, (AQMessage)_mesgs[i], imesg.getMessagePropertiesI(), null, null, 0);
                ++i;
            }
            this.setFlag();
            this.doRPC();
            int n = (int)this.aqxiters;
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CTTCaqa", "doAQEnq", "returning {0}", (String)null, null, new Object[]{n});
            return n;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CTTCaqa", "doAQEnq", "throwing", (String)null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINER)
    AQMessage[] doAQDeq(String string, AQDequeueOptions aQDequeueOptions, byte[] byArray, int n, int n2, AQMessagePropertiesI[] aQMessagePropertiesIArray) throws SQLException, IOException {
        try {
            void _tdo;
            void _aqDequeueOptions;
            void _size;
            void _messageProperties;
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CTTCaqa", "doAQDeq", "entering args ({0}, {1}, {2}, {3}, {4}, {5})", (String)null, null, new Object[]{string, aQDequeueOptions, byArray, n, n2, aQMessagePropertiesIArray});
            AQMessage[] mesgs = null;
            this.aqEnqueueOptions = null;
            this.messageProperties = _messageProperties;
            this.aqxaqopt = 2;
            this.isAQMsgs = true;
            this.aqxiters = (long)_size;
            this.aqDequeueOptions = _aqDequeueOptions;
            this.jmsEnqueueOptions = null;
            this.jmsMesgs = null;
            this.jmsDequeueOptions = null;
            this.aqiArray = new T4CTTIaqi[(int)this.aqxiters];
            int i = 0;
            while ((long)i < this.aqxiters) {
                void _version;
                void _queueName;
                this.aqiArray[i] = new T4CTTIaqi(this.connection, this.aqxaqopt, (String)_queueName, null, null, (AQMessagePropertiesI)_messageProperties[i], (AQDequeueOptions)_aqDequeueOptions, (byte[])_tdo, (int)_version);
                ++i;
            }
            this.setFlag();
            this.doRPC();
            if (this.aqoArray != null && this.aqoArray.length > 0) {
                mesgs = new AQMessageI[this.aqoArray.length];
                for (i = 0; i < this.aqoArray.length; ++i) {
                    AQMessageI msg = new AQMessageI((AQMessagePropertiesI)_messageProperties[i], this.connection);
                    msg.setPayload(this.aqoArray[i].getPayload(), (byte[])_tdo);
                    msg.setMessageId(this.aqoArray[i].getMsgId());
                    mesgs[i] = msg;
                }
            }
            AQMessage[] aQMessageArray = mesgs;
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CTTCaqa", "doAQDeq", "returning {0}", (String)null, null, new Object[]{aQMessageArray});
            return aQMessageArray;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CTTCaqa", "doAQDeq", "throwing", (String)null, throwable, new Object[0]);
            throw throwable;
        }
    }

    void setFlag() {
        boolean retrieveMessageId;
        if (this.aqxaqopt == 1) {
            retrieveMessageId = !this.isAQMsgs && this.jmsEnqueueOptions.isRetrieveMessageId() || this.isAQMsgs && this.aqEnqueueOptions.getRetrieveMessageId();
        } else {
            boolean bl = retrieveMessageId = !this.isAQMsgs && this.jmsDequeueOptions.isRetrieveMessageId() || this.isAQMsgs && this.aqDequeueOptions.getRetrieveMessageId();
        }
        if (retrieveMessageId) {
            this.aqxrflg |= 1L;
        }
    }

    @Override
    void marshal() throws IOException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshal", "aqxaqopt={0}, aqxrflg={1}, isAQMsgs={2}", (String)null, (Throwable)null, (Object)this.aqxaqopt, (Object)this.aqxrflg, (Object)this.isAQMsgs);
        if (this.aqxaqopt == 1) {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        } else if (this.aqiArray != null && this.aqiArray.length != 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.aqiArray.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalUB4(this.aqxrflg);
        if (this.aqxaqopt == 1) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(0L);
        } else {
            this.meg.marshalPTR();
            this.meg.marshalPTR();
        }
        if (this.isAQMsgs) {
            this.meg.marshalSB4(this.aqxaqopt);
        } else if (this.aqxaqopt == 1) {
            this.meg.marshalSB4(3);
        } else {
            this.meg.marshalSB4(this.aqxaqopt);
        }
        if (this.aqxaqopt == 1) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.connection.getTTCVersion() >= 16) {
            if (this.aqxaqopt == 1) {
                this.meg.marshalUB4(65535L);
            } else {
                this.meg.marshalUB4(65535L);
            }
        }
        if (this.aqxaqopt == 1) {
            this.meg.marshalUB4(this.aqxiters);
        }
        if (this.aqiArray != null && this.aqiArray.length != 0) {
            if (this.aqxaqopt == 1) {
                this.aqiArray[0].marshalPropagation();
                this.aqiArray[0].marshalHeader();
                for (int i = 0; i < this.aqiArray.length; ++i) {
                    if (this.isAQMsgs) {
                        this.aqiArray[i].marshalData();
                        continue;
                    }
                    this.aqiArray[i].marshalJmsData();
                }
                this.aqiArray[0].marshalDone();
            } else {
                for (int i = 0; i < this.aqiArray.length; ++i) {
                    this.aqiArray[i].marshal();
                }
            }
        }
    }

    @Override
    void readRPA() throws SQLException, IOException {
        this.unmarshal();
    }

    void unmarshal() throws SQLException, IOException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshal", "aqxaqopt={0}, isAQMsgs={1}, aqxiters={2}", (String)null, (Throwable)null, (Object)this.aqxaqopt, (Object)this.isAQMsgs, (Object)this.aqxiters);
        int aqxaqol = (int)this.meg.unmarshalUB4();
        if (aqxaqol > 0) {
            this.aqoArray = new T4CTTIaqo[aqxaqol];
            for (int i = 0; i < aqxaqol; ++i) {
                this.aqoArray[i] = this.isAQMsgs ? new T4CTTIaqo(this.connection, this.aqxaqopt, this.aqEnqueueOptions, this.messageProperties[i], this.aqDequeueOptions, this.aqiArray[i].isRawQueue(), this.aqiArray[i].isJsonQueue()) : new T4CTTIaqo(this.connection, this.aqxaqopt, this.jmsEnqueueOptions, this.messageProperties[i], this.jmsDequeueOptions, this.aqiArray[i].isRawQueue());
                this.aqoArray[i].unmarshal();
            }
            if (this.aqxaqopt == 1) {
                byte[] outMsgId;
                boolean retrieveMessageId;
                boolean bl = retrieveMessageId = !this.isAQMsgs && this.jmsEnqueueOptions.isRetrieveMessageId() || this.isAQMsgs && this.aqEnqueueOptions.getRetrieveMessageId();
                if (retrieveMessageId && (outMsgId = this.aqoArray[0].getMsgId()) != null && this.aqxiters * 16L == (long)outMsgId.length) {
                    int i = 0;
                    while ((long)i < this.aqxiters) {
                        byte[] msgId = new byte[16];
                        System.arraycopy(outMsgId, i * 16, msgId, 0, 16);
                        if (this.isAQMsgs) {
                            ((AQMessageI)this.aqMesgs[i]).setMessageId(msgId);
                        } else {
                            this.jmsMesgs[i].setMessageId(msgId);
                        }
                        ++i;
                    }
                }
            }
        } else {
            this.aqoArray = null;
        }
        this.aqxiters = this.aqxaqopt == 1 ? this.meg.unmarshalUB4() : (long)aqxaqol;
    }
}

