/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.OraclePreparedStatement;

class CopiedDataBinder
extends Binder {
    private static final String CLASS_NAME = CopiedDataBinder.class.getName();
    byte[] value;

    CopiedDataBinder(short type, byte[] val, int length) {
        this.type = type;
        this.bytelen = (short)length;
        this.value = val;
        this.bytelen = length;
    }

    @Override
    Binder copyingBinder() {
        return this;
    }

    @Override
    boolean isCopying() {
        return true;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        long pos;
        bindIndicators[indoffset] = 0;
        bindIndicators[lenoffset] = (short)this.bytelen;
        bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
        stmt.lastBoundDataOffsets[bindPosition] = pos;
        stmt.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "bind", "pos={0}, bytelen={1}. ", (String)null, (Throwable)null, (Object)pos, (Object)this.bytelen);
        bindData.put(this.value, 0, this.bytelen);
        bindDataLengths[bindDataIndex] = this.bytelen;
        stmt.lastBoundDataLengths[bindPosition] = this.bytelen;
        if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
            localCheckSum = CRC64.updateChecksum(localCheckSum, this.value, 0, this.value.length);
        }
        return localCheckSum;
    }
}

