/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle.rlb;

import java.util.concurrent.locks.ReentrantLock;

public class OracleDatabaseInstanceInfo {
    static final int STATUS_UP = 1;
    static final int STATUS_DOWN = 2;
    private final String databaseUniqueName;
    private final String instanceName;
    private final String hostName;
    private String serviceName = null;
    private float percent = 0.0f;
    public int flag = 2;
    private int numberOfConnectionsCount = 0;
    private final ReentrantLock databaseInstanceInfoLock = new ReentrantLock();
    int status = 1;
    private int numToTearDown = -1;
    private String namedInstanceUrl = null;
    private int numNamedInstanceConns = 0;
    private int id = -1;
    private int connsToTearDown = 0;
    private RebalancingState rebalancingState = RebalancingState.QUIESCENT;
    String m_equalKey;
    final String m_hashKey;
    private final int m_hashCode;

    public RebalancingState getRebalancingState() {
        this.databaseInstanceInfoLock.lock();
        try {
            RebalancingState rebalancingState = this.rebalancingState;
            return rebalancingState;
        }
        finally {
            this.databaseInstanceInfoLock.unlock();
        }
    }

    public void setRebalancingState(RebalancingState rebalancingState) {
        this.databaseInstanceInfoLock.lock();
        try {
            this.rebalancingState = rebalancingState;
        }
        finally {
            this.databaseInstanceInfoLock.unlock();
        }
    }

    public OracleDatabaseInstanceInfo(String databaseUniqueName, String instanceName) {
        this(databaseUniqueName, instanceName, null);
    }

    public OracleDatabaseInstanceInfo(String databaseUniqueName, String instanceName, String hostName) {
        this.databaseUniqueName = databaseUniqueName;
        this.instanceName = instanceName;
        this.hostName = hostName;
        StringBuffer sbuf = new StringBuffer(128);
        sbuf.append(instanceName == null ? "" : instanceName).append("##").append(databaseUniqueName == null ? "" : databaseUniqueName);
        this.m_hashKey = sbuf.toString();
        this.m_hashCode = this.m_hashKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OracleDatabaseInstanceInfo)) {
            return false;
        }
        OracleDatabaseInstanceInfo other = (OracleDatabaseInstanceInfo)obj;
        String key = this.m_hashKey == null ? "" : this.m_hashKey;
        String okey = other.m_hashKey == null ? "" : other.m_hashKey;
        return key.equals(okey);
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public String toString() {
        return "Database unique name: " + this.databaseUniqueName + ", Instance name: " + this.instanceName + ", Service name: " + this.serviceName + ", Host name: " + this.hostName + ", Instance id: " + this.id + ", percent: " + this.percent + ", Flag: " + this.flag + ", Connection count: " + this.getNumberOfConnectionsCount() + ", Status: " + (this.status == 1 ? "UP" : "DOWN");
    }

    public String getDatabaseName() {
        return this.databaseUniqueName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getNumberOfConnectionsCount() {
        this.databaseInstanceInfoLock.lock();
        try {
            int n = this.numberOfConnectionsCount;
            return n;
        }
        finally {
            this.databaseInstanceInfoLock.unlock();
        }
    }

    void incrementNumberOfConnectionsCount() {
        this.databaseInstanceInfoLock.lock();
        try {
            ++this.numberOfConnectionsCount;
        }
        finally {
            this.databaseInstanceInfoLock.unlock();
        }
    }

    void decrementNumberOfConnectionsCount() {
        this.databaseInstanceInfoLock.lock();
        try {
            assert (this.numberOfConnectionsCount >= 0) : "internal error: numberOfConnectionsCount cannot be negative";
            --this.numberOfConnectionsCount;
        }
        finally {
            this.databaseInstanceInfoLock.unlock();
        }
    }

    void setNumberOfConnectionsCount(int count) {
        this.databaseInstanceInfoLock.lock();
        try {
            this.numberOfConnectionsCount = count;
        }
        finally {
            this.databaseInstanceInfoLock.unlock();
        }
    }

    void setConnsToTearDown(int connsToTearDown) {
        this.databaseInstanceInfoLock.lock();
        try {
            this.connsToTearDown = connsToTearDown;
        }
        finally {
            this.databaseInstanceInfoLock.unlock();
        }
    }

    public int getConnsToTearDown() {
        this.databaseInstanceInfoLock.lock();
        try {
            int n = this.connsToTearDown;
            return n;
        }
        finally {
            this.databaseInstanceInfoLock.unlock();
        }
    }

    public String getServiceName() {
        this.databaseInstanceInfoLock.lock();
        try {
            String string = this.serviceName;
            return string;
        }
        finally {
            this.databaseInstanceInfoLock.unlock();
        }
    }

    public void setServiceName(String serviceName) {
        this.databaseInstanceInfoLock.lock();
        try {
            this.serviceName = serviceName;
        }
        finally {
            this.databaseInstanceInfoLock.unlock();
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getNumNamedInstanceConns() {
        return this.numNamedInstanceConns;
    }

    private void setNumNamedInstanceConns(int numNamedInstanceConns) {
        this.numNamedInstanceConns = numNamedInstanceConns;
    }

    public void decrementNumNamedInstanceConns() {
        --this.numNamedInstanceConns;
    }

    public void incrementNumNamedInstanceConns() {
        ++this.numNamedInstanceConns;
    }

    public int getNumToTearDown() {
        return this.numToTearDown;
    }

    public void setNumToTearDown(int numToTearDown) {
        this.numToTearDown = numToTearDown;
    }

    public void decrementNumToTearDown() {
        --this.numToTearDown;
    }

    public float getAdvisoryPercent() {
        this.databaseInstanceInfoLock.lock();
        try {
            float f = this.percent;
            return f;
        }
        finally {
            this.databaseInstanceInfoLock.unlock();
        }
    }

    public void setAdvisoryPercent(float percent) {
        this.databaseInstanceInfoLock.lock();
        try {
            this.percent = percent;
        }
        finally {
            this.databaseInstanceInfoLock.unlock();
        }
    }

    public String getNamedInstanceUrl() {
        this.databaseInstanceInfoLock.lock();
        try {
            String string = this.namedInstanceUrl;
            return string;
        }
        finally {
            this.databaseInstanceInfoLock.unlock();
        }
    }

    public void setNamedInstanceUrl(String namedInstanceUrl) {
        this.databaseInstanceInfoLock.lock();
        try {
            this.namedInstanceUrl = namedInstanceUrl;
        }
        finally {
            this.databaseInstanceInfoLock.unlock();
        }
    }

    public static enum RebalancingState {
        QUIESCENT,
        SHRINKING,
        SHRUNK,
        GROWING;

    }
}

