/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.oracle.ONSOracleRuntimeLBEventSubscriber;
import oracle.ucp.jdbc.oracle.OracleFailoverEventSubscriber;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.jdbc.oracle.rlb.ONSRuntimeLoadBalancingEvent;
import oracle.ucp.util.ProlongedTask;
import oracle.ucp.util.TaskManager;

class ONSRuntimeLBEventHandlerTask
extends ProlongedTask<Object>
implements Diagnosable {
    static final String CLASS_NAME = ONSRuntimeLBEventHandlerTask.class.getName();
    private final OracleFailoverEventSubscriber m_onsSubscriber;
    private boolean m_terminate = false;
    private final RACManagerImpl m_racMngr;
    private final String m_serviceName;
    private final boolean m_subscriberFailed;

    protected ONSRuntimeLBEventHandlerTask(String service, RACManagerImpl racMngr) throws UniversalConnectionPoolException {
        this(service, racMngr, null);
    }

    protected ONSRuntimeLBEventHandlerTask(String service, RACManagerImpl racMngr, OracleFailoverEventSubscriber subscriber) throws UniversalConnectionPoolException {
        this.m_racMngr = racMngr;
        ONS currentONS = racMngr.getONS();
        if (subscriber == null) {
            ONSOracleRuntimeLBEventSubscriber s = new ONSOracleRuntimeLBEventSubscriber(currentONS, service);
            this.m_subscriberFailed = s.isFailed();
            this.m_onsSubscriber = s;
        } else {
            this.m_subscriberFailed = false;
            this.m_onsSubscriber = subscriber;
        }
        this.m_serviceName = service;
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void run() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask", "run", "entering args ()", null, null, new Object[0]);
            Notification event = null;
            boolean retrySubscription = false;
            if (!this.m_subscriberFailed) {
                while (!this.isTerminate()) {
                    try {
                        event = this.m_onsSubscriber.receive();
                        if (event != null) {
                            ONSRuntimeLoadBalancingEvent rlbEvent = new ONSRuntimeLoadBalancingEvent(this.m_serviceName, event.body());
                            this.m_racMngr.handleLoadBalancingEvent(rlbEvent);
                            this.trace(Level.FINE, CLASS_NAME, "run", "Runtime Load Balancing event triggered", null, null, new Object[0]);
                        } else {
                            this.m_racMngr.setRCLBMetricsPolicyEnabled(false);
                        }
                    }
                    catch (UniversalConnectionPoolException ucpEx) {
                        this.trace(Level.WARNING, CLASS_NAME, "run", "", null, ucpEx, new Object[0]);
                        this.m_racMngr.setRCLBMetricsPolicyEnabled(false);
                        retrySubscription = true;
                    }
                    if (!retrySubscription) continue;
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        this.trace(Level.FINEST, CLASS_NAME, "run", "sleep interrupted", null, null, new Object[0]);
                        this.trace(Level.WARNING, CLASS_NAME, "run", "", null, e, new Object[0]);
                    }
                    retrySubscription = false;
                }
            } else {
                this.trace(Level.FINEST, CLASS_NAME, "run", "ONS subscriber failed", null, null, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask", "run", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask", "run", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    public boolean isTerminate() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask", "isTerminate", "entering args ()", null, null, new Object[0]);
            boolean bl = this.m_terminate;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask", "isTerminate", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask", "isTerminate", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public void setTerminate(boolean bl) {
        try {
            void terminate;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask", "setTerminate", "entering args ({0})", null, null, bl);
            this.m_terminate = terminate;
            if (terminate != false) {
                this.m_onsSubscriber.close();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask", "setTerminate", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask", "setTerminate", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    protected TaskManager getTaskManager() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask", "getTaskManager", "entering args ()", null, null, new Object[0]);
            TaskManager taskManager = this.m_racMngr.getTaskManager();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask", "getTaskManager", "returning {0}", null, null, taskManager);
            return taskManager;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask", "getTaskManager", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public boolean isCritical() {
        return true;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return DiagnosticsCollectorImpl.getCommon();
    }
}

