/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import oracle.jdbc.proxy.AnnotationsRegistry;
import oracle.jdbc.proxy.ClassGenerator;
import oracle.jdbc.proxy.ExtractDelegatePermission;
import oracle.jdbc.proxy.GeneratedProxiesRegistry;
import oracle.jdbc.proxy.NullProxy;
import oracle.jdbc.proxy.WeakIdentityHashMap;
import oracle.jdbc.proxy._Proxy_;

public class ProxyFactory {
    public static final String DEFAULT_PROXY_PACKAGE = "oracle.jdbc.proxy";
    final AnnotationsRegistry annotationsRegistry = new AnnotationsRegistry();
    private static final GeneratedProxiesRegistry generatedRegistry = new GeneratedProxiesRegistry();
    private Map<Class<?>, Constructor<?>> delegateClassToProxyConstructor = new IdentityHashMap();
    private final Map<Object, WeakReference<?>> delegateToProxy = Collections.synchronizedMap(new WeakIdentityHashMap());
    private Map<Class<?>, Class<?>> delegateToMostSuitableIface = new IdentityHashMap();
    private static final Object STALE_DELEGATE = new Object();
    private static final Class<EMPTY_CLASS> EMPTY_VALUE = EMPTY_CLASS.class;
    private ClassLoader classLoader = null;
    private final String proxyPackage;
    private static final ExtractDelegatePermission EXTRACT_DELEGATE_PERMISSION = new ExtractDelegatePermission();

    private ProxyFactory(String proxyPackage) {
        this.proxyPackage = proxyPackage;
    }

    public static ProxyFactory createProxyFactory(String proxyPackage, Class<?> ... classes) {
        ProxyFactory proxyFactory = new ProxyFactory(proxyPackage);
        proxyFactory.annotationsRegistry.register(classes);
        return proxyFactory;
    }

    public static ProxyFactory createProxyFactory(Class<?> ... classes) {
        ProxyFactory proxyFactory = new ProxyFactory(DEFAULT_PROXY_PACKAGE);
        proxyFactory.annotationsRegistry.register(classes);
        return proxyFactory;
    }

    public static ProxyFactory createJDBCProxyFactory(String proxyPackage, Class<?> ... classes) {
        ProxyFactory proxyFactory = new ProxyFactory(proxyPackage);
        proxyFactory.annotationsRegistry.register(NullProxy.class);
        proxyFactory.annotationsRegistry.register(classes);
        return proxyFactory;
    }

    public static ProxyFactory createJDBCProxyFactory(Class<?> ... classes) {
        ProxyFactory proxyFactory = new ProxyFactory(DEFAULT_PROXY_PACKAGE);
        proxyFactory.annotationsRegistry.register(NullProxy.class);
        proxyFactory.annotationsRegistry.register(classes);
        return proxyFactory;
    }

    public final boolean isProxied(Class<?> iface) {
        return this.annotationsRegistry.containsKey(iface);
    }

    public final <T> T proxyFor(T delegate) {
        return this.proxyFor(delegate, this);
    }

    public final <T> T proxyFor(T delegate, Object creator) {
        return this.proxyForCache(delegate, creator, null, null);
    }

    public final <T> T proxyForType(Class<?> delegateClass) {
        return this.proxyForType(delegateClass, this);
    }

    public final <T> T proxyForType(Class<?> delegateClass, Object creator) {
        if (Objects.isNull(delegateClass)) {
            return null;
        }
        Class<?> mostSuitableIface = this.findMostSuitableIface(delegateClass);
        if (Objects.isNull(mostSuitableIface)) {
            return null;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        if (Objects.isNull(value)) {
            return null;
        }
        Constructor<?> proxyConstructor = this.getProxyConstructor(mostSuitableIface, delegateClass);
        try {
            Object proxy = proxyConstructor.newInstance(null, creator, this, null, false);
            return (T)proxy;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public final <T> T proxyForCreate(T delegate) {
        return this.proxyForCreate(delegate, this, null, null);
    }

    public final <T> T proxyForCreate(T delegate, Object creator) {
        return this.proxyForCreate(delegate, creator, null, null);
    }

    public final <T> T proxyForCreate(T delegate, Object creator, Map<Object, WeakReference<?>> proxyCache, Method methodObject) {
        if (null == delegate) {
            return null;
        }
        Class<?> delegateClass = delegate.getClass();
        Class<?> mostSuitableIface = this.findMostSuitableIface(delegateClass);
        if (null != methodObject && null != mostSuitableIface && !methodObject.getReturnType().isAssignableFrom(mostSuitableIface)) {
            return delegate;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        if (null == value) {
            return delegate;
        }
        Constructor<?> proxyConstructor = this.getProxyConstructor(mostSuitableIface, delegateClass);
        try {
            Object proxy = proxyConstructor.newInstance(delegate, creator, this, proxyCache, false);
            return (T)proxy;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<Object, WeakReference<?>> denullifyProxyCache(boolean proxyLocale, Map<Object, WeakReference<?>> proxyCache) {
        if (null != proxyCache) {
            return proxyCache;
        }
        return proxyLocale ? new WeakIdentityHashMap() : this.delegateToProxy;
    }

    public final <T> T proxyForCache(T delegate, Object creator, Map<Object, WeakReference<?>> proxyCache, Method methodObject) {
        if (null == delegate) {
            return null;
        }
        if (delegate instanceof _Proxy_) {
            return delegate;
        }
        Class<?> delegateClass = delegate.getClass();
        Class<?> mostSuitableIface = this.findMostSuitableIface(delegateClass);
        if (null != methodObject && null != mostSuitableIface && !methodObject.getReturnType().isAssignableFrom(mostSuitableIface)) {
            return delegate;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        if (null == value) {
            return delegate;
        }
        Method getter = value.getProxyAccessGetter();
        Method setter = value.getProxyAccessSetter();
        try {
            Object proxy;
            if (null != getter) {
                Object proxy2 = getter.invoke(delegate, new Object[0]);
                if (null != proxy2) {
                    return (T)proxy2;
                }
            } else {
                WeakReference<?> proxyRef = (null != proxyCache ? proxyCache : this.delegateToProxy).get(delegate);
                if (null != proxyRef && null != (proxy = proxyRef.get())) {
                    if (STALE_DELEGATE == proxy) {
                        throw new IllegalStateException("internal error: stale delegate");
                    }
                    return proxy;
                }
            }
            Constructor<?> proxyConstructor = this.getProxyConstructor(mostSuitableIface, delegateClass);
            if (null == setter) {
                proxyCache = this.denullifyProxyCache(value.isProxyLocale(), proxyCache);
            }
            proxy = proxyConstructor.newInstance(delegate, creator, this, proxyCache, null == setter);
            if (null != setter) {
                setter.invoke(delegate, proxy);
            } else {
                proxyCache.put(delegate, new WeakReference(proxy));
            }
            return proxy;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public final <T> T proxyForCreateCache(T delegate, Object creator, Map<Object, WeakReference<?>> proxyCache, Method methodObject) {
        if (null == delegate) {
            return null;
        }
        if (delegate instanceof _Proxy_) {
            return delegate;
        }
        Class<?> delegateClass = delegate.getClass();
        Class<?> mostSuitableIface = this.findMostSuitableIface(delegateClass);
        if (null != methodObject && null != mostSuitableIface && !methodObject.getReturnType().isAssignableFrom(mostSuitableIface)) {
            return delegate;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        if (null == value) {
            return delegate;
        }
        Method setter = value.getProxyAccessSetter();
        Constructor<?> proxyConstructor = this.getProxyConstructor(mostSuitableIface, delegateClass);
        try {
            proxyCache = this.denullifyProxyCache(value.isProxyLocale(), proxyCache);
            Object proxy = proxyConstructor.newInstance(delegate, creator, this, proxyCache, null == setter);
            if (null != setter) {
                setter.invoke(delegate, proxy);
            } else {
                proxyCache.put(delegate, new WeakReference(proxy));
            }
            return (T)proxy;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void updateDelegate(Object proxy, T oldDelegate, T newDelegate, Map<Object, WeakReference<?>> proxyCache) {
        if (null != proxyCache) {
            if (null != oldDelegate) {
                proxyCache.replace(oldDelegate, new WeakReference<Object>(STALE_DELEGATE));
            }
            if (null != newDelegate && null != proxy) {
                proxyCache.put(newDelegate, new WeakReference<Object>(proxy));
            }
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static final <T> T extractDelegate(_Proxy_<T> proxy) {
        SecurityManager security = System.getSecurityManager();
        if (null != security) {
            security.checkPermission(EXTRACT_DELEGATE_PERMISSION);
        }
        return proxy._getDelegate_();
    }

    private <T> Constructor<?> prepareProxyConstructor(Class<?> mostSuitableIface) {
        Objects.requireNonNull(null == mostSuitableIface);
        AnnotationsRegistry.Value value = Objects.requireNonNull(this.annotationsRegistry.get(mostSuitableIface));
        Class<?> superclass = value.getSuperclass();
        Constructor<?> constructor = this.prepareProxy(this.proxyPackage, mostSuitableIface, superclass);
        constructor.setAccessible(true);
        return constructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Constructor<?> prepareProxy(String proxyPackage, Class<?> iface, Class<?> superclass) {
        Constructor<?> constructor;
        block17: {
            GeneratedProxiesRegistry.Value v = generatedRegistry.get(proxyPackage, iface, superclass);
            if (null != v) {
                return v.getConstructor();
            }
            Class<?> clazz = null;
            clazz = Class.forName(new GeneratedProxiesRegistry.Key(proxyPackage, iface, superclass).toString(), true, null == this.classLoader ? superclass.getClassLoader() : this.classLoader);
            if (Objects.isNull(clazz)) {
                throw new IllegalStateException("cannot resolve or generate proxy");
            }
            try {
                constructor = clazz.getConstructor(iface, Object.class, ProxyFactory.class, Map.class, Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            assert (null != constructor);
            constructor.setAccessible(true);
            generatedRegistry.put(proxyPackage, iface, superclass, new GeneratedProxiesRegistry.Value(null, null, clazz, constructor));
            break block17;
            catch (ClassNotFoundException e) {
                try {
                    clazz = ClassGenerator.generate(proxyPackage, iface, superclass, this.annotationsRegistry, this.classLoader);
                }
                catch (Throwable throwable) {
                    if (Objects.isNull(clazz)) {
                        throw new IllegalStateException("cannot resolve or generate proxy");
                    }
                    try {
                        constructor = clazz.getConstructor(iface, Object.class, ProxyFactory.class, Map.class, Boolean.TYPE);
                    }
                    catch (NoSuchMethodException e2) {
                        throw new RuntimeException(e2);
                    }
                    assert (null != constructor);
                    constructor.setAccessible(true);
                    generatedRegistry.put(proxyPackage, iface, superclass, new GeneratedProxiesRegistry.Value(null, null, clazz, constructor));
                    throw throwable;
                }
                if (Objects.isNull(clazz)) {
                    throw new IllegalStateException("cannot resolve or generate proxy");
                }
                try {
                    constructor = clazz.getConstructor(iface, Object.class, ProxyFactory.class, Map.class, Boolean.TYPE);
                }
                catch (NoSuchMethodException e3) {
                    throw new RuntimeException(e3);
                }
                assert (null != constructor);
                constructor.setAccessible(true);
                generatedRegistry.put(proxyPackage, iface, superclass, new GeneratedProxiesRegistry.Value(null, null, clazz, constructor));
            }
        }
        return constructor;
    }

    private Constructor<?> getProxyConstructor(Class<?> mostSuitableIface, Class<?> delegateClass) {
        Constructor<?> proxyConstructor;
        Objects.requireNonNull(delegateClass);
        Objects.requireNonNull(mostSuitableIface);
        Constructor<?> proxyConstructor2 = this.delegateClassToProxyConstructor.get(delegateClass);
        if (null != proxyConstructor2) {
            return proxyConstructor2;
        }
        GeneratedProxiesRegistry.Value value = generatedRegistry.get(this.proxyPackage, mostSuitableIface, this.annotationsRegistry.get(mostSuitableIface).getSuperclass());
        Constructor<?> constructor = proxyConstructor = null != value ? value.getConstructor() : null;
        if (null == proxyConstructor) {
            proxyConstructor = this.prepareProxyConstructor(mostSuitableIface);
        }
        assert (null != proxyConstructor);
        IdentityHashMap newMap = new IdentityHashMap(this.delegateClassToProxyConstructor);
        newMap.put(delegateClass, proxyConstructor);
        this.delegateClassToProxyConstructor = newMap;
        return proxyConstructor;
    }

    private Class<?> findMostSuitableIface(Class<?> delegateClass) {
        if (null == delegateClass) {
            return null;
        }
        Class<?> c = this.delegateToMostSuitableIface.get(delegateClass);
        if (null != c) {
            return EMPTY_VALUE != c ? c : null;
        }
        int max = -1;
        Class<EMPTY_CLASS> iface = null;
        for (Class<?> i : this.annotationsRegistry.keySet()) {
            int c2 = this.intersectionCardinality(delegateClass, i);
            if (c2 < 1 || c2 <= max) continue;
            max = c2;
            iface = i;
        }
        IdentityHashMap newMap = new IdentityHashMap(this.delegateToMostSuitableIface);
        newMap.put(delegateClass, null != iface ? iface : EMPTY_VALUE);
        this.delegateToMostSuitableIface = newMap;
        return iface;
    }

    private int intersectionCardinality(Class<?> delegateClass, Class<?> iface) {
        HashSet iSet = new HashSet();
        this.collectIfaces(iface, iSet);
        HashSet dSet = new HashSet();
        this.collectIfaces(delegateClass, dSet);
        int iCard = iSet.size();
        iSet.removeAll(dSet);
        if (iSet.size() > 0) {
            return -1;
        }
        return iCard;
    }

    private void collectIfaces(Class<?> c, Set<Class<?>> set) {
        if (c.isInterface()) {
            set.add(c);
        }
        for (Class<?> iface : c.getInterfaces()) {
            this.collectIfaces(iface, set);
        }
        Class<?> superclass = c.getSuperclass();
        if (null != superclass) {
            this.collectIfaces(superclass, set);
        }
    }

    private static final class EMPTY_CLASS {
        private EMPTY_CLASS() {
        }
    }
}

