/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.nio.ByteBuffer;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ClobCopyingBinder;
import oracle.jdbc.driver.DatumBinder;
import oracle.jdbc.driver.OraclePreparedStatement;

class ClobBinder
extends DatumBinder {
    Binder theClobCopyingBinder = null;

    static void init(Binder x) {
        x.type = (short)112;
        x.bytelen = 4000;
    }

    ClobBinder(byte[] val) {
        this(val, null);
    }

    ClobBinder(byte[] val, ByteBuffer clobData) {
        super(val, clobData);
        ClobBinder.init(this);
        this.skipBindChecksumForLobs = true;
    }

    @Override
    Binder copyingBinder() {
        if (this.theClobCopyingBinder == null) {
            this.theClobCopyingBinder = new ClobCopyingBinder();
        }
        return this.theClobCopyingBinder;
    }

    @Override
    void lastBoundValueCleanup(OraclePreparedStatement stmt, int bindPosition) {
        if (stmt.lastBoundClobs != null) {
            stmt.moveTempLobsToFree(stmt.lastBoundClobs[bindPosition]);
        }
    }
}

