/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

public class OctetUtil {
    private OctetUtil() {
        throw new InstantiationError("This class must not be instantiated");
    }

    public static byte[] intToBytes(int value) {
        byte[] result = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return result;
    }

    public static byte[] shortToBytes(short value) {
        byte[] result = new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return result;
    }

    public static int bytesToInt(byte[] bytes) {
        return OctetUtil.bytesToInt(bytes, 0);
    }

    public static int bytesToInt(byte[] bytes, int offset) {
        int result = 0;
        int length = bytes.length - offset < 4 ? bytes.length - offset : 4;
        int end = offset + length - 1;
        for (int i = 0; i < length; ++i) {
            result |= (bytes[end - i] & 0xFF) << 8 * i;
        }
        return result;
    }

    public static short bytesToShort(byte[] bytes) {
        return OctetUtil.bytesToShort(bytes, 0);
    }

    public static short bytesToShort(byte[] bytes, int offset) {
        short result = 0;
        int end = offset + 1;
        for (int i = 0; i < 2; ++i) {
            result = (short)(result | (bytes[end - i] & 0xFF) << 8 * i);
        }
        return result;
    }
}

