/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.lib.LineGroupReader;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.persist.LobStore;
import org.hsqldb.persist.LobStoreInJar;
import org.hsqldb.persist.LobStoreMem;
import org.hsqldb.persist.LobStoreRAFile;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.Collation;

public class LobManager {
    static final String resourceFileName = "/org/hsqldb/resources/lob-schema.sql";
    Database database;
    LobStore lobStore;
    Session sysLobSession;
    volatile boolean storeModified;
    byte[] byteBuffer;
    Inflater inflater;
    Deflater deflater;
    byte[] dataBuffer;
    boolean cryptLobs;
    boolean compressLobs;
    int lobBlockSize;
    int largeLobBlockSize = 524288;
    int totalBlockLimitCount = Integer.MAX_VALUE;
    Statement getLob;
    Statement getSpanningBlocks;
    Statement deleteLobCall;
    Statement deleteLobPartCall;
    Statement divideLobPartCall;
    Statement createLob;
    Statement createLobPartCall;
    Statement createSingleLobPartCall;
    Statement updateLobLength;
    Statement updateLobUsage;
    Statement getNextLobId;
    Statement deleteUnusedLobs;
    Statement mergeUnusedSpace;
    Statement getLobUseLimit;
    Statement getLobCount;
    Statement getSpanningParts;
    Statement getLastPart;
    Statement createPart;
    long usageChanged;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock writeLock = this.lock.writeLock();
    private static final String existsBlocksSQL = "SELECT * FROM SYSTEM_LOBS.BLOCKS LIMIT 1";
    private static final String initialiseBlocksSQL = "INSERT INTO SYSTEM_LOBS.BLOCKS VALUES(?,?,?)";
    private static final String getLobSQL = "SELECT * FROM SYSTEM_LOBS.LOB_IDS WHERE LOB_IDS.LOB_ID = ?";
    private static final String getLobPartSQL = "SELECT * FROM SYSTEM_LOBS.LOBS WHERE LOBS.LOB_ID = ? AND BLOCK_OFFSET + BLOCK_COUNT > ? AND BLOCK_OFFSET < ? ORDER BY BLOCK_OFFSET";
    private static final String deleteLobPartCallSQL = "CALL SYSTEM_LOBS.DELETE_BLOCKS(?,?,?,?)";
    private static final String createLobSQL = "INSERT INTO SYSTEM_LOBS.LOB_IDS VALUES(?, ?, ?, ?)";
    private static final String updateLobLengthSQL = "UPDATE SYSTEM_LOBS.LOB_IDS SET LOB_LENGTH = ? WHERE LOB_IDS.LOB_ID = ?";
    private static final String createLobPartCallSQL = "CALL SYSTEM_LOBS.ALLOC_BLOCKS(?, ?, ?)";
    private static final String createSingleLobPartCallSQL = "CALL SYSTEM_LOBS.ALLOC_SINGLE_BLOCK(?, ?, ?)";
    private static final String divideLobPartCallSQL = "CALL SYSTEM_LOBS.DIVIDE_BLOCK(?, ?)";
    private static final String updateLobUsageSQL = "UPDATE SYSTEM_LOBS.LOB_IDS SET LOB_USAGE_COUNT = LOB_USAGE_COUNT + ? WHERE LOB_IDS.LOB_ID = ?";
    private static final String getNextLobIdSQL = "VALUES NEXT VALUE FOR SYSTEM_LOBS.LOB_ID";
    private static final String deleteLobCallSQL = "CALL SYSTEM_LOBS.DELETE_LOB(?, ?)";
    private static final String deleteUnusedCallSQL = "CALL SYSTEM_LOBS.DELETE_UNUSED_LOBS(?,?)";
    private static final String mergeUnusedSpaceSQL = "CALL SYSTEM_LOBS.MERGE_EMPTY_BLOCKS()";
    private static final String getLobUseLimitSQL = "SELECT * FROM SYSTEM_LOBS.LOBS WHERE BLOCK_ADDR = (SELECT MAX(BLOCK_ADDR) FROM SYSTEM_LOBS.LOBS)";
    private static final String getLobCountSQL = "SELECT COUNT(*) FROM SYSTEM_LOBS.LOB_IDS";
    private static final String getPartsSQL = "SELECT BLOCK_COUNT, BLOCK_OFFSET, PART_OFFSET, PART_LENGTH, PART_BYTES, LOB_ID FROM SYSTEM_LOBS.PARTS WHERE LOB_ID = ?  AND PART_OFFSET + PART_LENGTH > ? AND PART_OFFSET < ? ORDER BY BLOCK_OFFSET";
    private static final String getLastPartSQL = "SELECT BLOCK_COUNT, BLOCK_OFFSET, PART_OFFSET, PART_LENGTH, PART_BYTES, LOB_ID FROM SYSTEM_LOBS.PARTS WHERE LOB_ID = ? ORDER BY LOB_ID DESC, BLOCK_OFFSET DESC LIMIT 1";
    private static final String createPartSQL = "INSERT INTO SYSTEM_LOBS.PARTS VALUES ?,?,?,?,?,?";

    public LobManager(Database database) {
        this.database = database;
    }

    public void lock() {
        this.writeLock.lock();
    }

    public void unlock() {
        this.writeLock.unlock();
    }

    public void createSchema() {
        this.sysLobSession = this.database.sessionManager.getSysLobSession();
        OrderedHashMap orderedHashMap = LineGroupReader.getStatementMap(resourceFileName);
        String string = (String)orderedHashMap.get("/*lob_schema_definition*/");
        Statement statement = this.sysLobSession.compileStatement(string);
        Result result = statement.execute(this.sysLobSession);
        if (result.isError()) {
            throw result.getException();
        }
        this.database.schemaManager.getSchemaHsqlName("SYSTEM_LOBS");
        this.compileStatements();
    }

    public void compileStatements() {
        this.writeLock.lock();
        try {
            this.getLob = this.sysLobSession.compileStatement(getLobSQL);
            this.getSpanningBlocks = this.sysLobSession.compileStatement(getLobPartSQL);
            this.createLob = this.sysLobSession.compileStatement(createLobSQL);
            this.createLobPartCall = this.sysLobSession.compileStatement(createLobPartCallSQL);
            this.createSingleLobPartCall = this.sysLobSession.compileStatement(createSingleLobPartCallSQL);
            this.divideLobPartCall = this.sysLobSession.compileStatement(divideLobPartCallSQL);
            this.deleteLobCall = this.sysLobSession.compileStatement(deleteLobCallSQL);
            this.deleteLobPartCall = this.sysLobSession.compileStatement(deleteLobPartCallSQL);
            this.updateLobLength = this.sysLobSession.compileStatement(updateLobLengthSQL);
            this.updateLobUsage = this.sysLobSession.compileStatement(updateLobUsageSQL);
            this.getNextLobId = this.sysLobSession.compileStatement(getNextLobIdSQL);
            this.deleteUnusedLobs = this.sysLobSession.compileStatement(deleteUnusedCallSQL);
            this.mergeUnusedSpace = this.sysLobSession.compileStatement(mergeUnusedSpaceSQL);
            this.getLobUseLimit = this.sysLobSession.compileStatement(getLobUseLimitSQL);
            this.getLobCount = this.sysLobSession.compileStatement(getLobCountSQL);
            this.getSpanningParts = this.sysLobSession.compileStatement(getPartsSQL);
            this.getLastPart = this.sysLobSession.compileStatement(getLastPartSQL);
            this.createPart = this.sysLobSession.compileStatement(createPartSQL);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void initialiseLobSpace() {
        Statement statement = this.sysLobSession.compileStatement(existsBlocksSQL);
        Result result = statement.execute(this.sysLobSession);
        if (result.isError()) {
            throw result.getException();
        }
        RowSetNavigator rowSetNavigator = result.getNavigator();
        int n = rowSetNavigator.getSize();
        if (n > 0) {
            return;
        }
        statement = this.sysLobSession.compileStatement(initialiseBlocksSQL);
        Object[] objectArray = new Object[]{ValuePool.INTEGER_0, ValuePool.getInt(this.totalBlockLimitCount), ValuePool.getLong(0L)};
        this.sysLobSession.executeCompiledStatement(statement, objectArray, 0);
    }

    public void open() {
        this.lobBlockSize = this.database.logger.getLobBlockSize();
        this.cryptLobs = this.database.logger.cryptLobs;
        this.compressLobs = this.database.logger.propCompressLobs;
        if (this.compressLobs || this.cryptLobs) {
            int n = this.largeLobBlockSize + 32768;
            this.inflater = new Inflater();
            this.deflater = new Deflater(1);
            this.dataBuffer = new byte[n];
        }
        switch (this.database.getType()) {
            case DB_FILE: {
                this.lobStore = new LobStoreRAFile(this.database, this.lobBlockSize);
                if (this.database.isFilesReadOnly()) break;
                this.byteBuffer = new byte[this.lobBlockSize];
                this.initialiseLobSpace();
                break;
            }
            case DB_RES: {
                this.lobStore = new LobStoreInJar(this.database, this.lobBlockSize);
                break;
            }
            case DB_MEM: {
                this.lobStore = new LobStoreMem(this.lobBlockSize);
                this.byteBuffer = new byte[this.lobBlockSize];
                this.initialiseLobSpace();
            }
        }
    }

    public void close() {
        if (this.lobStore != null) {
            this.lobStore.close();
        }
        this.lobStore = null;
    }

    public LobStore getLobStore() {
        if (this.lobStore == null) {
            this.open();
        }
        return this.lobStore;
    }

    private Long getNewLobID() {
        Result result = this.getNextLobId.execute(this.sysLobSession);
        if (result.isError()) {
            return 0L;
        }
        RowSetNavigator rowSetNavigator = result.getNavigator();
        boolean bl = rowSetNavigator.next();
        if (!bl) {
            rowSetNavigator.release();
            return 0L;
        }
        Object[] objectArray = rowSetNavigator.getCurrent();
        rowSetNavigator.release();
        return (Long)objectArray[0];
    }

    private Object[] getLobHeader(long l) {
        ResultMetaData resultMetaData = this.getLob.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l);
        this.sysLobSession.sessionContext.pushDynamicArguments(objectArray);
        Result result = this.getLob.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        if (result.isError()) {
            throw result.getException();
        }
        RowSetNavigator rowSetNavigator = result.getNavigator();
        boolean bl = rowSetNavigator.next();
        Object[] objectArray2 = null;
        if (bl) {
            objectArray2 = rowSetNavigator.getCurrent();
        }
        rowSetNavigator.release();
        return objectArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobData getBlob(long l) {
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                BlobData blobData = null;
                return blobData;
            }
            BlobDataID blobDataID = new BlobDataID(l);
            return blobDataID;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClobData getClob(long l) {
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                ClobData clobData = null;
                return clobData;
            }
            ClobDataID clobDataID = new ClobDataID(l);
            return clobDataID;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createBlob(Session session, long l) {
        this.writeLock.lock();
        try {
            Long l2 = this.getNewLobID();
            ResultMetaData resultMetaData = this.createLob.getParametersMetaData();
            Object[] objectArray = new Object[resultMetaData.getColumnCount()];
            objectArray[0] = l2;
            objectArray[1] = ValuePool.getLong(l);
            objectArray[2] = ValuePool.INTEGER_0;
            objectArray[3] = ValuePool.getInt(30);
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, objectArray, 0);
            long l3 = l2;
            return l3;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createClob(Session session, long l) {
        this.writeLock.lock();
        try {
            Long l2 = this.getNewLobID();
            ResultMetaData resultMetaData = this.createLob.getParametersMetaData();
            Object[] objectArray = new Object[resultMetaData.getColumnCount()];
            objectArray[0] = l2;
            objectArray[1] = ValuePool.getLong(l);
            objectArray[2] = ValuePool.INTEGER_0;
            objectArray[3] = ValuePool.getInt(40);
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, objectArray, 0);
            long l3 = l2;
            return l3;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result deleteLob(long l) {
        this.writeLock.lock();
        try {
            ResultMetaData resultMetaData = this.deleteLobCall.getParametersMetaData();
            Object[] objectArray = new Object[resultMetaData.getColumnCount()];
            objectArray[0] = ValuePool.getLong(l);
            objectArray[1] = ValuePool.getLong(0L);
            Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobCall, objectArray, 0);
            this.usageChanged += (long)this.lobBlockSize;
            Result result2 = result;
            return result2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long getUsageChanged() {
        return this.usageChanged;
    }

    public void setUsageChanged() {
        this.usageChanged += (long)this.lobBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result deleteUnusedLobs() {
        this.writeLock.lock();
        try {
            long l;
            if (this.lobStore == null || this.byteBuffer == null || this.usageChanged == 0L) {
                Result result = Result.updateZeroResult;
                return result;
            }
            long l2 = Long.MAX_VALUE;
            ResultMetaData resultMetaData = this.deleteUnusedLobs.getParametersMetaData();
            Object[] objectArray = new Object[resultMetaData.getColumnCount()];
            int n = 0;
            objectArray[0] = l2;
            Result result = this.sysLobSession.executeCompiledStatement(this.deleteUnusedLobs, objectArray, 0);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            if (objectArray[1] != null && (n = ((Number)objectArray[1]).intValue()) < 1) {
                Result result3 = Result.updateZeroResult;
                return result3;
            }
            result = this.sysLobSession.executeCompiledStatement(this.mergeUnusedSpace, ValuePool.emptyObjectArray, 0);
            if (result.isError()) {
                Result result4 = result;
                return result4;
            }
            result = this.sysLobSession.executeCompiledStatement(this.getLobUseLimit, ValuePool.emptyObjectArray, 0);
            if (result.isError()) {
                Result result5 = result;
                return result5;
            }
            this.usageChanged = 0L;
            long l3 = 0L;
            RowSetNavigator rowSetNavigator = result.getNavigator();
            boolean bl = rowSetNavigator.next();
            if (bl) {
                Object[] objectArray2 = rowSetNavigator.getCurrent();
                if (objectArray2[0] == null || objectArray2[1] == null) {
                    Result result6 = Result.updateOneResult;
                    return result6;
                }
                l3 = (Integer)objectArray2[0] + (Integer)objectArray2[1];
                l3 *= (long)this.lobBlockSize;
            }
            if ((l = this.lobStore.getLength()) > l3) {
                this.database.logger.logInfoEvent("lob file truncated to usage");
                this.lobStore.setLength(l3);
                try {
                    this.lobStore.synch();
                }
                catch (Throwable throwable) {}
            } else if (l < l3) {
                this.database.logger.logInfoEvent("lob file reported smaller than usage");
            }
            Result result7 = Result.newUpdateCountResult(n);
            return result7;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getLength(long l) {
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                throw Error.error(1852);
            }
            long l2 = (Long)objectArray[1];
            int n = (Integer)objectArray[3];
            ResultLob resultLob = ResultLob.newLobSetResponse(l, l2);
            return resultLob;
        }
        catch (HsqlException hsqlException) {
            Result result = Result.newErrorResult(hsqlException);
            return result;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(long l, byte[] byArray) {
        this.writeLock.lock();
        try {
            int n;
            Object[] objectArray = this.getLobHeader(l);
            long l2 = (Long)objectArray[1];
            int[][] nArray = this.getBlockAddresses(l, 0, Integer.MAX_VALUE);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (l2 == 0L) {
                int n5 = byArray.length == 0 ? 0 : -1;
                return n5;
            }
            if (byArray.length == 0) {
                int n6 = 1;
                return n6;
            }
            do {
                n = nArray[n2][0] + n4;
                byte[] byArray2 = this.getLobStore().getBlockBytes(n, 1);
                for (int i = 0; i < byArray2.length; ++i) {
                    if (n3 + i >= byArray.length) {
                        if (l2 == (long)byArray.length) {
                            int n7 = 0;
                            return n7;
                        }
                        int n8 = 1;
                        return n8;
                    }
                    if (byArray2[i] == byArray[n3 + i]) continue;
                    int n9 = (byArray2[i] & 0xFF) > (byArray[n3 + i] & 0xFF) ? 1 : -1;
                    return n9;
                }
                n3 += this.lobBlockSize;
                if (++n4 != nArray[n2][1]) continue;
                n4 = 0;
                ++n2;
            } while (n2 != nArray.length && n3 < byArray.length);
            if (l2 == (long)byArray.length) {
                n = 0;
                return n;
            }
            n = l2 > (long)byArray.length ? 1 : -1;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(BlobData blobData, BlobData blobData2) {
        if (blobData.getId() == blobData2.getId()) {
            return 0;
        }
        this.writeLock.lock();
        try {
            if (this.compressLobs || this.cryptLobs) {
                int n = this.compareBytesCompressed(blobData.getId(), blobData2.getId());
                return n;
            }
            int n = this.compareBytesNormal(blobData.getId(), blobData2.getId());
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(Collation collation, long l, String string) {
        this.writeLock.lock();
        try {
            int n;
            Object[] objectArray = this.getLobHeader(l);
            long l2 = (Long)objectArray[1];
            int[][] nArray = this.getBlockAddresses(l, 0, Integer.MAX_VALUE);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (l2 == 0L) {
                int n5 = string.isEmpty() ? 0 : -1;
                return n5;
            }
            if (string.isEmpty()) {
                int n6 = 1;
                return n6;
            }
            do {
                String string2;
                int n7;
                n = nArray[n2][0] + n4;
                byte[] byArray = this.getLobStore().getBlockBytes(n, 1);
                long l3 = l2 - ((long)nArray[n2][2] + (long)n4) * (long)this.lobBlockSize / 2L;
                if (l3 > (long)(this.lobBlockSize / 2)) {
                    l3 = this.lobBlockSize / 2;
                }
                String string3 = new String(ArrayUtil.byteArrayToChars(byArray), 0, (int)l3);
                int n8 = string.length() - n3;
                if (n8 > this.lobBlockSize / 2) {
                    n8 = this.lobBlockSize / 2;
                }
                if ((n7 = collation.compare(string3, string2 = string.substring(n3, n3 + n8))) != 0) {
                    int n9 = n7;
                    return n9;
                }
                n3 += this.lobBlockSize / 2;
                if (++n4 != nArray[n2][1]) continue;
                n4 = 0;
                ++n2;
            } while (n2 != nArray.length && n3 < string.length());
            if (l2 == (long)string.length()) {
                n = 0;
                return n;
            }
            n = l2 > (long)string.length() ? 1 : -1;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(Collation collation, ClobData clobData, ClobData clobData2) {
        if (clobData.getId() == clobData2.getId()) {
            return 0;
        }
        this.writeLock.lock();
        try {
            if (this.compressLobs || this.cryptLobs) {
                int n = this.compareTextCompressed(collation, clobData.getId(), clobData2.getId());
                return n;
            }
            int n = this.compareTextNormal(collation, clobData.getId(), clobData2.getId());
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private int compareBytesNormal(long l, long l2) {
        Object[] objectArray = this.getLobHeader(l);
        long l3 = (Long)objectArray[1];
        objectArray = this.getLobHeader(l2);
        long l4 = (Long)objectArray[1];
        int[][] nArray = this.getBlockAddresses(l, 0, Integer.MAX_VALUE);
        int[][] nArray2 = this.getBlockAddresses(l2, 0, Integer.MAX_VALUE);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (l3 == 0L) {
            return l4 == 0L ? 0 : -1;
        }
        if (l4 == 0L) {
            return 1;
        }
        do {
            byte[] byArray;
            int n5 = nArray[n][0] + n3;
            int n6 = nArray2[n2][0] + n4;
            byte[] byArray2 = this.getLobStore().getBlockBytes(n5, 1);
            int n7 = ArrayUtil.compare(byArray2, byArray = this.getLobStore().getBlockBytes(n6, 1));
            if (n7 != 0) {
                return n7;
            }
            ++n4;
            if (++n3 == nArray[n][1]) {
                n3 = 0;
                ++n;
            }
            if (n4 != nArray2[n2][1]) continue;
            n4 = 0;
            ++n2;
        } while (n != nArray.length && n2 != nArray2.length);
        if (l3 == l4) {
            return 0;
        }
        return l3 > l4 ? 1 : -1;
    }

    private int compareTextNormal(Collation collation, long l, long l2) {
        Object[] objectArray = this.getLobHeader(l);
        long l3 = (Long)objectArray[1];
        objectArray = this.getLobHeader(l2);
        long l4 = (Long)objectArray[1];
        int[][] nArray = this.getBlockAddresses(l, 0, Integer.MAX_VALUE);
        int[][] nArray2 = this.getBlockAddresses(l2, 0, Integer.MAX_VALUE);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (l3 == 0L) {
            return l4 == 0L ? 0 : -1;
        }
        if (l4 == 0L) {
            return 1;
        }
        do {
            String string;
            String string2;
            int n5;
            long l5;
            int n6 = nArray[n][0] + n3;
            int n7 = nArray2[n2][0] + n4;
            byte[] byArray = this.getLobStore().getBlockBytes(n6, 1);
            byte[] byArray2 = this.getLobStore().getBlockBytes(n7, 1);
            long l6 = l3 - ((long)nArray[n][2] + (long)n3) * (long)this.lobBlockSize / 2L;
            if (l6 > (long)(this.lobBlockSize / 2)) {
                l6 = this.lobBlockSize / 2;
            }
            if ((l5 = l4 - ((long)nArray2[n2][2] + (long)n4) * (long)this.lobBlockSize / 2L) > (long)(this.lobBlockSize / 2)) {
                l5 = this.lobBlockSize / 2;
            }
            if ((n5 = collation.compare(string2 = new String(ArrayUtil.byteArrayToChars(byArray), 0, (int)l6), string = new String(ArrayUtil.byteArrayToChars(byArray2), 0, (int)l5))) != 0) {
                return n5;
            }
            ++n4;
            if (++n3 == nArray[n][1]) {
                n3 = 0;
                ++n;
            }
            if (n4 != nArray2[n2][1]) continue;
            n4 = 0;
            ++n2;
        } while (n != nArray.length && n2 != nArray2.length);
        if (l3 == l4) {
            return 0;
        }
        return l3 > l4 ? 1 : -1;
    }

    public Result getLob(long l, long l2, long l3) {
        if (l2 == 0L) {
            return this.createDuplicateLob(l, l3);
        }
        throw Error.runtimeError(201, "LobManager");
    }

    public Result createDuplicateLob(long l) {
        Result result = this.getLength(l);
        if (result.isError()) {
            return result;
        }
        return this.createDuplicateLob(l, ((ResultLob)result).getBlockLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result createDuplicateLob(long l, long l2) {
        if (this.byteBuffer == null) {
            throw Error.error(456);
        }
        this.writeLock.lock();
        try {
            Object object;
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                Result result = Result.newErrorResult(Error.error(1852));
                return result;
            }
            Long l3 = this.getNewLobID();
            Object[] objectArray2 = new Object[objectArray.length];
            objectArray2[0] = l3;
            objectArray2[1] = l2;
            objectArray2[2] = ValuePool.INTEGER_0;
            objectArray2[3] = objectArray[3];
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, objectArray2, 0);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            if (l2 == 0L) {
                ResultLob resultLob = ResultLob.newLobSetResponse(l3, l2);
                return resultLob;
            }
            long l4 = l2;
            int n = (Integer)objectArray[3];
            if (n == 40) {
                l4 *= 2L;
            }
            int n2 = (int)(l4 / (long)this.lobBlockSize);
            if (l4 % (long)this.lobBlockSize != 0L) {
                ++n2;
            }
            if ((result = this.createBlockAddresses(l3, 0, n2)).isError()) {
                Result result3 = result;
                return result3;
            }
            int[][] nArray = this.getBlockAddresses(l, 0, Integer.MAX_VALUE);
            int[][] nArray2 = this.getBlockAddresses(l3, 0, Integer.MAX_VALUE);
            try {
                this.copyBlockSet(nArray, nArray2);
            }
            catch (HsqlException hsqlException) {
                Result result4 = Result.newErrorResult(hsqlException);
                this.writeLock.unlock();
                return result4;
            }
            catch (Throwable throwable) {
                Result result5 = Result.newErrorResult(throwable);
                this.writeLock.unlock();
                return result5;
            }
            int n3 = (int)(l4 % (long)this.lobBlockSize);
            if (n3 != 0) {
                object = nArray2[nArray2.length - 1];
                int n4 = object[0] + object[1] - 1;
                byte[] byArray = this.getLobStore().getBlockBytes(n4, 1);
                ArrayUtil.fillArray(byArray, n3, (byte)0);
                this.getLobStore().setBlockBytes(byArray, n4, 1);
            }
            this.lobStore.synch();
            object = ResultLob.newLobSetResponse(l3, l2);
            return object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getTruncateLength(long l) {
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                throw Error.error(1852);
            }
            long l2 = (Long)objectArray[1];
            int n = (Integer)objectArray[3];
            ResultLob resultLob = ResultLob.newLobSetResponse(l, l2);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void copyBlockSet(int[][] nArray, int[][] nArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        do {
            byte[] byArray = this.getLobStore().getBlockBytes(nArray[n][0] + n3, 1);
            this.getLobStore().setBlockBytes(byArray, nArray2[n2][0] + n4, 1);
            ++n4;
            if (++n3 == nArray[n][1]) {
                n3 = 0;
                ++n;
            }
            if (n4 != nArray2[n2][1]) continue;
            n4 = 0;
            ++n2;
        } while (n != nArray.length && n2 != nArray2.length);
        this.storeModified = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getChars(long l, long l2, int n) {
        Result result;
        this.writeLock.lock();
        try {
            result = this.compressLobs || this.cryptLobs ? this.getBytesCompressed(l, l2 * 2L, n * 2) : this.getBytesNormal(l, l2 * 2L, n * 2);
        }
        finally {
            this.writeLock.unlock();
        }
        if (result.isError()) {
            return result;
        }
        byte[] byArray = ((ResultLob)result).getByteArray();
        char[] cArray = ArrayUtil.byteArrayToChars(byArray);
        return ResultLob.newLobGetCharsResponse(l, l2, cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getBytes(long l, long l2, int n) {
        this.writeLock.lock();
        try {
            if (this.compressLobs || this.cryptLobs) {
                Result result = this.getBytesCompressed(l, l2, n);
                return result;
            }
            Result result = this.getBytesNormal(l, l2, n);
            return result;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Result getBytesNormal(long l, long l2, int n) {
        byte[] byArray;
        int n2 = (int)(l2 / (long)this.lobBlockSize);
        int n3 = (int)(l2 % (long)this.lobBlockSize);
        int n4 = (int)((l2 + (long)n) / (long)this.lobBlockSize);
        int n5 = (int)((l2 + (long)n) % (long)this.lobBlockSize);
        if (n5 == 0) {
            n5 = this.lobBlockSize;
        } else {
            ++n4;
        }
        if (n == 0) {
            return ResultLob.newLobGetBytesResponse(l, l2, BinaryData.zeroLengthBytes);
        }
        int n6 = 0;
        byte[] byArray2 = new byte[n];
        int[][] nArray = this.getBlockAddresses(l, n2, n4);
        if (nArray.length == 0) {
            return Result.newErrorResult(Error.error(1852));
        }
        int n7 = 0;
        int n8 = nArray[n7][1] + nArray[n7][2] - n2;
        if (nArray[n7][1] + nArray[n7][2] > n4) {
            n8 -= nArray[n7][1] + nArray[n7][2] - n4;
        }
        try {
            byArray = this.getLobStore().getBlockBytes(nArray[n7][0] - nArray[n7][2] + n2, n8);
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException);
        }
        int n9 = this.lobBlockSize * n8 - n3;
        if (n9 > n) {
            n9 = n;
        }
        System.arraycopy(byArray, n3, byArray2, n6, n9);
        n6 += n9;
        ++n7;
        while (n7 < nArray.length && n6 < n) {
            n8 = nArray[n7][1];
            if (nArray[n7][1] + nArray[n7][2] > n4) {
                n8 -= nArray[n7][1] + nArray[n7][2] - n4;
            }
            try {
                byArray = this.getLobStore().getBlockBytes(nArray[n7][0], n8);
            }
            catch (HsqlException hsqlException) {
                return Result.newErrorResult(hsqlException);
            }
            n9 = this.lobBlockSize * n8;
            if (n9 > n - n6) {
                n9 = n - n6;
            }
            System.arraycopy(byArray, 0, byArray2, n6, n9);
            n6 += n9;
            ++n7;
        }
        return ResultLob.newLobGetBytesResponse(l, l2, byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result setBytesBA(long l, long l2, byte[] byArray, int n) {
        if (n == 0) {
            return ResultLob.newLobSetResponse(l, 0L);
        }
        this.writeLock.lock();
        try {
            if (this.compressLobs || this.cryptLobs) {
                Result result = this.setBytesBACompressed(l, l2, byArray, n);
                return result;
            }
            Result result = this.setBytesBANormal(l, l2, byArray, n);
            return result;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Result setBytesBANormal(long l, long l2, byte[] byArray, int n) {
        boolean bl = false;
        int n2 = (int)(l2 / (long)this.lobBlockSize);
        int n3 = (int)(l2 % (long)this.lobBlockSize);
        int n4 = (int)((l2 + (long)n) / (long)this.lobBlockSize);
        int n5 = (int)((l2 + (long)n) % (long)this.lobBlockSize);
        if (n5 == 0) {
            n5 = this.lobBlockSize;
        } else {
            ++n4;
        }
        int[][] nArray = this.getBlockAddresses(l, n2, n4);
        int n6 = n2;
        if (nArray.length > 0) {
            n6 = nArray[nArray.length - 1][2] + nArray[nArray.length - 1][1];
        }
        if (n6 < n4) {
            this.createBlockAddresses(l, n6, n4 - n6);
            nArray = this.getBlockAddresses(l, n2, n4);
            bl = true;
        }
        int n7 = 0;
        int n8 = n;
        try {
            for (int i = 0; i < nArray.length; ++i) {
                long l3 = (long)nArray[i][2] * (long)this.lobBlockSize;
                long l4 = (long)nArray[i][1] * (long)this.lobBlockSize;
                long l5 = (long)nArray[i][0] * (long)this.lobBlockSize;
                int n9 = 0;
                if (l2 > l3) {
                    l4 -= l2 - l3;
                    l5 += l2 - l3;
                }
                if ((long)n8 < l4) {
                    if (bl) {
                        n9 = (int)((l4 - (long)n8) % (long)this.lobBlockSize);
                    }
                    l4 = n8;
                }
                this.getLobStore().setBlockBytes(byArray, l5, n7, (int)l4);
                if (n9 != 0) {
                    ArrayUtil.fillArray(this.byteBuffer, 0, (byte)0);
                    this.getLobStore().setBlockBytes(this.byteBuffer, l5 + l4, 0, n9);
                }
                n7 = (int)((long)n7 + l4);
                n8 = (int)((long)n8 - l4);
            }
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException);
        }
        this.lobStore.synch();
        this.storeModified = true;
        return ResultLob.newLobSetResponse(l, n);
    }

    private Result setBytesIS(long l, InputStream inputStream, long l2, long l3) {
        if (l3 == 0L) {
            return ResultLob.newLobSetResponse(l, 0L);
        }
        if (this.compressLobs || this.cryptLobs) {
            return this.setBytesISCompressed(l, inputStream, l2, l3);
        }
        return this.setBytesISNormal(l, inputStream, l3);
    }

    private Result setBytesISNormal(long l, InputStream inputStream, long l2) {
        long l3 = 0L;
        int n = (int)(l2 / (long)this.lobBlockSize);
        int n2 = (int)(l2 % (long)this.lobBlockSize);
        if (n2 == 0) {
            n2 = this.lobBlockSize;
        } else {
            ++n;
        }
        Result result = this.createBlockAddresses(l, 0, n);
        int[][] nArray = this.getBlockAddresses(l, 0, n);
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i][1]; ++j) {
                int n3 = this.lobBlockSize;
                ArrayUtil.fillArray(this.byteBuffer, 0, (byte)0);
                if (i == nArray.length - 1 && j == nArray[i][1] - 1) {
                    n3 = n2;
                }
                try {
                    int n4;
                    int n5 = 0;
                    while (n3 > 0 && (n4 = inputStream.read(this.byteBuffer, n5, n3)) != -1) {
                        n3 -= n4;
                        n5 += n4;
                    }
                    l3 += (long)n5;
                }
                catch (IOException iOException) {
                    return Result.newErrorResult(iOException);
                }
                try {
                    this.getLobStore().setBlockBytes(this.byteBuffer, nArray[i][0] + j, 1);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException);
                }
            }
        }
        this.storeModified = true;
        this.lobStore.synch();
        return ResultLob.newLobSetResponse(l, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setBytes(long l, long l2, byte[] byArray, int n) {
        if (this.byteBuffer == null) {
            throw Error.error(456);
        }
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                Result result = Result.newErrorResult(Error.error(1852));
                return result;
            }
            long l3 = (Long)objectArray[1];
            if (n == 0) {
                ResultLob resultLob = ResultLob.newLobSetResponse(l, l3);
                return resultLob;
            }
            Result result = this.setBytesBA(l, l2, byArray, n);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            if (l2 + (long)n > l3 && (result = this.setLength(l, l3 = l2 + (long)n)).isError()) {
                Result result3 = result;
                return result3;
            }
            ResultLob resultLob = ResultLob.newLobSetResponse(l, l3);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setBytesForNewBlob(long l, InputStream inputStream, long l2) {
        if (this.byteBuffer == null) {
            return Result.newErrorResult(Error.error(456));
        }
        this.writeLock.lock();
        try {
            Result result = this.setBytesIS(l, inputStream, 0L, l2);
            Result result2 = Result.updateZeroResult;
            if (result.isError()) {
                Result result3 = result;
                return result3;
            }
            long l3 = ((ResultLob)result).getBlockLength();
            if (l3 < l2) {
                result2 = this.truncate(l, l3);
            }
            if (result2.isError()) {
                Result result4 = result2;
                return result4;
            }
            Result result5 = result;
            return result5;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setChars(long l, long l2, char[] cArray, int n) {
        if (this.byteBuffer == null) {
            throw Error.error(456);
        }
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                Result result = Result.newErrorResult(Error.error(1852));
                return result;
            }
            long l3 = (Long)objectArray[1];
            if (n == 0) {
                ResultLob resultLob = ResultLob.newLobSetResponse(l, l3);
                return resultLob;
            }
            byte[] byArray = ArrayUtil.charArrayToBytes(cArray, n);
            Result result = this.setBytesBA(l, l2 * 2L, byArray, n * 2);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            if (l2 + (long)n > l3 && (result = this.setLength(l, l3 = l2 + (long)n)).isError()) {
                Result result3 = result;
                return result3;
            }
            ResultLob resultLob = ResultLob.newLobSetResponse(l, l3);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setCharsForNewClob(long l, InputStream inputStream, long l2) {
        if (this.byteBuffer == null) {
            throw Error.error(456);
        }
        this.writeLock.lock();
        try {
            Result result;
            Result result2 = this.setBytesIS(l, inputStream, 0L, l2 * 2L);
            if (result2.isError()) {
                Result result3 = result2;
                return result3;
            }
            long l3 = ((ResultLob)result2).getBlockLength();
            if (l3 < l2) {
                result = this.truncate(l, l3);
            }
            result = result2;
            return result;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result truncate(long l, long l2) {
        if (this.byteBuffer == null) {
            throw Error.error(456);
        }
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                Result result = Result.newErrorResult(Error.error(1852));
                return result;
            }
            long l3 = (Long)objectArray[1];
            long l4 = l2;
            if ((Integer)objectArray[3] == 40) {
                l4 *= 2L;
            }
            int n = (int)((l4 + (long)this.lobBlockSize - 1L) / (long)this.lobBlockSize);
            ResultMetaData resultMetaData = this.deleteLobPartCall.getParametersMetaData();
            Object[] objectArray2 = new Object[resultMetaData.getColumnCount()];
            objectArray2[0] = ValuePool.getLong(l);
            objectArray2[1] = n;
            objectArray2[2] = ValuePool.INTEGER_MAX;
            objectArray2[3] = ValuePool.getLong(this.sysLobSession.getTransactionSCN());
            Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobPartCall, objectArray2, 0);
            this.setLength(l, l2);
            ResultLob resultLob = ResultLob.newLobTruncateResponse(l, l2);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Result setLength(long l, long l2) {
        ResultMetaData resultMetaData = this.updateLobLength.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l2);
        objectArray[1] = ValuePool.getLong(l);
        Result result = this.sysLobSession.executeCompiledStatement(this.updateLobLength, objectArray, 0);
        return result;
    }

    public Result adjustUsageCount(Session session, long l, int n) {
        ResultMetaData resultMetaData = this.updateLobUsage.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getInt(n);
        objectArray[1] = ValuePool.getLong(l);
        session.sessionContext.pushDynamicArguments(objectArray);
        Result result = this.updateLobUsage.execute(session);
        if (n < 0) {
            this.usageChanged += (long)this.lobBlockSize;
        }
        session.sessionContext.pop();
        return result;
    }

    private int[][] getBlockAddresses(long l, int n, int n2) {
        ResultMetaData resultMetaData = this.getSpanningBlocks.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l);
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = ValuePool.getInt(n2);
        this.sysLobSession.sessionContext.pushDynamicArguments(objectArray);
        Result result = this.getSpanningBlocks.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        RowSetNavigator rowSetNavigator = result.getNavigator();
        int n3 = rowSetNavigator.getSize();
        int[][] nArray = new int[n3][3];
        for (int i = 0; i < n3; ++i) {
            rowSetNavigator.absolute(i);
            Object[] objectArray2 = rowSetNavigator.getCurrent();
            nArray[i][0] = (Integer)objectArray2[0];
            nArray[i][1] = (Integer)objectArray2[1];
            nArray[i][2] = (Integer)objectArray2[2];
        }
        rowSetNavigator.release();
        return nArray;
    }

    private void deleteBlockAddresses(long l, int n, int n2) {
        ResultMetaData resultMetaData = this.deleteLobPartCall.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l);
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = ValuePool.getInt(n2);
        objectArray[3] = ValuePool.getLong(this.sysLobSession.getTransactionSCN());
        Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobPartCall, objectArray, 0);
    }

    private void divideBlockAddresses(long l, int n) {
        ResultMetaData resultMetaData = this.divideLobPartCall.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getInt(n);
        objectArray[1] = ValuePool.getLong(l);
        Result result = this.sysLobSession.executeCompiledStatement(this.divideLobPartCall, objectArray, 0);
    }

    private Result createBlockAddresses(long l, int n, int n2) {
        ResultMetaData resultMetaData = this.createLobPartCall.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getInt(n2);
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = ValuePool.getLong(l);
        Result result = this.sysLobSession.executeCompiledStatement(this.createLobPartCall, objectArray, 0);
        return result;
    }

    private Result createFullBlockAddresses(long l, int n, int n2) {
        ResultMetaData resultMetaData = this.createSingleLobPartCall.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getInt(n2);
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = ValuePool.getLong(l);
        Result result = this.sysLobSession.executeCompiledStatement(this.createSingleLobPartCall, objectArray, 0);
        return result;
    }

    private Result createPart(long l, long l2, int n, int n2, int n3, int n4) {
        ResultMetaData resultMetaData = this.createPart.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getInt(n4);
        objectArray[1] = ValuePool.getInt(n3);
        objectArray[2] = ValuePool.getLong(l2);
        objectArray[3] = ValuePool.getLong(n);
        objectArray[4] = ValuePool.getLong(n2);
        objectArray[5] = ValuePool.getLong(l);
        Result result = this.sysLobSession.executeCompiledStatement(this.createPart, objectArray, 0);
        return result;
    }

    private int getBlockAddress(int[][] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i][2] + nArray[i][1] <= n) continue;
            return nArray[i][0] - nArray[i][2] + n;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLobCount() {
        this.writeLock.lock();
        try {
            this.sysLobSession.sessionContext.pushDynamicArguments(new Object[0]);
            Result result = this.getLobCount.execute(this.sysLobSession);
            this.sysLobSession.sessionContext.pop();
            RowSetNavigator rowSetNavigator = result.getNavigator();
            boolean bl = rowSetNavigator.next();
            if (!bl) {
                rowSetNavigator.release();
                int n = 0;
                return n;
            }
            Object[] objectArray = rowSetNavigator.getCurrent();
            int n = ((Number)objectArray[0]).intValue();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void synch() {
        if (this.storeModified && this.lobStore != null) {
            this.writeLock.lock();
            try {
                try {
                    this.lobStore.synch();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.storeModified = false;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private long[][] getParts(long l, long l2, long l3) {
        ResultMetaData resultMetaData = this.getSpanningParts.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l);
        objectArray[1] = ValuePool.getLong(l2);
        objectArray[2] = ValuePool.getLong(l3);
        this.sysLobSession.sessionContext.pushDynamicArguments(objectArray);
        Result result = this.getSpanningParts.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        RowSetNavigator rowSetNavigator = result.getNavigator();
        int n = rowSetNavigator.getSize();
        long[][] lArray = new long[n][6];
        for (int i = 0; i < n; ++i) {
            rowSetNavigator.absolute(i);
            Object[] objectArray2 = rowSetNavigator.getCurrent();
            for (int j = 0; j < lArray[i].length; ++j) {
                lArray[i][j] = ((Number)objectArray2[j]).longValue();
            }
        }
        rowSetNavigator.release();
        return lArray;
    }

    private void inflate(byte[] byArray, int n) {
        if (this.cryptLobs) {
            n = this.database.logger.getCrypto().decode(byArray, 0, n, byArray, 0);
        }
        try {
            this.inflater.setInput(byArray, 0, n);
            n = this.inflater.inflate(this.dataBuffer);
            this.inflater.reset();
        }
        catch (DataFormatException dataFormatException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int n2 = (int)ArrayUtil.getBinaryMultipleCeiling(n, this.lobBlockSize);
        for (int i = n; i < n2; ++i) {
            this.dataBuffer[i] = 0;
        }
    }

    private int deflate(byte[] byArray, int n, int n2) {
        this.deflater.setInput(byArray, n, n2);
        this.deflater.finish();
        n2 = this.deflater.deflate(this.dataBuffer);
        this.deflater.reset();
        if (this.cryptLobs) {
            n2 = this.database.logger.getCrypto().encode(this.dataBuffer, 0, n2, this.dataBuffer, 0);
        }
        int n3 = (int)ArrayUtil.getBinaryMultipleCeiling(n2, this.lobBlockSize);
        for (int i = n2; i < n3; ++i) {
            this.dataBuffer[i] = 0;
        }
        return n2;
    }

    private int compareBytesCompressed(long l, long l2) {
        long[][] lArray = this.getParts(l, 0L, Long.MAX_VALUE);
        long[][] lArray2 = this.getParts(l2, 0L, Long.MAX_VALUE);
        for (int i = 0; i < lArray.length && i < lArray2.length; ++i) {
            int n = (int)lArray[i][3];
            this.getPartBytesCompressedInBuffer(l, lArray[i]);
            byte[] byArray = new byte[n];
            System.arraycopy(this.dataBuffer, 0, byArray, 0, n);
            int n2 = (int)lArray2[i][3];
            this.getPartBytesCompressedInBuffer(l, lArray2[i]);
            int n3 = ArrayUtil.compare(byArray, 0, n, this.byteBuffer, 0, n2);
            if (n3 == 0) continue;
            return n3;
        }
        if (lArray.length == lArray2.length) {
            return 0;
        }
        return lArray.length > lArray2.length ? 1 : -1;
    }

    private int compareTextCompressed(Collation collation, long l, long l2) {
        long[][] lArray = this.getParts(l, 0L, Long.MAX_VALUE);
        long[][] lArray2 = this.getParts(l2, 0L, Long.MAX_VALUE);
        for (int i = 0; i < lArray.length && i < lArray2.length; ++i) {
            int n = (int)lArray[i][3];
            this.getPartBytesCompressedInBuffer(l, lArray[i]);
            String string = new String(ArrayUtil.byteArrayToChars(this.dataBuffer, n));
            int n2 = (int)lArray2[i][3];
            this.getPartBytesCompressedInBuffer(l2, lArray2[i]);
            String string2 = new String(ArrayUtil.byteArrayToChars(this.dataBuffer, n2));
            int n3 = collation.compare(string, string2);
            if (n3 == 0) continue;
            return n3;
        }
        if (lArray.length == lArray2.length) {
            return 0;
        }
        return lArray.length > lArray2.length ? 1 : -1;
    }

    private Result setBytesISCompressed(long l, InputStream inputStream, long l2, long l3) {
        int n;
        long l4 = 0L;
        byte[] byArray = new byte[this.largeLobBlockSize];
        do {
            int n2;
            if ((long)(n2 = byArray.length) > l3 - l4) {
                n2 = (int)(l3 - l4);
            }
            n = 0;
            try {
                while (n2 > 0) {
                    int n3 = inputStream.read(byArray, n, n2);
                    if (n3 == -1) {
                        return Result.newErrorResult(new EOFException());
                    }
                    n2 -= n3;
                    n += n3;
                }
            }
            catch (IOException iOException) {
                return Result.newErrorResult(iOException);
            }
            Result result = this.setBytesBACompressedPart(l, l2, byArray, n);
            if (result.isError()) {
                return result;
            }
            l2 += (long)n;
        } while ((l4 += (long)n) != l3);
        this.storeModified = true;
        return ResultLob.newLobSetResponse(l, l3);
    }

    private Result setBytesBACompressed(long l, long l2, byte[] byArray, int n) {
        if (n == 0) {
            return ResultLob.newLobSetResponse(l, 0L);
        }
        if (n <= this.largeLobBlockSize) {
            return this.setBytesBACompressedPart(l, l2, byArray, n);
        }
        HsqlByteArrayInputStream hsqlByteArrayInputStream = new HsqlByteArrayInputStream(byArray, 0, n);
        return this.setBytesISCompressed(l, hsqlByteArrayInputStream, l2, n);
    }

    private Result setBytesBACompressedPart(long l, long l2, byte[] byArray, int n) {
        long[] lArray = this.getLastPart(l);
        int n2 = (int)lArray[1] + (int)lArray[0];
        long l3 = lArray[2] + lArray[3];
        if (l3 != l2 || l3 % (long)this.largeLobBlockSize != 0L) {
            return Result.newErrorResult(Error.error(1551, "compressed lobs"));
        }
        int n3 = this.deflate(byArray, 0, n);
        int n4 = (n3 + this.lobBlockSize - 1) / this.lobBlockSize;
        Result result = this.createFullBlockAddresses(l, n2, n4);
        if (result.isError()) {
            return result;
        }
        result = this.createPart(l, l2, n, n3, n2, n4);
        if (result.isError()) {
            return result;
        }
        long l4 = (long)n2 * (long)this.lobBlockSize;
        int n5 = (int)ArrayUtil.getBinaryMultipleCeiling(n3, this.lobBlockSize);
        this.setBytesBANormal(l, l4, this.dataBuffer, n5);
        this.storeModified = true;
        return ResultLob.newLobSetResponse(l, n);
    }

    private Result getBytesCompressed(long l, long l2, int n) {
        byte[] byArray = new byte[n];
        long[][] lArray = this.getParts(l, l2, l2 + (long)n);
        for (int i = 0; i < lArray.length; ++i) {
            long[] lArray2 = lArray[i];
            long l3 = lArray2[2];
            int n2 = (int)lArray2[3];
            Result result = this.getPartBytesCompressedInBuffer(l, lArray2);
            if (result.isError()) {
                return result;
            }
            ArrayUtil.copyBytes(l3, this.dataBuffer, 0, n2, l2, byArray, n);
        }
        return ResultLob.newLobGetBytesResponse(l, l2, byArray);
    }

    private Result getPartBytesCompressedInBuffer(long l, long[] lArray) {
        long l2 = lArray[1];
        long l3 = lArray[2];
        long l4 = lArray[3];
        long l5 = l2 * (long)this.lobBlockSize;
        int n = (int)lArray[4];
        Result result = this.getBytesNormal(l, l5, n);
        if (result.isError()) {
            return result;
        }
        byte[] byArray = ((ResultLob)result).getByteArray();
        this.inflate(byArray, n);
        return ResultLob.newLobSetResponse(l, l4);
    }

    private long[] getLastPart(long l) {
        ResultMetaData resultMetaData = this.getLastPart.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l);
        this.sysLobSession.sessionContext.pushDynamicArguments(objectArray);
        Result result = this.getLastPart.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        RowSetNavigator rowSetNavigator = result.getNavigator();
        int n = rowSetNavigator.getSize();
        long[] lArray = new long[6];
        if (n == 0) {
            lArray[5] = l;
        } else {
            rowSetNavigator.absolute(0);
            Object[] objectArray2 = rowSetNavigator.getCurrent();
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = ((Number)objectArray2[i]).longValue();
            }
        }
        rowSetNavigator.release();
        return lArray;
    }

    private static interface ALLOC_PART {
        public static final int BLOCK_COUNT = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int PART_OFFSET = 2;
        public static final int PART_LENGTH = 3;
        public static final int PART_BYTES = 4;
        public static final int LOB_ID = 5;
    }

    private static interface UPDATE_LENGTH {
        public static final int LOB_LENGTH = 0;
        public static final int LOB_ID = 1;
    }

    private static interface UPDATE_USAGE {
        public static final int BLOCK_COUNT = 0;
        public static final int LOB_ID = 1;
    }

    private static interface ALLOC_BLOCKS {
        public static final int BLOCK_COUNT = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int LOB_ID = 2;
    }

    private static interface DELETE_BLOCKS {
        public static final int LOB_ID = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int BLOCK_LIMIT = 2;
        public static final int TX_ID = 3;
    }

    private static interface DIVIDE_BLOCK {
        public static final int BLOCK_OFFSET = 0;
        public static final int LOB_ID = 1;
    }

    private static interface GET_LOB_PART {
        public static final int LOB_ID = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int BLOCK_LIMIT = 2;
    }

    private static interface LOB_IDS {
        public static final int LOB_ID = 0;
        public static final int LOB_LENGTH = 1;
        public static final int LOB_USAGE_COUNT = 2;
        public static final int LOB_TYPE = 3;
    }

    static interface LOBS {
        public static final int BLOCK_ADDR = 0;
        public static final int BLOCK_COUNT = 1;
        public static final int BLOCK_OFFSET = 2;
        public static final int LOB_ID = 3;
    }
}

