/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.NestedProperty;
import org.directwebremoting.extend.Property;

public class PlainProperty
implements Property {
    private final String name;
    private final Object value;
    private static final Log log = LogFactory.getLog(PlainProperty.class);

    public PlainProperty(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getPropertyType() {
        return this.value.getClass();
    }

    @Override
    public Property createChild(int newParameterNumber) {
        return new NestedProperty(this, null, null, 0, newParameterNumber);
    }

    @Override
    public Object getValue(Object bean) throws ConversionException {
        return this.value;
    }

    @Override
    public void setValue(Object bean, Object value) throws ConversionException {
        log.warn((Object)"Attempt to setValue() on plain property.");
    }

    public int hashCode() {
        int hash = 141;
        return hash += this.name == null ? 2886 : this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PlainProperty that = (PlainProperty)obj;
        return this.name.equals(that.name);
    }

    public String toString() {
        return "PlainProperty[name=" + this.name + "]";
    }
}

