/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.extend.DownloadManager;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.io.FileTransfer;
import org.directwebremoting.io.OutputStreamLoader;
import org.directwebremoting.util.LocalUtil;

public class DownloadHandler
implements Handler {
    private DownloadManager downloadManager;
    protected String downloadHandlerUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        FileTransfer transfer;
        String id = request.getPathInfo();
        if (!id.startsWith(this.downloadHandlerUrl)) {
            response.sendError(404);
        }
        if ((transfer = this.downloadManager.getFileTransfer(id = id.substring(this.downloadHandlerUrl.length()))) == null) {
            response.sendError(404);
        } else {
            if (transfer.getSize() > 0L) {
                response.setContentLength((int)transfer.getSize());
            }
            String defaultType = "attachment";
            String type = null;
            String suppliedType = request.getParameter("contentDispositionType");
            if (suppliedType != null && suppliedType.matches("^[-A-Za-z]+$")) {
                type = suppliedType;
            }
            String filename = transfer.getFilename();
            if (type != null || filename != null) {
                response.setHeader("Content-disposition", (type != null ? type : defaultType) + (filename != null ? "; filename=\"" + filename + "\"" : ""));
            }
            response.setContentType(transfer.getMimeType());
            OutputStreamLoader loader = null;
            try {
                loader = transfer.getOutputStreamLoader();
                loader.load((OutputStream)response.getOutputStream());
            }
            finally {
                LocalUtil.close(loader);
            }
        }
    }

    public void setDownloadManager(DownloadManager downloadManager) {
        this.downloadManager = downloadManager;
    }

    public void setDownloadHandlerUrl(String downloadHandlerUrl) {
        this.downloadHandlerUrl = downloadHandlerUrl;
    }
}

