/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.config.ContentRoot;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.CliJavaModuleUtilsKt;
import org.jetbrains.kotlin.cli.jvm.config.JavaSourceRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRootBase;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootBase;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.modules.CliJavaModuleFinder;
import org.jetbrains.kotlin.cli.jvm.modules.JavaModuleGraph;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.resolve.jvm.KotlinCliJavaFileManager;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModule;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleInfo;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 G2\u00020\u0001:\u0003EFGBq\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0014\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0007J2\u0010&\u001a\u00020#2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00072\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0002J\u001e\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020-\u0018\u00010,2\u0006\u0010.\u001a\u00020\fH\u0002J\u001a\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010.\u001a\u00020\f2\u0006\u00101\u001a\u00020\u0010H\u0002J\u0012\u00102\u001a\u0004\u0018\u0001032\u0006\u0010.\u001a\u00020\fH\u0002J\"\u00104\u001a\u0004\u0018\u00010\f2\u0006\u0010.\u001a\u00020\f2\u000e\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010706H\u0002J\u0012\u00108\u001a\u0004\u0018\u0001072\u0006\u00109\u001a\u00020\fH\u0002J$\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002030\u00072\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0002J$\u0010@\u001a\u00020;2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\b2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u00070\u001f\u00a2\u0006\u0002\b X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver;", "", "psiManager", "Lcom/intellij/psi/PsiManager;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "additionalModules", "", "", "contentRootToVirtualFile", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/cli/jvm/config/JvmContentRootBase;", "Lcom/intellij/openapi/vfs/VirtualFile;", "javaModuleFinder", "Lorg/jetbrains/kotlin/cli/jvm/modules/CliJavaModuleFinder;", "requireStdlibModule", "", "outputDirectory", "javaFileManager", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinCliJavaFileManager;", "jdkRelease", "", "hasKotlinSources", "<init>", "(Lcom/intellij/psi/PsiManager;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/util/List;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/cli/jvm/modules/CliJavaModuleFinder;ZLcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/resolve/jvm/KotlinCliJavaFileManager;Ljava/lang/Integer;Z)V", "Ljava/lang/Integer;", "javaModuleGraph", "Lorg/jetbrains/kotlin/cli/jvm/modules/JavaModuleGraph;", "getJavaModuleGraph", "()Lorg/jetbrains/kotlin/cli/jvm/modules/JavaModuleGraph;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "reportErrors", "convertClasspathRoots", "Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$RootsAndModules;", "contentRoots", "Lorg/jetbrains/kotlin/cli/common/config/ContentRoot;", "computeRoots", "javaSourceRoots", "Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$RootWithPrefix;", "jvmClasspathRoots", "jvmModulePathRoots", "findSourceModuleInfo", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiJavaModule;", "root", "modularSourceRoot", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Explicit;", "hasOutputDirectoryInClasspath", "modularBinaryRoot", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "tryLoadVersionSpecificModuleInfo", "manifest", "Lkotlin/Lazy;", "Ljava/util/jar/Attributes;", "readManifestAttributes", "jarRoot", "addModularRoots", "", "modules", "result", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "file", "RootsAndModules", "RootWithPrefix", "Companion", "cli-base"})
@SourceDebugExtension(value={"SMAP\nClasspathRootsResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClasspathRootsResolver.kt\norg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n1761#2,3:321\n1056#2:338\n808#2,11:340\n774#2:351\n865#2,2:352\n1563#2:354\n1634#2,3:355\n1761#2,3:358\n3170#3,11:324\n3829#3:335\n4344#3,2:336\n1#4:339\n*S KotlinDebug\n*F\n+ 1 ClasspathRootsResolver.kt\norg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver\n*L\n121#1:321,3\n210#1:338\n230#1:340,11\n230#1:351\n230#1:352,2\n267#1:354\n267#1:355,3\n272#1:358,3\n152#1:324,11\n207#1:335\n207#1:336,2\n*E\n"})
public final class ClasspathRootsResolver {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiManager psiManager;
    @Nullable
    private final MessageCollector messageCollector;
    @NotNull
    private final List<String> additionalModules;
    @NotNull
    private final Function1<JvmContentRootBase, VirtualFile> contentRootToVirtualFile;
    @NotNull
    private final CliJavaModuleFinder javaModuleFinder;
    private final boolean requireStdlibModule;
    @Nullable
    private final VirtualFile outputDirectory;
    @NotNull
    private final KotlinCliJavaFileManager javaFileManager;
    @Nullable
    private final Integer jdkRelease;
    @NotNull
    private final JavaModuleGraph javaModuleGraph;
    @NotNull
    private final GlobalSearchScope searchScope;
    private final boolean reportErrors;
    @Deprecated
    @NotNull
    public static final String AUTOMATIC_MODULE_NAME = "Automatic-Module-Name";
    @Deprecated
    @NotNull
    public static final String IS_MULTI_RELEASE = "Multi-Release";

    public ClasspathRootsResolver(@NotNull PsiManager psiManager, @Nullable MessageCollector messageCollector, @NotNull List<String> additionalModules, @NotNull Function1<? super JvmContentRootBase, ? extends VirtualFile> contentRootToVirtualFile, @NotNull CliJavaModuleFinder javaModuleFinder, boolean requireStdlibModule, @Nullable VirtualFile outputDirectory, @NotNull KotlinCliJavaFileManager javaFileManager, @Nullable Integer jdkRelease, boolean hasKotlinSources) {
        Intrinsics.checkNotNullParameter(psiManager, "psiManager");
        Intrinsics.checkNotNullParameter(additionalModules, "additionalModules");
        Intrinsics.checkNotNullParameter(contentRootToVirtualFile, "contentRootToVirtualFile");
        Intrinsics.checkNotNullParameter(javaModuleFinder, "javaModuleFinder");
        Intrinsics.checkNotNullParameter(javaFileManager, "javaFileManager");
        this.psiManager = psiManager;
        this.messageCollector = messageCollector;
        this.additionalModules = additionalModules;
        this.contentRootToVirtualFile = contentRootToVirtualFile;
        this.javaModuleFinder = javaModuleFinder;
        this.requireStdlibModule = requireStdlibModule;
        this.outputDirectory = outputDirectory;
        this.javaFileManager = javaFileManager;
        this.jdkRelease = jdkRelease;
        this.javaModuleGraph = new JavaModuleGraph(this.javaModuleFinder);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.psiManager.getProject());
        Intrinsics.checkNotNullExpressionValue(globalSearchScope, "allScope(...)");
        this.searchScope = globalSearchScope;
        this.reportErrors = hasKotlinSources;
    }

    @NotNull
    public final JavaModuleGraph getJavaModuleGraph() {
        return this.javaModuleGraph;
    }

    @NotNull
    public final RootsAndModules convertClasspathRoots(@NotNull List<? extends ContentRoot> contentRoots) {
        Intrinsics.checkNotNullParameter(contentRoots, "contentRoots");
        List javaSourceRoots = new ArrayList();
        List jvmClasspathRoots = new ArrayList();
        List jvmModulePathRoots = new ArrayList();
        for (ContentRoot contentRoot : contentRoots) {
            VirtualFile root;
            if (!(contentRoot instanceof JvmContentRootBase) || this.contentRootToVirtualFile.invoke((JvmContentRootBase)contentRoot) == null) continue;
            JvmContentRootBase jvmContentRootBase = (JvmContentRootBase)contentRoot;
            if (jvmContentRootBase instanceof JavaSourceRoot) {
                ((Collection)javaSourceRoots).add(new RootWithPrefix(root, ((JavaSourceRoot)contentRoot).getPackagePrefix()));
                continue;
            }
            if (jvmContentRootBase instanceof JvmClasspathRootBase) {
                ((Collection)jvmClasspathRoots).add(root);
                continue;
            }
            if (jvmContentRootBase instanceof JvmModulePathRoot) {
                ((Collection)jvmModulePathRoots).add(root);
                continue;
            }
            throw new IllegalStateException(("Unknown root type: " + contentRoot).toString());
        }
        return this.computeRoots(javaSourceRoots, jvmClasspathRoots, jvmModulePathRoots);
    }

    /*
     * WARNING - void declaration
     */
    private final RootsAndModules computeRoots(List<RootWithPrefix> javaSourceRoots, List<? extends VirtualFile> jvmClasspathRoots, List<? extends VirtualFile> jvmModulePathRoots) {
        boolean bl;
        List modules2;
        List result2;
        block17: {
            result2 = new ArrayList();
            modules2 = new ArrayList();
            boolean hasOutputDirectoryInClasspath = CollectionsKt.contains((Iterable)jvmClasspathRoots, this.outputDirectory) || CollectionsKt.contains((Iterable)jvmModulePathRoots, this.outputDirectory);
            for (RootWithPrefix object : javaSourceRoots) {
                FqName fqName;
                VirtualFile virtualFile = object.component1();
                String packagePrefix = object.component2();
                JavaModule.Explicit modularRoot = this.modularSourceRoot(virtualFile, hasOutputDirectoryInClasspath);
                if (modularRoot != null) {
                    ((Collection)modules2).add(modularRoot);
                    continue;
                }
                Collection collection = result2;
                VirtualFile virtualFile2 = virtualFile;
                JavaRoot.RootType rootType = JavaRoot.RootType.SOURCE;
                if (packagePrefix != null) {
                    Object object2;
                    void prefix;
                    JavaRoot.RootType rootType2 = rootType;
                    VirtualFile virtualFile3 = virtualFile2;
                    boolean bl2 = false;
                    if (FqNamesUtilKt.isValidJavaFqName((String)prefix)) {
                        object2 = new FqName((String)prefix);
                    } else {
                        Iterator iterator2;
                        Iterator it = iterator2 = null;
                        boolean bl3 = false;
                        ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.STRONG_WARNING, "Invalid package prefix name is ignored: " + (String)prefix, null, 4, null);
                        object2 = iterator2;
                    }
                    FqName fqName2 = object2;
                    virtualFile2 = virtualFile3;
                    rootType = rootType2;
                    fqName = fqName2;
                } else {
                    fqName = null;
                }
                FqName fqName3 = fqName;
                JavaRoot.RootType rootType3 = rootType;
                VirtualFile virtualFile4 = virtualFile2;
                collection.add(new JavaRoot(virtualFile4, rootType3, fqName3));
            }
            for (VirtualFile virtualFile : jvmClasspathRoots) {
                ((Collection)result2).add(new JavaRoot(virtualFile, JavaRoot.RootType.BINARY, null, 4, null));
            }
            Iterable iterable = modules2;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : iterable) {
                    boolean bl3;
                    block16: {
                        JavaModule module2 = (JavaModule)element$iv;
                        boolean bl5 = false;
                        Iterable $this$any$iv2 = module2.getModuleRoots();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                JavaModule.Root it = (JavaModule.Root)element$iv2;
                                boolean bl6 = false;
                                if (!Intrinsics.areEqual(it.getFile(), this.outputDirectory)) continue;
                                bl3 = true;
                                break block16;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        boolean outputDirectoryAddedAsPartOfModule = bl;
        for (VirtualFile virtualFile : jvmModulePathRoots) {
            JavaModule module3;
            if (outputDirectoryAddedAsPartOfModule && Intrinsics.areEqual(virtualFile, this.outputDirectory) || (module3 = this.modularBinaryRoot(virtualFile)) == null) continue;
            ((Collection)modules2).add(module3);
        }
        if (this.jdkRelease == null || this.jdkRelease >= 9) {
            this.addModularRoots(modules2, result2);
        } else {
            ((Collection)result2).add(new JavaRoot(this.javaModuleFinder.getNonModuleRoot().getFile(), JavaRoot.RootType.BINARY_SIG, null, 4, null));
        }
        return new RootsAndModules(result2, modules2);
    }

    private final Pair<VirtualFile, PsiJavaModule> findSourceModuleInfo(VirtualFile root) {
        Object object;
        VirtualFile moduleInfoFile;
        block5: {
            VirtualFile virtualFile = root.isDirectory() ? root.findChild("module-info.java") : (Intrinsics.areEqual(root.getName(), "module-info.java") ? root : null);
            if (virtualFile == null) {
                return null;
            }
            moduleInfoFile = virtualFile;
            PsiFile psiFile = this.psiManager.findFile(moduleInfoFile);
            if (psiFile == null) {
                return null;
            }
            PsiFile psiFile2 = psiFile;
            PsiElement[] psiElementArray = psiFile2.getChildren();
            Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
            Object[] $this$singleOrNull$iv = psiElementArray;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof PsiJavaModule)) continue;
                if (found$iv) {
                    object = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : single$iv;
        }
        Object object2 = object;
        PsiJavaModule psiJavaModule = object2 instanceof PsiJavaModule ? (PsiJavaModule)object2 : null;
        if (psiJavaModule == null) {
            return null;
        }
        PsiJavaModule psiJavaModule2 = psiJavaModule;
        return TuplesKt.to(moduleInfoFile, psiJavaModule2);
    }

    private final JavaModule.Explicit modularSourceRoot(VirtualFile root, boolean hasOutputDirectoryInClasspath) {
        List<JavaModule.Root> list;
        Pair<VirtualFile, PsiJavaModule> pair = this.findSourceModuleInfo(root);
        if (pair == null) {
            return null;
        }
        Pair<VirtualFile, PsiJavaModule> pair2 = pair;
        VirtualFile moduleInfoFile = pair2.component1();
        PsiJavaModule psiJavaModule = pair2.component2();
        JavaModule.Root sourceRoot = new JavaModule.Root(root, false, false, 4, null);
        if (hasOutputDirectoryInClasspath) {
            JavaModule.Root[] rootArray = new JavaModule.Root[2];
            rootArray[0] = sourceRoot;
            VirtualFile virtualFile = this.outputDirectory;
            Intrinsics.checkNotNull(virtualFile);
            rootArray[1] = new JavaModule.Root(virtualFile, true, false, 4, null);
            list = CollectionsKt.listOf(rootArray);
        } else {
            list = CollectionsKt.listOf(sourceRoot);
        }
        List<JavaModule.Root> roots = list;
        return new JavaModule.Explicit(JavaModuleInfo.Companion.create(psiJavaModule), roots, moduleInfoFile, false, 8, null);
    }

    private final JavaModule modularBinaryRoot(VirtualFile root) {
        VirtualFile moduleInfoFile;
        boolean isJar = Intrinsics.areEqual(root.getFileSystem().getProtocol(), "jar");
        Lazy<Attributes> manifest = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> ClasspathRootsResolver.modularBinaryRoot$lambda$5(this, root));
        VirtualFile virtualFile = root.findChild("module-info.class");
        if (virtualFile == null) {
            virtualFile = isJar ? this.tryLoadVersionSpecificModuleInfo(root, manifest) : null;
        }
        if ((moduleInfoFile = virtualFile) != null) {
            JavaModuleInfo javaModuleInfo = JavaModuleInfo.Companion.read(moduleInfoFile, this.javaFileManager, this.searchScope);
            if (javaModuleInfo == null) {
                return null;
            }
            JavaModuleInfo moduleInfo = javaModuleInfo;
            return new JavaModule.Explicit(moduleInfo, CollectionsKt.listOf(new JavaModule.Root(root, true, false, 4, null)), moduleInfoFile, false, 8, null);
        }
        if (isJar) {
            String automaticModuleName;
            List<JavaModule.Root> moduleRoot = CollectionsKt.listOf(new JavaModule.Root(root, true, false, 4, null));
            Attributes attributes = manifest.getValue();
            String string = automaticModuleName = attributes != null ? attributes.getValue(AUTOMATIC_MODULE_NAME) : null;
            if (automaticModuleName != null) {
                return new JavaModule.Automatic(automaticModuleName, moduleRoot);
            }
            File file = VfsUtilCore.virtualToIoFile(root);
            Intrinsics.checkNotNullExpressionValue(file, "virtualToIoFile(...)");
            File originalFile = file;
            String string2 = LightJavaModule.moduleName(FilesKt.getNameWithoutExtension(originalFile));
            Intrinsics.checkNotNullExpressionValue(string2, "moduleName(...)");
            String moduleName2 = string2;
            if (((CharSequence)moduleName2).length() == 0) {
                VirtualFile virtualFile2 = VfsUtilCore.getVirtualFileForJar(root);
                if (virtualFile2 == null) {
                    virtualFile2 = root;
                }
                this.report(CompilerMessageSeverity.ERROR, "Cannot infer automatic module name for the file", virtualFile2);
                return null;
            }
            return new JavaModule.Automatic(moduleName2, moduleRoot);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile tryLoadVersionSpecificModuleInfo(VirtualFile root, Lazy<? extends Attributes> manifest) {
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Boolean isMultiReleaseJar;
        VirtualFile virtualFile = root.findChild("META-INF");
        if (virtualFile == null || (virtualFile = virtualFile.findChild("versions")) == null) {
            return null;
        }
        VirtualFile versionsDir = virtualFile;
        Object object = manifest.getValue();
        Boolean bl = object != null && (object = ((Attributes)object).getValue(IS_MULTI_RELEASE)) != null ? Boolean.valueOf(StringsKt.equals((String)object, "true", true)) : (isMultiReleaseJar = null);
        if (!Intrinsics.areEqual(isMultiReleaseJar, true)) {
            return null;
        }
        VirtualFile[] virtualFileArray = versionsDir.getChildren();
        Intrinsics.checkNotNullExpressionValue(virtualFileArray, "getChildren(...)");
        Object $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            Integer version2 = StringsKt.toIntOrNull(string);
            if (!(version2 != null && version2 >= 9)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List<VirtualFile> versions2 = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a2, T b2) {
                VirtualFile it = (VirtualFile)a2;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                it = (VirtualFile)b2;
                Comparable comparable = Integer.valueOf(Integer.parseInt(string));
                bl = false;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                return ComparisonsKt.compareValues(comparable, Integer.parseInt(string2));
            }
        });
        for (VirtualFile version3 : versions2) {
            VirtualFile file;
            VirtualFile virtualFile2 = file = version3.findChild("module-info.class");
            if (virtualFile2 == null) continue;
            return virtualFile2;
        }
        return null;
    }

    private final Attributes readManifestAttributes(VirtualFile jarRoot) {
        Attributes attributes;
        VirtualFile virtualFile = jarRoot.findChild("META-INF");
        VirtualFile manifestFile = virtualFile != null ? virtualFile.findChild("MANIFEST.MF") : null;
        try {
            Attributes attributes2;
            Object object = manifestFile;
            if (object != null && (object = ((VirtualFile)object).getInputStream()) != null) {
                Object p0 = object;
                boolean bl = false;
                attributes2 = new Manifest((InputStream)p0).getMainAttributes();
            } else {
                attributes2 = null;
            }
            attributes = attributes2;
        }
        catch (IOException e2) {
            attributes = null;
        }
        return attributes;
    }

    /*
     * WARNING - void declaration
     */
    private final void addModularRoots(List<? extends JavaModule> modules2, List<JavaRoot> result2) {
        boolean bl;
        LinkedHashSet<String> allDependencies;
        JavaModule.Explicit sourceModule;
        block21: {
            List list;
            void $this$filterTo$iv$iv;
            Iterator<Object> $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = modules2;
            boolean bl2 = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof JavaModule.Explicit)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean bl3 = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                JavaModule p0 = (JavaModule)element$iv$iv;
                boolean bl22 = false;
                if (!p0.isSourceModule()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List sourceModules = (List)destination$iv$iv;
            if (sourceModules.size() > 1) {
                for (JavaModule.Explicit explicit : sourceModules) {
                    this.report(CompilerMessageSeverity.ERROR, "Too many source module declarations found", explicit.getModuleInfoFile());
                }
                return;
            }
            for (JavaModule javaModule : modules2) {
                JavaModule existing = this.javaModuleFinder.findModule(javaModule.getName());
                if (existing == null) {
                    this.javaModuleFinder.addUserModule(javaModule);
                    continue;
                }
                if (Intrinsics.areEqual(javaModule.getModuleRoots(), existing.getModuleRoots())) continue;
                VirtualFile thisFile = ClasspathRootsResolver.addModularRoots$getRootFile(javaModule);
                VirtualFile existingFile = ClasspathRootsResolver.addModularRoots$getRootFile(existing);
                String string = existingFile == null ? "" : " at: " + existingFile.getPath();
                this.report(CompilerMessageSeverity.STRONG_WARNING, "The root is ignored because a module with the same name '" + javaModule.getName() + "' has been found earlier on the module path" + string, thisFile);
            }
            if (SequencesKt.none(this.javaModuleFinder.getAllObservableModules())) {
                return;
            }
            sourceModule = (JavaModule.Explicit)CollectionsKt.singleOrNull(sourceModules);
            boolean bl4 = this.additionalModules.contains("ALL-MODULE-PATH");
            if (bl4 && sourceModule != null) {
                ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.ERROR, "-Xadd-modules=ALL-MODULE-PATH can only be used when compiling the unnamed module", null, 4, null);
                return;
            }
            JavaModule.Explicit explicit = sourceModule;
            if (explicit != null) {
                list = CollectionsKt.plus((Collection)CollectionsKt.listOf(explicit.getName()), (Iterable)this.additionalModules);
            } else if (bl4) {
                Iterable $this$map$iv = modules2;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : iterable2) {
                    void p0;
                    JavaModule javaModule = (JavaModule)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl32 = false;
                    collection.add(p0.getName());
                }
                list = (List)destination$iv$iv2;
            } else {
                list = CollectionsKt.plus((Collection)CliJavaModuleUtilsKt.computeDefaultRootModules(this.javaModuleFinder), (Iterable)this.additionalModules);
            }
            List rootModules = list;
            allDependencies = this.javaModuleGraph.getAllDependencies(rootModules);
            Iterable $this$any$iv = allDependencies;
            boolean bl5 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String moduleName2 = (String)element$iv;
                    boolean bl42 = false;
                    if (!(this.javaModuleFinder.findModule(moduleName2) instanceof JavaModule.Automatic)) continue;
                    bl = true;
                    break block21;
                }
                bl = false;
            }
        }
        if (bl) {
            for (JavaModule javaModule : modules2) {
                if (!(javaModule instanceof JavaModule.Automatic)) continue;
                ((Collection)allDependencies).add(((JavaModule.Automatic)javaModule).getName());
            }
        }
        ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.LOGGING, "Loading modules: " + allDependencies, null, 4, null);
        Iterator iterator2 = allDependencies.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<JavaModule> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            JavaModule javaModule = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(javaModule, "next(...)");
            String string = (String)((Object)javaModule);
            JavaModule module5 = this.javaModuleFinder.findModule(string);
            if (module5 == null) {
                ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.ERROR, "Module " + string + " cannot be found in the module graph", null, 4, null);
                continue;
            }
            result2.addAll((Collection<JavaRoot>)CliJavaModuleUtilsKt.getJavaModuleRoots(module5));
        }
        if (this.requireStdlibModule && sourceModule != null && !this.javaModuleGraph.reads(sourceModule.getName(), "kotlin.stdlib")) {
            this.report(CompilerMessageSeverity.ERROR, "The Kotlin standard library is not found in the module graph. Please ensure you have the 'requires kotlin.stdlib' clause in your module definition", sourceModule.getModuleInfoFile());
        }
    }

    private final void report(CompilerMessageSeverity severity, String message2, VirtualFile file) {
        if (this.messageCollector == null) {
            throw new IllegalStateException((file != null ? file.getPath() + ':' : "") + (Object)((Object)severity) + ": " + message2 + " (no MessageCollector configured)");
        }
        if (severity == CompilerMessageSeverity.ERROR && !this.reportErrors) {
            return;
        }
        VirtualFile virtualFile = file;
        this.messageCollector.report(severity, message2, virtualFile == null ? null : CompilerMessageLocation.Companion.create(MessageUtil.virtualFileToPath(virtualFile)));
    }

    static /* synthetic */ void report$default(ClasspathRootsResolver classpathRootsResolver, CompilerMessageSeverity compilerMessageSeverity, String string, VirtualFile virtualFile, int n2, Object object) {
        if ((n2 & 4) != 0) {
            virtualFile = null;
        }
        classpathRootsResolver.report(compilerMessageSeverity, string, virtualFile);
    }

    private static final Attributes modularBinaryRoot$lambda$5(ClasspathRootsResolver this$0, VirtualFile $root) {
        return this$0.readManifestAttributes($root);
    }

    /*
     * WARNING - void declaration
     */
    private static final VirtualFile addModularRoots$getRootFile(JavaModule $this$addModularRoots_u24getRootFile) {
        VirtualFile virtualFile;
        Object object = CollectionsKt.firstOrNull($this$addModularRoots_u24getRootFile.getModuleRoots());
        if (object != null && (object = ((JavaModule.Root)object).getFile()) != null) {
            Object it = object;
            boolean bl = false;
            virtualFile = VfsUtilCore.getVirtualFileForJar((VirtualFile)it);
            if (virtualFile == null) {
                void var1_1;
                virtualFile = var1_1;
            }
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$Companion;", "", "<init>", "()V", "AUTOMATIC_MODULE_NAME", "", "IS_MULTI_RELEASE", "cli-base"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$RootWithPrefix;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "packagePrefix", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getPackagePrefix", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "cli-base"})
    private static final class RootWithPrefix {
        @NotNull
        private final VirtualFile root;
        @Nullable
        private final String packagePrefix;

        public RootWithPrefix(@NotNull VirtualFile root, @Nullable String packagePrefix) {
            Intrinsics.checkNotNullParameter(root, "root");
            this.root = root;
            this.packagePrefix = packagePrefix;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @Nullable
        public final String getPackagePrefix() {
            return this.packagePrefix;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.root;
        }

        @Nullable
        public final String component2() {
            return this.packagePrefix;
        }

        @NotNull
        public final RootWithPrefix copy(@NotNull VirtualFile root, @Nullable String packagePrefix) {
            Intrinsics.checkNotNullParameter(root, "root");
            return new RootWithPrefix(root, packagePrefix);
        }

        public static /* synthetic */ RootWithPrefix copy$default(RootWithPrefix rootWithPrefix, VirtualFile virtualFile, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                virtualFile = rootWithPrefix.root;
            }
            if ((n2 & 2) != 0) {
                string = rootWithPrefix.packagePrefix;
            }
            return rootWithPrefix.copy(virtualFile, string);
        }

        @NotNull
        public String toString() {
            return "RootWithPrefix(root=" + this.root + ", packagePrefix=" + this.packagePrefix + ')';
        }

        public int hashCode() {
            int result2 = this.root.hashCode();
            result2 = result2 * 31 + (this.packagePrefix == null ? 0 : this.packagePrefix.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RootWithPrefix)) {
                return false;
            }
            RootWithPrefix rootWithPrefix = (RootWithPrefix)other;
            if (!Intrinsics.areEqual(this.root, rootWithPrefix.root)) {
                return false;
            }
            return Intrinsics.areEqual(this.packagePrefix, rootWithPrefix.packagePrefix);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$RootsAndModules;", "", "roots", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "modules", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getRoots", "()Ljava/util/List;", "getModules", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "cli-base"})
    public static final class RootsAndModules {
        @NotNull
        private final List<JavaRoot> roots;
        @NotNull
        private final List<JavaModule> modules;

        public RootsAndModules(@NotNull List<JavaRoot> roots, @NotNull List<? extends JavaModule> modules2) {
            Intrinsics.checkNotNullParameter(roots, "roots");
            Intrinsics.checkNotNullParameter(modules2, "modules");
            this.roots = roots;
            this.modules = modules2;
        }

        @NotNull
        public final List<JavaRoot> getRoots() {
            return this.roots;
        }

        @NotNull
        public final List<JavaModule> getModules() {
            return this.modules;
        }

        @NotNull
        public final List<JavaRoot> component1() {
            return this.roots;
        }

        @NotNull
        public final List<JavaModule> component2() {
            return this.modules;
        }

        @NotNull
        public final RootsAndModules copy(@NotNull List<JavaRoot> roots, @NotNull List<? extends JavaModule> modules2) {
            Intrinsics.checkNotNullParameter(roots, "roots");
            Intrinsics.checkNotNullParameter(modules2, "modules");
            return new RootsAndModules(roots, modules2);
        }

        public static /* synthetic */ RootsAndModules copy$default(RootsAndModules rootsAndModules, List list, List list2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = rootsAndModules.roots;
            }
            if ((n2 & 2) != 0) {
                list2 = rootsAndModules.modules;
            }
            return rootsAndModules.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "RootsAndModules(roots=" + this.roots + ", modules=" + this.modules + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.roots).hashCode();
            result2 = result2 * 31 + ((Object)this.modules).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RootsAndModules)) {
                return false;
            }
            RootsAndModules rootsAndModules = (RootsAndModules)other;
            if (!Intrinsics.areEqual(this.roots, rootsAndModules.roots)) {
                return false;
            }
            return Intrinsics.areEqual(this.modules, rootsAndModules.modules);
        }
    }
}

