/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.utils;

import java.util.Locale;
import java.util.stream.Stream;

public class Os {
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    public static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
    public static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.ENGLISH);
    public static final String OS_FAMILY;
    public static final boolean IS_WINDOWS;
    private static final String PATH_SEP;

    public static boolean isFamily(String family) {
        return Os.isFamily(family, OS_NAME);
    }

    public static boolean isFamily(String family, String actualOsName) {
        boolean isWindows = actualOsName.contains("windows");
        boolean is9x = false;
        boolean isNT = false;
        if (isWindows) {
            is9x = actualOsName.contains("95") || actualOsName.contains("98") || actualOsName.contains("me") || actualOsName.contains("ce");
            isNT = !is9x;
        }
        switch (family) {
            case "windows": {
                return isWindows;
            }
            case "win9x": {
                return isWindows && is9x;
            }
            case "winnt": {
                return isWindows && isNT;
            }
            case "os/2": {
                return actualOsName.contains("os/2");
            }
            case "netware": {
                return actualOsName.contains("netware");
            }
            case "dos": {
                return PATH_SEP.equals(";") && !Os.isFamily("netware", actualOsName) && !isWindows;
            }
            case "mac": {
                return actualOsName.contains("mac") || actualOsName.contains("darwin");
            }
            case "tandem": {
                return actualOsName.contains("nonstop_kernel");
            }
            case "unix": {
                return PATH_SEP.equals(":") && !Os.isFamily("openvms", actualOsName) && (!Os.isFamily("mac", actualOsName) || actualOsName.endsWith("x"));
            }
            case "z/os": {
                return actualOsName.contains("z/os") || actualOsName.contains("os/390");
            }
            case "os/400": {
                return actualOsName.contains("os/400");
            }
            case "openvms": {
                return actualOsName.contains("openvms");
            }
        }
        return actualOsName.contains(family.toLowerCase(Locale.US));
    }

    private static String getOsFamily() {
        return Stream.of("dos", "mac", "netware", "winnt", "openvms", "os/2", "os/400", "tandem", "unix", "win9x", "windows", "z/os").filter(Os::isFamily).findFirst().orElse(null);
    }

    static {
        PATH_SEP = System.getProperty("path.separator");
        OS_FAMILY = Os.getOsFamily();
        IS_WINDOWS = Os.isFamily("windows");
    }
}

