/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.classpathDiff.DirectoryOrJarReader;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JF\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t26\u0010\u000b\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00100\fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/JarReader;", "Lorg/jetbrains/kotlin/incremental/classpathDiff/DirectoryOrJarReader;", "jar", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "zipFile", "Ljava/util/zip/ZipFile;", "getUnixStyleRelativePaths", "", "", "filter", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "unixStyleRelativePath", "", "isDirectory", "readBytes", "", "close", "", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nClasspathSnapshotter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClasspathSnapshotter.kt\norg/jetbrains/kotlin/incremental/classpathDiff/JarReader\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 File.kt\norg/jetbrains/kotlin/konan/file/FileKt\n*L\n1#1,287:1\n1163#2,3:288\n212#3,13:291\n*S KotlinDebug\n*F\n+ 1 ClasspathSnapshotter.kt\norg/jetbrains/kotlin/incremental/classpathDiff/JarReader\n*L\n273#1:288,3\n278#1:291,13\n*E\n"})
final class JarReader
implements DirectoryOrJarReader {
    @NotNull
    private final ZipFile zipFile;

    public JarReader(@NotNull File jar) {
        Intrinsics.checkNotNullParameter(jar, "jar");
        this.zipFile = new ZipFile(jar);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getUnixStyleRelativePaths(@NotNull Function2<? super String, ? super Boolean, Boolean> filter) {
        void var3_3;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(filter, "filter");
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, "entries(...)");
        Sequence<ZipEntry> sequence2 = SequencesKt.filter(SequencesKt.asSequence(CollectionsKt.iterator(enumeration)), arg_0 -> JarReader.getUnixStyleRelativePaths$lambda$0(filter, arg_0));
        Collection destination$iv = SetsKt.sortedSetOf(new String[0]);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            ZipEntry zipEntry = (ZipEntry)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return CollectionsKt.toList((Iterable)var3_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] readBytes(@NotNull String unixStyleRelativePath) {
        Object it;
        Intrinsics.checkNotNullParameter(unixStyleRelativePath, "unixStyleRelativePath");
        AutoCloseable $this$use$iv = this.zipFile.getInputStream(this.zipFile.getEntry(unixStyleRelativePath));
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            it = (InputStream)$this$use$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            it = ByteStreamsKt.readBytes((InputStream)it);
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        return it;
    }

    @Override
    public void close() {
        this.zipFile.close();
    }

    private static final boolean getUnixStyleRelativePaths$lambda$0(Function2 $filter, ZipEntry it) {
        String string2 = it.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        return (Boolean)$filter.invoke(string2, it.isDirectory());
    }
}

