/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.pagecache.impl;

import com.intellij.openapi.util.IntRef;
import com.intellij.util.io.pagecache.impl.PageImpl;
import it.unimi.dsi.fastutil.HashCommon;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PagesTable {
    private final float loadFactor;
    private int pagesCount;
    @NotNull
    private volatile AtomicReferenceArray<PageImpl> pages;
    private final transient ReentrantLock pagesLock;

    public void flushAll() throws IOException {
        AtomicReferenceArray<PageImpl> pagesLocal = this.pages;
        for (int i = 0; i < pagesLocal.length(); ++i) {
            PageImpl page = pagesLocal.get(i);
            if (page == null || !page.isDirty()) continue;
            page.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shrinkIfNeeded(int alivePagesCount) {
        int expectedTableSize = (int)Math.ceil((float)alivePagesCount / this.loadFactor);
        if (expectedTableSize >= 16 && (double)expectedTableSize * 2.0 < (double)this.pages.length()) {
            this.pagesLock.lock();
            try {
                try {
                    this.rehashToSize(expectedTableSize);
                }
                catch (NoFreeSpaceException e) {
                    boolean bl = false;
                    this.pagesLock.unlock();
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.pagesLock.unlock();
            }
        }
        return false;
    }

    public AtomicReferenceArray<PageImpl> pages() {
        return this.pages;
    }

    public ReentrantLock pagesLock() {
        return this.pagesLock;
    }

    private void rehashToSize(int newPagesSize) throws NoFreeSpaceException {
        int pagesCopied;
        assert (this.pagesLock.isHeldByCurrentThread()) : "Must hold pagesLock while rehashing";
        AtomicReferenceArray<PageImpl> newPages = new AtomicReferenceArray<PageImpl>(newPagesSize);
        this.pagesCount = pagesCopied = PagesTable.rehashWithoutTombstones(this.pages, newPages);
        this.pages = newPages;
    }

    private static int rehashWithoutTombstones(@NotNull AtomicReferenceArray<PageImpl> sourcePages, @NotNull AtomicReferenceArray<PageImpl> targetPages) throws NoFreeSpaceException {
        if (sourcePages == null) {
            PagesTable.$$$reportNull$$$0(4);
        }
        if (targetPages == null) {
            PagesTable.$$$reportNull$$$0(5);
        }
        IntRef insertionIndexRef = new IntRef();
        int pagesCopied = 0;
        for (int i = 0; i < sourcePages.length(); ++i) {
            PageImpl page = sourcePages.get(i);
            if (page == null || page.isTombstone()) continue;
            int pageIndex = page.pageIndex();
            PageImpl pageMustNotBeFound = PagesTable.findPageOrInsertionIndex(targetPages, pageIndex, insertionIndexRef);
            int insertionIndex = insertionIndexRef.get();
            if (pageMustNotBeFound != null) {
                throw new AssertionError((Object)("Page[#" + pageIndex + "] is copying now -- can't be already in .newPages! \nsource: " + sourcePages + "\ntarget: " + targetPages));
            }
            if (insertionIndex < 0) {
                if (pagesCopied == targetPages.length()) {
                    throw new NoFreeSpaceException("Not enough space in targetPages(length: " + targetPages.length() + "): sourcePages(length: " + sourcePages.length() + ") contains > " + pagesCopied + " !tombstone pages. \nsource: " + sourcePages + "\ntarget: " + targetPages);
                }
                throw new AssertionError((Object)("Bug: insertion index must be found for Page[#" + pageIndex + "] during rehash.  source.length: " + sourcePages.length() + " target.length: " + targetPages.length() + "\nsource: " + sourcePages + "\ntarget: " + targetPages));
            }
            targetPages.set(insertionIndex, page);
            ++pagesCopied;
        }
        return pagesCopied;
    }

    @Nullable
    private static PageImpl findPageOrInsertionIndex(@NotNull AtomicReferenceArray<PageImpl> pages, int pageIndex, @Nullable IntRef insertionIndexRef) {
        if (pages == null) {
            PagesTable.$$$reportNull$$$0(6);
        }
        int length = pages.length();
        int initialSlotIndex = PagesTable.hash(pageIndex) % length;
        boolean probeStep = true;
        int firstTombstoneIndex = -1;
        int slotIndex = initialSlotIndex;
        for (int probeNo = 0; probeNo < length; ++probeNo) {
            PageImpl page = pages.get(slotIndex);
            if (page == null) {
                if (insertionIndexRef != null) {
                    int insertionIndex = firstTombstoneIndex >= 0 ? firstTombstoneIndex : slotIndex;
                    insertionIndexRef.set(insertionIndex);
                }
                return null;
            }
            if (page.isTombstone()) {
                if (firstTombstoneIndex < 0) {
                    firstTombstoneIndex = slotIndex;
                }
            } else if (page.pageIndex() == pageIndex) {
                if (insertionIndexRef != null) {
                    insertionIndexRef.set(slotIndex);
                }
                return page;
            }
            slotIndex = (slotIndex + 1) % length;
        }
        if (insertionIndexRef != null) {
            insertionIndexRef.set(-1);
        }
        return null;
    }

    private static int hash(int pageIndex) {
        return Math.abs(HashCommon.mix(pageIndex));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uninitializedPageFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/pagecache/impl/PagesTable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPages";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/pagecache/impl/PagesTable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupOrCreate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "insertNewPage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "lookupOrCreate";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rehashWithoutTombstones";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPageOrInsertionIndex";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "probingSequenceLengthFor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class NoFreeSpaceException
    extends IllegalStateException {
        private NoFreeSpaceException(String message) {
            super(message);
        }
    }
}

