/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.infinispan.LazyModel;
import org.keycloak.models.cache.infinispan.RealmCacheSession;
import org.keycloak.models.cache.infinispan.entities.CachedClientRole;
import org.keycloak.models.cache.infinispan.entities.CachedRealmRole;
import org.keycloak.models.cache.infinispan.entities.CachedRole;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RoleAdapter
implements RoleModel {
    protected RoleModel updated;
    private final KeycloakSession session;
    protected CachedRole cached;
    protected RealmCacheSession cacheSession;
    protected RealmModel realm;
    protected Set<RoleModel> composites;
    private final Supplier<RoleModel> modelSupplier;
    protected boolean invalidated;

    public RoleAdapter(CachedRole cached, RealmCacheSession cacheSession, RealmModel realm) {
        this.cached = cached;
        this.cacheSession = cacheSession;
        this.session = cacheSession.session;
        this.realm = realm;
        this.modelSupplier = new LazyModel<RoleModel>(this::getRoleModel);
    }

    protected void getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerRoleInvalidation(this.cached.getId(), this.cached.getName(), this.getContainerId());
            this.updated = this.modelSupplier.get();
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
    }

    protected void getDelegateForRename(String newName) {
        if (!Objects.equals(newName, this.cached.getName())) {
            String containerId = this.getContainerId();
            this.cacheSession.registerRoleInvalidation(this.cached.getId(), newName, containerId);
        }
        this.getDelegateForUpdate();
    }

    public void invalidate() {
        this.invalidated = true;
    }

    protected boolean isUpdated() {
        if (this.updated != null) {
            return true;
        }
        if (!this.invalidated) {
            return false;
        }
        this.updated = this.cacheSession.getRoleDelegate().getRoleById(this.realm, this.cached.getId());
        if (this.updated == null) {
            throw new IllegalStateException("Not found in database");
        }
        return true;
    }

    public String getName() {
        if (this.isUpdated()) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    public String getDescription() {
        if (this.isUpdated()) {
            return this.updated.getDescription();
        }
        return this.cached.getDescription();
    }

    public void setDescription(String description) {
        this.getDelegateForUpdate();
        this.updated.setDescription(description);
    }

    public String getId() {
        if (this.isUpdated()) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public void setName(String name) {
        this.getDelegateForRename(name);
        this.updated.setName(name);
    }

    public boolean isComposite() {
        if (this.isUpdated()) {
            return this.updated.isComposite();
        }
        return this.cached.isComposite();
    }

    public void addCompositeRole(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.addCompositeRole(role);
    }

    public void removeCompositeRole(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.removeCompositeRole(role);
    }

    public Stream<RoleModel> getCompositesStream() {
        if (this.isUpdated()) {
            return this.updated.getCompositesStream();
        }
        if (this.composites == null) {
            this.composites = new HashSet<RoleModel>();
            for (String id : this.cached.getComposites()) {
                RoleModel role = this.realm.getRoleById(id);
                if (role == null) {
                    this.getDelegateForUpdate();
                    return this.updated.getCompositesStream();
                }
                this.composites.add(role);
            }
        }
        return this.composites.stream();
    }

    public Stream<RoleModel> getCompositesStream(String search, Integer first, Integer max) {
        if (this.isUpdated()) {
            return this.updated.getCompositesStream(search, first, max);
        }
        return this.cacheSession.getRoleDelegate().getRolesStream(this.realm, this.cached.getComposites().stream(), search, first, max);
    }

    public boolean isClientRole() {
        return this.cached instanceof CachedClientRole;
    }

    public String getContainerId() {
        if (this.isClientRole()) {
            CachedClientRole appRole = (CachedClientRole)this.cached;
            return appRole.getClientId();
        }
        return this.realm.getId();
    }

    public RoleContainerModel getContainer() {
        if (this.cached instanceof CachedRealmRole) {
            return this.realm;
        }
        CachedClientRole appRole = (CachedClientRole)this.cached;
        return this.realm.getClientById(appRole.getClientId());
    }

    public boolean hasRole(RoleModel role) {
        return this.equals(role) || KeycloakModelUtils.searchFor((RoleModel)role, (RoleModel)this, new HashSet());
    }

    public void setSingleAttribute(String name, String value) {
        this.getDelegateForUpdate();
        this.updated.setSingleAttribute(name, value);
    }

    public void setAttribute(String name, List<String> values) {
        this.getDelegateForUpdate();
        this.updated.setAttribute(name, values);
    }

    public void removeAttribute(String name) {
        this.getDelegateForUpdate();
        this.updated.removeAttribute(name);
    }

    public String getFirstAttribute(String name) {
        if (this.updated != null) {
            return this.updated.getFirstAttribute(name);
        }
        return (String)this.cached.getAttributes(this.session, this.modelSupplier).getFirst((Object)name);
    }

    public Stream<String> getAttributeStream(String name) {
        if (this.updated != null) {
            return this.updated.getAttributeStream(name);
        }
        List result = (List)this.cached.getAttributes(this.session, this.modelSupplier).get((Object)name);
        if (result == null) {
            return Stream.empty();
        }
        return result.stream();
    }

    public Map<String, List<String>> getAttributes() {
        if (this.updated != null) {
            return this.updated.getAttributes();
        }
        return this.cached.getAttributes(this.session, this.modelSupplier);
    }

    private RoleModel getRoleModel() {
        return this.cacheSession.getRoleDelegate().getRoleById(this.realm, this.cached.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleModel)) {
            return false;
        }
        RoleModel that = (RoleModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

