/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.spi;

import java.util.List;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;

public interface JdbcParametersList {
    public static final JdbcParametersList EMPTY = new JdbcParametersListMulti(new JdbcParameter[0]);

    public JdbcParameter get(int var1);

    public int size();

    public static Builder newBuilder() {
        return JdbcParametersList.newBuilder(2);
    }

    public static JdbcParametersList fromList(List<JdbcParameter> originalList) {
        Builder builder = JdbcParametersList.newBuilder(originalList.size());
        for (JdbcParameter element : originalList) {
            builder.add(element);
        }
        return builder.build();
    }

    public static JdbcParametersList empty() {
        return EMPTY;
    }

    public static JdbcParametersList singleton(JdbcParameter p) {
        return new JdbcParametersListSingleton(p);
    }

    public static Builder newBuilder(int i) {
        return new Builder(i);
    }

    public static class Builder {
        private JdbcParameter[] array;
        private int index = 0;

        private Builder(int sizeEstimate) {
            this.array = new JdbcParameter[sizeEstimate];
        }

        public void add(JdbcParameter jdbcParameter) {
            if (this.index >= this.array.length) {
                int newSize = Math.max(this.index + 2, this.array.length >> 1);
                JdbcParameter[] newArray = new JdbcParameter[newSize];
                System.arraycopy(this.array, 0, newArray, 0, this.array.length);
                this.array = newArray;
            }
            this.array[this.index++] = jdbcParameter;
        }

        public JdbcParametersList build() {
            if (this.index == 0) {
                return EMPTY;
            }
            if (this.index == 1) {
                return JdbcParametersList.singleton(this.array[0]);
            }
            if (this.index == this.array.length) {
                return new JdbcParametersListMulti(this.array);
            }
            JdbcParameter[] newArray = new JdbcParameter[this.index];
            System.arraycopy(this.array, 0, newArray, 0, this.index);
            return new JdbcParametersListMulti(newArray);
        }
    }

    public static final class JdbcParametersListSingleton
    implements JdbcParametersList {
        private final JdbcParameter singleElement;

        private JdbcParametersListSingleton(JdbcParameter singleElement) {
            this.singleElement = singleElement;
        }

        @Override
        public JdbcParameter get(int selectionIndex) {
            if (selectionIndex != 0) {
                throw new ArrayIndexOutOfBoundsException(selectionIndex);
            }
            return this.singleElement;
        }

        @Override
        public int size() {
            return 1;
        }
    }

    public static final class JdbcParametersListMulti
    implements JdbcParametersList {
        private final JdbcParameter[] array;

        private JdbcParametersListMulti(JdbcParameter[] inputArray) {
            this.array = inputArray;
        }

        @Override
        public JdbcParameter get(int selectionIndex) {
            return this.array[selectionIndex];
        }

        @Override
        public int size() {
            return this.array.length;
        }
    }
}

