/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.type;

import org.hibernate.dialect.Dialect;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JsonArrayJdbcType;

public class PostgreSQLCastingJsonArrayJdbcType
extends JsonArrayJdbcType {
    private final boolean jsonb;

    public PostgreSQLCastingJsonArrayJdbcType(JdbcType elementJdbcType, boolean jsonb) {
        super(elementJdbcType);
        this.jsonb = jsonb;
    }

    @Override
    public void appendWriteExpression(String writeExpression, SqlAppender appender, Dialect dialect) {
        appender.append("cast(");
        appender.append(writeExpression);
        appender.append(" as ");
        if (this.jsonb) {
            appender.append("jsonb)");
        } else {
            appender.append("json)");
        }
    }
}

