/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import javax.security.sasl.SaslClient;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelInboundHandlerDefaults;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOutboundHandlerDefaults;

public class SaslDecoderEncoder
implements ChannelInboundHandlerDefaults,
ChannelOutboundHandlerDefaults {
    private final SaslClient saslClient;

    public SaslDecoderEncoder(SaslClient saslClient) {
        this.saslClient = saslClient;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        byte[] decoded;
        if (!(msg instanceof ByteBuf)) {
            throw new IllegalArgumentException(String.valueOf(msg));
        }
        ByteBuf buf = (ByteBuf)msg;
        if (buf.hasArray()) {
            decoded = this.saslClient.unwrap(buf.array(), buf.arrayOffset() + buf.readerIndex(), buf.readableBytes());
        } else {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.getBytes(buf.readerIndex(), bytes);
            decoded = this.saslClient.unwrap(bytes, 0, bytes.length);
        }
        buf.release();
        ctx.fireChannelRead((Object)Unpooled.wrappedBuffer((byte[])decoded));
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        byte[] encoded;
        if (!(msg instanceof ByteBuf)) {
            throw new IllegalArgumentException(String.valueOf(msg));
        }
        ByteBuf buf = (ByteBuf)msg;
        if (buf.hasArray()) {
            encoded = this.saslClient.wrap(buf.array(), buf.arrayOffset() + buf.readerIndex(), buf.readableBytes());
        } else {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.getBytes(buf.readerIndex(), bytes);
            encoded = this.saslClient.wrap(bytes, 0, bytes.length);
        }
        buf.release();
        ctx.write((Object)Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.copyInt((int)encoded.length), Unpooled.wrappedBuffer((byte[])encoded)}), promise);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.fireExceptionCaught(cause);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
    }
}

