/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.aggregated;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.aggregated.AggregatePolicyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.representations.idm.authorization.AggregatePolicyRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;

public class AggregatePolicyProviderFactory
implements PolicyProviderFactory<AggregatePolicyRepresentation> {
    private AggregatePolicyProvider provider = new AggregatePolicyProvider();

    public String getName() {
        return "Aggregated";
    }

    public String getGroup() {
        return "Others";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public PolicyProvider create(KeycloakSession session) {
        return this.provider;
    }

    public void onCreate(Policy policy, AggregatePolicyRepresentation representation, AuthorizationProvider authorization) {
        this.verifyCircularReference(policy, new ArrayList<String>());
    }

    public void onUpdate(Policy policy, AggregatePolicyRepresentation representation, AuthorizationProvider authorization) {
        this.verifyCircularReference(policy, new ArrayList<String>());
    }

    public void onImport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        this.verifyCircularReference(policy, new ArrayList<String>());
    }

    public AggregatePolicyRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        return new AggregatePolicyRepresentation();
    }

    public Class<AggregatePolicyRepresentation> getRepresentationType() {
        return AggregatePolicyRepresentation.class;
    }

    private void verifyCircularReference(Policy policy, List<String> ids) {
        if (!policy.getType().equals("aggregate")) {
            return;
        }
        if (ids.contains(policy.getId())) {
            throw new RuntimeException("Circular reference found [" + policy.getName() + "].");
        }
        ids.add(policy.getId());
        for (Policy associated : policy.getAssociatedPolicies()) {
            this.verifyCircularReference(associated, ids);
        }
    }

    public void onRemove(Policy policy, AuthorizationProvider authorization) {
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "aggregate";
    }
}

