/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.aggregate;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.AggregateSupportImpl;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Column;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class SybaseASEAggregateSupport
extends AggregateSupportImpl {
    private static final AggregateSupport INSTANCE = new SybaseASEAggregateSupport();
    private static final String XML_EXTRACT_START = "xmlextract(";
    private static final String XML_EXTRACT_SEPARATOR = "/*',";
    private static final String XML_EXTRACT_SIMPLE_SEPARATOR = "',";
    private static final String XML_EXTRACT_END = ")";
    private static final String XML_EXTRACT_READ_START = "case when ";
    private static final String XML_EXTRACT_READ_NULL_CHECK = " is null then null else ";
    private static final String XML_EXTRACT_READ_INVOCATION_START = "'<e>'+xmlextract(";
    private static final String XML_EXTRACT_READ_END = " returns varchar(16384))+'</e>' end";

    private SybaseASEAggregateSupport() {
    }

    public static AggregateSupport valueOf(Dialect dialect) {
        return INSTANCE;
    }

    @Override
    public boolean supportsComponentCheckConstraints() {
        return false;
    }

    @Override
    public String aggregateComponentCustomReadExpression(String template, String placeholder, String aggregateParentReadExpression, String columnExpression, int aggregateColumnTypeCode, SqlTypedMapping column, TypeConfiguration typeConfiguration) {
        switch (aggregateColumnTypeCode) {
            case 2009: 
            case 3019: {
                switch (column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                    case -3: 
                    case -2: 
                    case 2004: 
                    case 4003: {
                        return template.replace(placeholder, "strtobin(xmlextract(" + SybaseASEAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/text()") + " returns varchar(16384)))");
                    }
                    case 91: 
                    case 92: 
                    case 93: 
                    case 3003: {
                        return template.replace(placeholder, "cast(str_replace(xmlextract(" + SybaseASEAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/text()") + " returns varchar(36)),'Z','') as " + column.getColumnDefinition() + XML_EXTRACT_END);
                    }
                    case 2009: {
                        return template.replace(placeholder, SybaseASEAggregateSupport.xmlExtractForConcat("'<e>'+", aggregateParentReadExpression, columnExpression + "/*", "+'</e>'"));
                    }
                    case 3019: {
                        if (typeConfiguration.getCurrentBaseSqlTypeIndicators().isXmlFormatMapperLegacyFormatEnabled()) {
                            throw new IllegalArgumentException("XML array '" + columnExpression + "' in '" + aggregateParentReadExpression + "' is not supported with legacy format enabled.");
                        }
                        return template.replace(placeholder, SybaseASEAggregateSupport.xmlExtractForConcat("'<Collection>'+", aggregateParentReadExpression, columnExpression + "/*", "+'</Collection>'"));
                    }
                    case -15: 
                    case -9: 
                    case 1: 
                    case 12: 
                    case 2005: 
                    case 2011: 
                    case 4001: 
                    case 4002: {
                        return template.replace(placeholder, "cast(str_replace(str_replace(str_replace(str_replace(xmlextract(" + SybaseASEAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/text()") + " returns varchar(16384)),'&lt;','<'),'&gt;','>'),'&quot;','\"'),'&amp;','&') as " + column.getColumnDefinition() + XML_EXTRACT_END);
                    }
                    case 3000: {
                        if (!SqlTypes.isBinaryType(column.getJdbcMapping().getJdbcType().getDdlTypeCode())) break;
                        return template.replace(placeholder, "strtobin(str_replace(xmlextract(" + SybaseASEAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/text()") + " returns varchar(36)),'-',null))");
                    }
                }
                return template.replace(placeholder, "cast(xmlextract(" + SybaseASEAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/text()") + " returns varchar(16384)) as " + column.getColumnDefinition() + XML_EXTRACT_END);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    private static String xmlExtractArguments(String aggregateParentReadExpression, String xpathFragment) {
        int separatorIndex;
        Object extractArguments;
        int patternIdx;
        if (aggregateParentReadExpression.startsWith(XML_EXTRACT_READ_START) && aggregateParentReadExpression.endsWith(XML_EXTRACT_READ_END) && (patternIdx = aggregateParentReadExpression.indexOf(XML_EXTRACT_READ_NULL_CHECK)) != -1 && aggregateParentReadExpression.regionMatches(patternIdx + XML_EXTRACT_READ_NULL_CHECK.length(), XML_EXTRACT_READ_INVOCATION_START, 0, XML_EXTRACT_READ_INVOCATION_START.length())) {
            int argumentsStartIndex = patternIdx + XML_EXTRACT_READ_NULL_CHECK.length() + XML_EXTRACT_READ_INVOCATION_START.length();
            int separatorIndex2 = aggregateParentReadExpression.indexOf(XML_EXTRACT_SEPARATOR);
            StringBuilder sb = new StringBuilder(aggregateParentReadExpression.length() - argumentsStartIndex + xpathFragment.length());
            sb.append(aggregateParentReadExpression, argumentsStartIndex, separatorIndex2);
            sb.append('/');
            sb.append(xpathFragment);
            sb.append(aggregateParentReadExpression, separatorIndex2 + 2, aggregateParentReadExpression.length() - XML_EXTRACT_READ_END.length());
            extractArguments = sb.toString();
        } else if (aggregateParentReadExpression.startsWith(XML_EXTRACT_START) && aggregateParentReadExpression.endsWith(XML_EXTRACT_END) && (separatorIndex = aggregateParentReadExpression.indexOf(XML_EXTRACT_SIMPLE_SEPARATOR)) != -1) {
            StringBuilder sb = new StringBuilder(aggregateParentReadExpression.length() - XML_EXTRACT_START.length() + xpathFragment.length());
            int xpathEnd = aggregateParentReadExpression.regionMatches(separatorIndex - 2, XML_EXTRACT_SEPARATOR, 0, XML_EXTRACT_SEPARATOR.length()) ? separatorIndex - 2 : separatorIndex;
            sb.append(aggregateParentReadExpression, XML_EXTRACT_START.length(), xpathEnd);
            sb.append('/');
            sb.append(xpathFragment);
            sb.append(aggregateParentReadExpression, separatorIndex, aggregateParentReadExpression.length() - 1);
            extractArguments = sb.toString();
        } else {
            extractArguments = "'/e/" + xpathFragment + XML_EXTRACT_SIMPLE_SEPARATOR + aggregateParentReadExpression;
        }
        return extractArguments;
    }

    private static String xmlExtractForConcat(String prefix, String aggregateParentReadExpression, String xpathFragment, String suffix) {
        Object extractArguments;
        Object caseExpression;
        int patternIdx;
        if (aggregateParentReadExpression.startsWith(XML_EXTRACT_READ_START) && aggregateParentReadExpression.endsWith(XML_EXTRACT_READ_END) && (patternIdx = aggregateParentReadExpression.indexOf(XML_EXTRACT_READ_NULL_CHECK)) != -1 && aggregateParentReadExpression.regionMatches(patternIdx + XML_EXTRACT_READ_NULL_CHECK.length(), XML_EXTRACT_READ_INVOCATION_START, 0, XML_EXTRACT_READ_INVOCATION_START.length())) {
            caseExpression = aggregateParentReadExpression.substring(0, patternIdx + XML_EXTRACT_READ_NULL_CHECK.length());
            int argumentsStartIndex = patternIdx + XML_EXTRACT_READ_NULL_CHECK.length() + XML_EXTRACT_READ_INVOCATION_START.length();
            int separatorIndex = aggregateParentReadExpression.indexOf(XML_EXTRACT_SEPARATOR);
            StringBuilder sb = new StringBuilder(aggregateParentReadExpression.length() - argumentsStartIndex + xpathFragment.length());
            sb.append(aggregateParentReadExpression, argumentsStartIndex, separatorIndex);
            sb.append('/');
            sb.append(xpathFragment);
            sb.append(aggregateParentReadExpression, separatorIndex + 2, aggregateParentReadExpression.length() - XML_EXTRACT_READ_END.length());
            extractArguments = sb.toString();
        } else {
            caseExpression = XML_EXTRACT_READ_START + aggregateParentReadExpression + XML_EXTRACT_READ_NULL_CHECK;
            extractArguments = "'/e/" + xpathFragment + XML_EXTRACT_SIMPLE_SEPARATOR + aggregateParentReadExpression;
        }
        return (String)caseExpression + prefix + XML_EXTRACT_START + (String)extractArguments + " returns varchar(16384))" + suffix + " end";
    }

    private static String customWriteExpression(String customWriteExpression, JdbcMapping jdbcMapping) {
        int sqlTypeCode = jdbcMapping.getJdbcType().getDefaultSqlTypeCode();
        switch (sqlTypeCode) {
            case 3000: {
                return "stuff(stuff(stuff(stuff(lower(bintostr(" + customWriteExpression + ")),9,0,'-'),14,0,'-'),19,0,'-'),24,0,'-')";
            }
            case 16: {
                return "case " + customWriteExpression + " when 1 then 'true' when 0 then 'false' end";
            }
            case -3: 
            case -2: 
            case 2004: 
            case 4003: {
                return "bintostr(" + customWriteExpression + XML_EXTRACT_END;
            }
            case 91: {
                return "left(convert(varchar," + customWriteExpression + ",140),10)";
            }
            case 92: {
                return "left(convert(varchar," + customWriteExpression + ",20),8)";
            }
            case 93: {
                return "str_replace(convert(varchar," + customWriteExpression + ",140),' ','T')";
            }
            case 3003: {
                return "nullif(str_replace(convert(varchar," + customWriteExpression + ",140),' ','T')+'Z','Z')";
            }
        }
        return customWriteExpression;
    }

    @Override
    public String aggregateComponentAssignmentExpression(String aggregateParentAssignmentExpression, String columnExpression, int aggregateColumnTypeCode, Column column) {
        switch (aggregateColumnTypeCode) {
            case 2009: 
            case 3019: {
                return aggregateParentAssignmentExpression;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    @Override
    public String aggregateCustomWriteExpression(AggregateColumn aggregateColumn, List<Column> aggregatedColumns) {
        int sqlTypeCode = aggregateColumn.getType().getJdbcType().getDefaultSqlTypeCode();
        switch (sqlTypeCode == 2003 ? aggregateColumn.getTypeCode() : sqlTypeCode) {
            case 2009: 
            case 3019: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumn.getTypeCode());
    }

    @Override
    public boolean requiresAggregateCustomWriteExpressionRenderer(int aggregateSqlTypeCode) {
        return aggregateSqlTypeCode == 2009;
    }

    @Override
    public AggregateSupport.WriteExpressionRenderer aggregateCustomWriteExpressionRenderer(SelectableMapping aggregateColumn, SelectableMapping[] columnsToUpdate, TypeConfiguration typeConfiguration) {
        int aggregateSqlTypeCode = aggregateColumn.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode();
        switch (aggregateSqlTypeCode) {
            case 2009: {
                return new RootXmlWriteExpression(aggregateColumn, columnsToUpdate);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateSqlTypeCode);
    }

    private static class RootXmlWriteExpression
    extends AggregateXmlWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final String path;

        RootXmlWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            super(aggregateColumn, aggregateColumn.getColumnDefinition());
            this.path = aggregateColumn.getSelectionExpression();
            this.initializeSubExpressions(aggregateColumn, columns);
        }

        @Override
        protected String getTagName() {
            return "e";
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object basePath = qualifier == null || qualifier.isBlank() ? this.path : qualifier + "." + this.path;
            this.append(sqlAppender, (String)basePath, translator, aggregateColumnWriteExpression);
        }
    }

    private static class PassThroughXmlWriteExpression
    implements XmlWriteExpression {
        private final SelectableMapping selectableMapping;

        PassThroughXmlWriteExpression(SelectableMapping selectableMapping) {
            this.selectableMapping = selectableMapping;
        }

        @Override
        public boolean isAggregate() {
            return this.selectableMapping.getJdbcMapping().getJdbcType().isXml();
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append(SybaseASEAggregateSupport.XML_EXTRACT_START);
            sb.append(SybaseASEAggregateSupport.xmlExtractArguments(path, this.selectableMapping.getSelectableName()));
            sb.append(" returns varchar(16384))");
        }
    }

    private static class BasicXmlWriteExpression
    implements XmlWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String[] customWriteExpressionParts;

        BasicXmlWriteExpression(SelectableMapping selectableMapping, String customWriteExpression) {
            this.selectableMapping = selectableMapping;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionParts = new String[]{"", ""};
            } else {
                assert (!customWriteExpression.startsWith("?"));
                String[] parts = StringHelper.split("?", customWriteExpression);
                assert (parts.length == 2 || (parts.length & 1) == 1);
                this.customWriteExpressionParts = parts;
            }
        }

        @Override
        public boolean isAggregate() {
            return this.selectableMapping.getJdbcMapping().getJdbcType().isXml();
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            JdbcType jdbcType = this.selectableMapping.getJdbcMapping().getJdbcType();
            boolean isArray = jdbcType.getDefaultSqlTypeCode() == 3019;
            boolean isString = jdbcType.isStringLike();
            sb.append(SybaseASEAggregateSupport.XML_EXTRACT_READ_START);
            translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
            sb.append(" is null then null else '<");
            sb.append(this.selectableMapping.getSelectableName());
            sb.append(">'+");
            if (isArray) {
                sb.append("xmlextract('/Collection/*',");
            } else if (isString) {
                sb.append("str_replace(str_replace(str_replace(");
                if (jdbcType.isLobOrLong()) {
                    sb.append("cast(");
                }
            } else {
                sb.append("cast(");
            }
            sb.append(this.customWriteExpressionParts[0]);
            for (int i = 1; i < this.customWriteExpressionParts.length; ++i) {
                translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
                sb.append(this.customWriteExpressionParts[i]);
            }
            if (isArray) {
                sb.append(" returns varchar(16384))");
            } else if (isString) {
                if (jdbcType.isLobOrLong()) {
                    sb.append(" as varchar(16384))");
                }
                sb.append(",'&','&amp;'),'<','&lt;'),'>','&gt;')");
            } else {
                sb.append(" as varchar(16384))");
            }
            sb.append("+'</");
            sb.append(this.selectableMapping.getSelectableName());
            sb.append(">' end");
        }
    }

    private static class AggregateXmlWriteExpression
    implements XmlWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String columnDefinition;
        private final LinkedHashMap<String, XmlWriteExpression> subExpressions = new LinkedHashMap();

        private AggregateXmlWriteExpression(SelectableMapping selectableMapping, String columnDefinition) {
            this.selectableMapping = selectableMapping;
            this.columnDefinition = columnDefinition;
        }

        @Override
        public boolean isAggregate() {
            return true;
        }

        protected void initializeSubExpressions(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                AggregateXmlWriteExpression currentAggregate = this;
                for (int i = 1; i < parts.length - 1; ++i) {
                    AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)currentAggregate.selectableMapping.getJdbcMapping().getJdbcType();
                    EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
                    int selectableIndex = embeddableMappingType.getSelectableIndex(parts[i].getSelectableName());
                    currentAggregate = (AggregateXmlWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateXmlWriteExpression(embeddableMappingType.getJdbcValueSelectable(selectableIndex), this.columnDefinition));
                }
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicXmlWriteExpression(column, SybaseASEAggregateSupport.customWriteExpression(customWriteExpression, column.getJdbcMapping())));
            }
            this.passThroughUnsetSubExpressions(aggregateColumn);
        }

        protected void passThroughUnsetSubExpressions(SelectableMapping aggregateColumn) {
            AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)aggregateColumn.getJdbcMapping().getJdbcType();
            EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
            int jdbcValueCount = embeddableMappingType.getJdbcValueCount();
            for (int i = 0; i < jdbcValueCount; ++i) {
                SelectableMapping selectableMapping = embeddableMappingType.getJdbcValueSelectable(i);
                XmlWriteExpression xmlWriteExpression = this.subExpressions.get(selectableMapping.getSelectableName());
                if (xmlWriteExpression == null) {
                    this.subExpressions.put(selectableMapping.getSelectableName(), new PassThroughXmlWriteExpression(selectableMapping));
                    continue;
                }
                if (!(xmlWriteExpression instanceof AggregateXmlWriteExpression)) continue;
                AggregateXmlWriteExpression writeExpression = (AggregateXmlWriteExpression)xmlWriteExpression;
                writeExpression.passThroughUnsetSubExpressions(selectableMapping);
            }
        }

        protected String getTagName() {
            return this.selectableMapping.getSelectableName();
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append("'<");
            sb.append(this.getTagName());
            sb.append(">'");
            for (Map.Entry<String, XmlWriteExpression> entry : this.subExpressions.entrySet()) {
                String column = entry.getKey();
                XmlWriteExpression value = entry.getValue();
                sb.append("+coalesce(");
                if (value instanceof AggregateXmlWriteExpression) {
                    String subPath = SybaseASEAggregateSupport.XML_EXTRACT_START + SybaseASEAggregateSupport.xmlExtractArguments(path, column) + SybaseASEAggregateSupport.XML_EXTRACT_END;
                    value.append(sb, subPath, translator, expression);
                } else {
                    value.append(sb, path, translator, expression);
                }
                sb.append(",'<");
                sb.append(column);
                sb.append("/>')");
            }
            sb.append("+'</");
            sb.append(this.getTagName());
            sb.append(">'");
        }
    }

    static interface XmlWriteExpression {
        public boolean isAggregate();

        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }
}

