/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.logging.json.runtime;

import io.quarkus.logging.json.runtime.AdditionalField;
import io.quarkus.logging.json.runtime.JsonFormatter;
import io.quarkus.logging.json.runtime.JsonLogConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logmanager.PropertyValues;
import org.jboss.logmanager.formatters.StructuredFormatter;

@Recorder
public class LoggingJsonRecorder {
    public RuntimeValue<Optional<Formatter>> initializeConsoleJsonLogging(JsonLogConfig config) {
        return this.getFormatter(config.consoleJson());
    }

    public RuntimeValue<Optional<Formatter>> initializeFileJsonLogging(JsonLogConfig config) {
        return this.getFormatter(config.fileJson());
    }

    public RuntimeValue<Optional<Formatter>> initializeSyslogJsonLogging(JsonLogConfig config) {
        return this.getFormatter(config.syslogJson());
    }

    public RuntimeValue<Optional<Formatter>> initializeSocketJsonLogging(JsonLogConfig config) {
        return this.getFormatter(config.socketJson());
    }

    private RuntimeValue<Optional<Formatter>> getFormatter(JsonLogConfig.JsonConfig config) {
        String keyOverrides = config.keyOverrides().orElse(null);
        Set<String> excludedKeys = config.excludedKeys().orElse(Set.of());
        Map additionalFields = config.additionalField().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new AdditionalField(((JsonLogConfig.AdditionalFieldConfig)e.getValue()).value(), ((JsonLogConfig.AdditionalFieldConfig)e.getValue()).type()), (x, y) -> y, LinkedHashMap::new));
        OverridableJsonConfig overridableJsonConfig = new OverridableJsonConfig(keyOverrides, excludedKeys, additionalFields);
        if (config.logFormat() == JsonLogConfig.JsonConfig.LogFormat.ECS) {
            overridableJsonConfig = this.addEcsFieldOverrides(overridableJsonConfig);
        }
        return this.getDefaultFormatter(config, overridableJsonConfig);
    }

    private RuntimeValue<Optional<Formatter>> getDefaultFormatter(JsonLogConfig.JsonConfig config, OverridableJsonConfig overridableJsonConfig) {
        if (!config.enabled().orElse(config.enable()).booleanValue()) {
            return new RuntimeValue(Optional.empty());
        }
        JsonFormatter formatter = overridableJsonConfig.keyOverrides() == null ? new JsonFormatter() : new JsonFormatter(overridableJsonConfig.keyOverrides());
        formatter.setExcludedKeys(overridableJsonConfig.excludedKeys());
        formatter.setAdditionalFields(overridableJsonConfig.additionalFields());
        formatter.setPrettyPrint(config.prettyPrint());
        String dateFormat = config.dateFormat();
        if (!dateFormat.equals("default")) {
            formatter.setDateFormat(dateFormat);
        }
        formatter.setExceptionOutputType(config.exceptionOutputType());
        formatter.setPrintDetails(config.printDetails());
        config.recordDelimiter().ifPresent(arg_0 -> ((JsonFormatter)formatter).setRecordDelimiter(arg_0));
        String zoneId = config.zoneId();
        if (!zoneId.equals("default")) {
            formatter.setZoneId(zoneId);
        }
        return new RuntimeValue(Optional.of(formatter));
    }

    private OverridableJsonConfig addEcsFieldOverrides(OverridableJsonConfig overridableJsonConfig) {
        EnumMap keyOverrides = PropertyValues.stringToEnumMap(StructuredFormatter.Key.class, (String)overridableJsonConfig.keyOverrides());
        keyOverrides.putIfAbsent(StructuredFormatter.Key.TIMESTAMP, "@timestamp");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.LOGGER_NAME, "log.logger");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.LEVEL, "log.level");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.PROCESS_ID, "process.pid");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.PROCESS_NAME, "process.name");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.THREAD_NAME, "process.thread.name");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.THREAD_ID, "process.thread.id");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.HOST_NAME, "host.hostname");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.SEQUENCE, "event.sequence");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.EXCEPTION_MESSAGE, "error.message");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.STACK_TRACE, "error.stack_trace");
        HashSet<String> excludedKeys = new HashSet<String>(overridableJsonConfig.excludedKeys());
        excludedKeys.add(StructuredFormatter.Key.LOGGER_CLASS_NAME.getKey());
        excludedKeys.add(StructuredFormatter.Key.RECORD.getKey());
        LinkedHashMap<String, AdditionalField> additionalFields = new LinkedHashMap<String, AdditionalField>(overridableJsonConfig.additionalFields());
        additionalFields.computeIfAbsent("ecs.version", k -> new AdditionalField("1.12.2", JsonLogConfig.AdditionalFieldConfig.Type.STRING));
        additionalFields.computeIfAbsent("data_stream.type", k -> new AdditionalField("logs", JsonLogConfig.AdditionalFieldConfig.Type.STRING));
        Config quarkusConfig = ConfigProvider.getConfig();
        quarkusConfig.getOptionalValue("quarkus.application.name", String.class).ifPresent(s -> additionalFields.computeIfAbsent("service.name", k -> new AdditionalField((String)s, JsonLogConfig.AdditionalFieldConfig.Type.STRING)));
        quarkusConfig.getOptionalValue("quarkus.application.version", String.class).ifPresent(s -> additionalFields.computeIfAbsent("service.version", k -> new AdditionalField((String)s, JsonLogConfig.AdditionalFieldConfig.Type.STRING)));
        quarkusConfig.getOptionalValue("quarkus.profile", String.class).ifPresent(s -> additionalFields.computeIfAbsent("service.environment", k -> new AdditionalField((String)s, JsonLogConfig.AdditionalFieldConfig.Type.STRING)));
        return new OverridableJsonConfig(PropertyValues.mapToString((EnumMap)keyOverrides), excludedKeys, additionalFields);
    }

    private record OverridableJsonConfig(String keyOverrides, Set<String> excludedKeys, Map<String, AdditionalField> additionalFields) {
    }
}

