/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.ModuleInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class CalculatingIndexView
implements IndexView {
    private static final Logger LOGGER = Logger.getLogger(CalculatingIndexView.class);
    private final IndexView index;
    private final ClassLoader classLoader;
    final Map<DotName, Optional<ClassInfo>> additionalClasses;

    public CalculatingIndexView(IndexView index, ClassLoader classLoader, Map<DotName, Optional<ClassInfo>> additionalClasses) {
        this.index = index;
        this.classLoader = classLoader;
        this.additionalClasses = additionalClasses;
    }

    public Collection<ClassInfo> getKnownClasses() {
        if (this.additionalClasses.isEmpty()) {
            return this.index.getKnownClasses();
        }
        Collection known = this.index.getKnownClasses();
        Collection additional = this.additionalClasses.values().stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        ArrayList<ClassInfo> all = new ArrayList<ClassInfo>(known.size() + additional.size());
        all.addAll(known);
        all.addAll(additional);
        return all;
    }

    public ClassInfo getClassByName(DotName className) {
        ClassInfo classInfo = this.index.getClassByName(className);
        if (classInfo == null) {
            classInfo = this.additionalClasses.computeIfAbsent(className, this::computeAdditional).orElse(null);
        }
        return classInfo;
    }

    public Collection<ClassInfo> getKnownDirectSubclasses(DotName className) {
        if (this.additionalClasses.isEmpty()) {
            return this.index.getKnownDirectSubclasses(className);
        }
        HashSet<ClassInfo> directSubclasses = new HashSet<ClassInfo>(this.index.getKnownDirectSubclasses(className));
        for (Optional<ClassInfo> additional : this.additionalClasses.values()) {
            if (!additional.isPresent() || !className.equals((Object)additional.get().superName())) continue;
            directSubclasses.add(additional.get());
        }
        return directSubclasses;
    }

    public Collection<ClassInfo> getAllKnownSubclasses(DotName className) {
        if (this.additionalClasses.isEmpty()) {
            return this.index.getAllKnownSubclasses(className);
        }
        HashSet<ClassInfo> allKnown = new HashSet<ClassInfo>();
        HashSet<DotName> processedClasses = new HashSet<DotName>();
        this.getAllKnownSubClasses(className, allKnown, processedClasses);
        return allKnown;
    }

    private void getAllKnownSubClasses(DotName className, Set<ClassInfo> allKnown, Set<DotName> processedClasses) {
        HashSet<DotName> subClassesToProcess = new HashSet<DotName>();
        subClassesToProcess.add(className);
        while (!subClassesToProcess.isEmpty()) {
            Iterator toProcess = subClassesToProcess.iterator();
            DotName name = (DotName)toProcess.next();
            toProcess.remove();
            processedClasses.add(name);
            this.getAllKnownSubClasses(name, allKnown, subClassesToProcess, processedClasses);
        }
    }

    private void getAllKnownSubClasses(DotName name, Set<ClassInfo> allKnown, Set<DotName> subClassesToProcess, Set<DotName> processedClasses) {
        Collection<ClassInfo> directSubclasses = this.getKnownDirectSubclasses(name);
        if (directSubclasses != null) {
            for (ClassInfo clazz : directSubclasses) {
                DotName className = clazz.name();
                if (processedClasses.contains(className)) continue;
                allKnown.add(clazz);
                subClassesToProcess.add(className);
            }
        }
    }

    public Collection<ClassInfo> getKnownDirectSubinterfaces(DotName interfaceName) {
        if (this.additionalClasses.isEmpty()) {
            return this.index.getKnownDirectSubinterfaces(interfaceName);
        }
        HashSet<ClassInfo> directSubinterfaces = new HashSet<ClassInfo>(this.index.getKnownDirectSubinterfaces(interfaceName));
        for (Optional<ClassInfo> additional : this.additionalClasses.values()) {
            if (!additional.isPresent() || !additional.get().interfaceNames().contains(interfaceName)) continue;
            directSubinterfaces.add(additional.get());
        }
        return directSubinterfaces;
    }

    public Collection<ClassInfo> getAllKnownSubinterfaces(DotName interfaceName) {
        if (this.additionalClasses.isEmpty()) {
            return this.index.getAllKnownSubinterfaces(interfaceName);
        }
        HashSet<ClassInfo> result = new HashSet<ClassInfo>();
        ArrayDeque<DotName> workQueue = new ArrayDeque<DotName>();
        HashSet<DotName> alreadyProcessed = new HashSet<DotName>();
        workQueue.add(interfaceName);
        while (!workQueue.isEmpty()) {
            DotName iface = (DotName)workQueue.remove();
            if (!alreadyProcessed.add(iface)) continue;
            for (ClassInfo directSubinterface : this.getKnownDirectSubinterfaces(iface)) {
                result.add(directSubinterface);
                workQueue.add(directSubinterface.name());
            }
        }
        return result;
    }

    public Collection<ClassInfo> getKnownDirectImplementors(DotName className) {
        if (this.additionalClasses.isEmpty()) {
            return this.index.getKnownDirectImplementors(className);
        }
        HashSet<ClassInfo> directImplementors = new HashSet<ClassInfo>(this.index.getKnownDirectImplementors(className));
        block0: for (Optional<ClassInfo> additional : this.additionalClasses.values()) {
            if (!additional.isPresent()) continue;
            for (Type interfaceType : additional.get().interfaceTypes()) {
                if (!className.equals((Object)interfaceType.name())) continue;
                directImplementors.add(additional.get());
                continue block0;
            }
        }
        return directImplementors;
    }

    public Collection<ClassInfo> getAllKnownImplementors(DotName interfaceName) {
        if (this.additionalClasses.isEmpty()) {
            return this.index.getAllKnownImplementors(interfaceName);
        }
        HashSet<ClassInfo> allKnown = new HashSet<ClassInfo>();
        HashSet<DotName> subInterfacesToProcess = new HashSet<DotName>();
        HashSet<DotName> processedClasses = new HashSet<DotName>();
        subInterfacesToProcess.add(interfaceName);
        while (!subInterfacesToProcess.isEmpty()) {
            Iterator toProcess = subInterfacesToProcess.iterator();
            DotName name = (DotName)toProcess.next();
            toProcess.remove();
            processedClasses.add(name);
            this.getKnownImplementors(name, allKnown, subInterfacesToProcess, processedClasses);
        }
        return allKnown;
    }

    private void getKnownImplementors(DotName name, Set<ClassInfo> allKnown, Set<DotName> subInterfacesToProcess, Set<DotName> processedClasses) {
        Collection<ClassInfo> list = this.getKnownDirectImplementors(name);
        if (list != null) {
            for (ClassInfo clazz : list) {
                DotName className = clazz.name();
                if (processedClasses.contains(className)) continue;
                if (Modifier.isInterface(clazz.flags())) {
                    subInterfacesToProcess.add(className);
                    continue;
                }
                if (allKnown.contains(clazz)) continue;
                allKnown.add(clazz);
                processedClasses.add(className);
                this.getAllKnownSubClasses(className, allKnown, processedClasses);
            }
        }
    }

    public Collection<AnnotationInstance> getAnnotations(DotName annotationName) {
        return this.index.getAnnotations(annotationName);
    }

    public Collection<AnnotationInstance> getAnnotationsWithRepeatable(DotName annotationName, IndexView index) {
        return this.index.getAnnotationsWithRepeatable(annotationName, index);
    }

    public Collection<ModuleInfo> getKnownModules() {
        return this.index.getKnownModules();
    }

    public ModuleInfo getModuleByName(DotName moduleName) {
        return this.index.getModuleByName(moduleName);
    }

    public Collection<ClassInfo> getKnownUsers(DotName className) {
        return this.index.getKnownUsers(className);
    }

    public Collection<ClassInfo> getClassesInPackage(DotName packageName) {
        if (this.additionalClasses.isEmpty()) {
            return this.index.getClassesInPackage(packageName);
        }
        HashSet<ClassInfo> classesInPackage = new HashSet<ClassInfo>(this.index.getClassesInPackage(packageName));
        for (Optional<ClassInfo> additional : this.additionalClasses.values()) {
            if (additional.isEmpty() || !Objects.equals(packageName, additional.get().name().packagePrefixName())) continue;
            classesInPackage.add(additional.get());
        }
        return classesInPackage;
    }

    public Set<DotName> getSubpackages(DotName packageName) {
        if (this.additionalClasses.isEmpty()) {
            return this.index.getSubpackages(packageName);
        }
        HashSet<DotName> subpackages = new HashSet<DotName>(this.index.getSubpackages(packageName));
        for (Optional<ClassInfo> additional : this.additionalClasses.values()) {
            if (additional.isEmpty()) continue;
            DotName pkg = additional.get().name().packagePrefixName();
            while (pkg != null) {
                DotName superPkg = pkg.packagePrefixName();
                if (superPkg != null && superPkg.equals((Object)packageName)) {
                    subpackages.add(pkg);
                }
                pkg = superPkg;
            }
        }
        return subpackages;
    }

    private Optional<ClassInfo> computeAdditional(DotName className) {
        LOGGER.debugf("Index: %s", (Object)className);
        Indexer indexer = new Indexer();
        if (CalculatingIndexView.index(indexer, className.toString(), this.classLoader)) {
            Index index = indexer.complete();
            return Optional.of(index.getClassByName(className));
        }
        return Optional.empty();
    }

    static boolean index(Indexer indexer, String className, ClassLoader classLoader) {
        boolean result = false;
        try (InputStream stream = classLoader.getResourceAsStream(className.replace('.', '/') + ".class");){
            if (stream != null) {
                indexer.index(stream);
                result = true;
            } else {
                LOGGER.warnf("Failed to index %s: Class does not exist in ClassLoader %s", (Object)className, (Object)classLoader);
            }
        }
        catch (IOException e) {
            LOGGER.warnf((Throwable)e, "Failed to index %s: %s", (Object)className, (Object)e.getMessage());
        }
        return result;
    }
}

