/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.ui.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.jboss.logging.Logger;
import org.keycloak.admin.ui.rest.model.BruteUser;
import org.keycloak.authorization.AdminPermissionsSchema;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.UserPermissionEvaluator;
import org.keycloak.utils.SearchQueryUtils;

public class BruteForceUsersResource {
    private static final Logger logger = Logger.getLogger(BruteForceUsersResource.class);
    private static final String SEARCH_ID_PARAMETER = "id:";
    private final KeycloakSession session;
    private final RealmModel realm;
    private final AdminPermissionEvaluator auth;

    public BruteForceUsersResource(KeycloakSession session, RealmModel realm, AdminPermissionEvaluator auth) {
        this.realm = realm;
        this.auth = auth;
        this.session = session;
    }

    /*
     * Enabled aggressive block sorting
     */
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Find all users and add if they are locked by brute force protection", description="Same endpoint as the users search but added brute force protection status.")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=BruteUser.class, type=SchemaType.ARRAY))})
    public final Stream<BruteUser> searchUser(@QueryParam(value="search") String search, @QueryParam(value="lastName") String last, @QueryParam(value="firstName") String first, @QueryParam(value="email") String email, @QueryParam(value="username") String username, @QueryParam(value="emailVerified") Boolean emailVerified, @QueryParam(value="idpAlias") String idpAlias, @QueryParam(value="idpUserId") String idpUserId, @QueryParam(value="first") @DefaultValue(value="-1") Integer firstResult, @QueryParam(value="max") @DefaultValue(value="100") Integer maxResults, @QueryParam(value="enabled") Boolean enabled, @QueryParam(value="briefRepresentation") Boolean briefRepresentation, @QueryParam(value="exact") Boolean exact, @QueryParam(value="q") String searchQuery) {
        UserPermissionEvaluator userPermissionEvaluator = this.auth.users();
        userPermissionEvaluator.requireQuery();
        Map searchAttributes = searchQuery == null ? Collections.emptyMap() : SearchQueryUtils.getFields((String)searchQuery);
        Stream<UserModel> userModels = Stream.empty();
        if (search != null) {
            if (search.startsWith(SEARCH_ID_PARAMETER)) {
                UserModel userModel = this.session.users().getUserById(this.realm, search.substring(SEARCH_ID_PARAMETER.length()).trim());
                if (userModel == null) return this.toRepresentation(this.realm, userPermissionEvaluator, briefRepresentation, userModels);
                userModels = Stream.of(userModel);
                return this.toRepresentation(this.realm, userPermissionEvaluator, briefRepresentation, userModels);
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("keycloak.session.realm.users.query.search", search.trim());
            if (enabled == null) return this.searchForUser(attributes, this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, false);
            attributes.put("enabled", enabled.toString());
            return this.searchForUser(attributes, this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, false);
        }
        if (last == null && first == null && email == null && username == null && emailVerified == null && idpAlias == null && idpUserId == null && enabled == null && exact == null) {
            if (searchAttributes.isEmpty()) return this.searchForUser(new HashMap<String, String>(), this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, false);
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (last != null) {
            attributes.put("lastName", last);
        }
        if (first != null) {
            attributes.put("firstName", first);
        }
        if (email != null) {
            attributes.put("email", email);
        }
        if (username != null) {
            attributes.put("username", username);
        }
        if (emailVerified != null) {
            attributes.put("emailVerified", emailVerified.toString());
        }
        if (idpAlias != null) {
            attributes.put("keycloak.session.realm.users.query.idp_alias", idpAlias);
        }
        if (idpUserId != null) {
            attributes.put("keycloak.session.realm.users.query.idp_user_id", idpUserId);
        }
        if (enabled != null) {
            attributes.put("enabled", enabled.toString());
        }
        if (exact != null) {
            attributes.put("keycloak.session.realm.users.query.exact", exact.toString());
        }
        attributes.putAll(searchAttributes);
        return this.searchForUser(attributes, this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, true);
    }

    private Stream<BruteUser> searchForUser(Map<String, String> attributes, RealmModel realm, UserPermissionEvaluator usersEvaluator, Boolean briefRepresentation, Integer firstResult, Integer maxResults, Boolean includeServiceAccounts) {
        Set groupIds;
        attributes.put("keycloak.session.realm.users.query.include_service_account", includeServiceAccounts.toString());
        if (!AdminPermissionsSchema.SCHEMA.isAdminPermissionsEnabled(realm) && !(groupIds = this.auth.groups().getGroupIdsWithViewPermission()).isEmpty()) {
            this.session.setAttribute("keycloak.session.realm.users.query.groups", (Object)groupIds);
        }
        return this.toRepresentation(realm, usersEvaluator, briefRepresentation, this.session.users().searchForUserStream(realm, attributes, firstResult, maxResults));
    }

    private Stream<BruteUser> toRepresentation(RealmModel realm, UserPermissionEvaluator usersEvaluator, Boolean briefRepresentation, Stream<UserModel> userModels) {
        boolean briefRepresentationB;
        boolean bl = briefRepresentationB = briefRepresentation != null && briefRepresentation != false;
        if (!AdminPermissionsSchema.SCHEMA.isAdminPermissionsEnabled(realm)) {
            usersEvaluator.grantIfNoPermission(this.session.getAttribute("keycloak.session.realm.users.query.groups") != null);
            userModels = userModels.filter(arg_0 -> ((UserPermissionEvaluator)usersEvaluator).canView(arg_0));
            usersEvaluator.grantIfNoPermission(this.session.getAttribute("keycloak.session.realm.users.query.groups") != null);
        }
        return userModels.map(user -> {
            UserRepresentation userRep = briefRepresentationB ? ModelToRepresentation.toBriefRepresentation((UserModel)user) : ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)realm, (UserModel)user);
            userRep.setAccess(usersEvaluator.getAccess(user));
            return userRep;
        }).map(this::getBruteForceStatus);
    }

    private BruteUser getBruteForceStatus(UserRepresentation user) {
        UserLoginFailureModel model;
        BruteUser bruteUser = new BruteUser(user);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("disabled", false);
        data.put("numFailures", 0);
        data.put("lastFailure", 0);
        data.put("lastIPFailure", "n/a");
        if (!this.realm.isBruteForceProtected()) {
            bruteUser.setBruteForceStatus(data);
        }
        if ((model = this.session.loginFailures().getUserLoginFailure(this.realm, user.getId())) == null) {
            bruteUser.setBruteForceStatus(data);
            return bruteUser;
        }
        boolean disabled = this.isTemporarilyDisabled(this.session, this.realm, user);
        if (disabled) {
            data.put("disabled", true);
        }
        data.put("numFailures", model.getNumFailures());
        data.put("lastFailure", model.getLastFailure());
        data.put("lastIPFailure", model.getLastIPFailure());
        bruteUser.setBruteForceStatus(data);
        return bruteUser;
    }

    public boolean isTemporarilyDisabled(KeycloakSession session, RealmModel realm, UserRepresentation user) {
        int failedLoginNotBefore;
        int currTime;
        UserLoginFailureModel failure = session.loginFailures().getUserLoginFailure(realm, user.getId());
        if (failure != null && (currTime = (int)(Time.currentTimeMillis() / 1000L)) < (failedLoginNotBefore = failure.getFailedLoginNotBefore())) {
            logger.debugv("Current: {0} notBefore: {1}", (Object)currTime, (Object)failedLoginNotBefore);
            return true;
        }
        return false;
    }
}

