/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats;

import java.util.HashMap;
import java.util.Map;

public interface ContainerStats {
    public static final String MEMORY_AVAILABLE = "memoryAvailable";
    public static final String MEMORY_MAX = "memoryMax";
    public static final String MEMORY_TOTAL = "memoryTotal";
    public static final String MEMORY_USED = "memoryUsed";
    public static final String[] LONG_ATTRIBUTES = new String[]{"memoryAvailable", "memoryMax", "memoryTotal", "memoryUsed"};

    public static Map<String, Number> getLocalStatMaps() {
        HashMap<String, Number> map = new HashMap<String, Number>();
        long available = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        long max = Runtime.getRuntime().maxMemory();
        map.put(MEMORY_AVAILABLE, available);
        map.put(MEMORY_MAX, max);
        map.put(MEMORY_TOTAL, total);
        map.put(MEMORY_USED, total - available);
        return map;
    }

    public long getMemoryAvailable();

    public long getMemoryMax();

    public long getMemoryTotal();

    public long getMemoryUsed();
}

