/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.topology.ManagerStatusResponse;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheStatusRequestCommand
extends AbstractCacheControlCommand {
    private static final Log log = LogFactory.getLog(CacheStatusRequestCommand.class);
    public static final byte COMMAND_ID = 96;
    private int viewId;

    public CacheStatusRequestCommand() {
        super((byte)96);
    }

    public CacheStatusRequestCommand(int viewId) {
        super((byte)96);
        this.viewId = viewId;
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        if (!gcr.isLocalTopologyManagerRunning()) {
            log.debug("Reply with empty status request because topology manager not running");
            return CompletableFuture.completedFuture(new ManagerStatusResponse(Collections.emptyMap(), true));
        }
        return gcr.getLocalTopologyManager().handleStatusRequest(this.viewId);
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeInt(this.viewId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.viewId = input.readInt();
    }

    public String toString() {
        return "CacheStatusRequestCommand{viewId=" + this.viewId + "}";
    }
}

