/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.remoting.transport.Address;

public class CacheLeaveCommand
extends AbstractCacheControlCommand {
    public static final byte COMMAND_ID = 86;
    private String cacheName;
    private int viewId;

    public CacheLeaveCommand() {
        super((byte)86);
    }

    public CacheLeaveCommand(String cacheName, Address origin, int viewId) {
        super((byte)86, origin);
        this.cacheName = cacheName;
        this.viewId = viewId;
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        return gcr.getClusterTopologyManager().handleLeave(this.cacheName, this.origin, this.viewId);
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallString((String)this.cacheName, (ObjectOutput)output);
        output.writeInt(this.viewId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.cacheName = MarshallUtil.unmarshallString((ObjectInput)input);
        this.viewId = input.readInt();
    }

    public String toString() {
        return "TopologyLeaveCommand{cacheName='" + this.cacheName + "', origin=" + String.valueOf(this.origin) + ", viewId=" + this.viewId + "}";
    }
}

