/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.client.maven;

import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.client.RegistryPlatformExtensionsResolver;
import io.quarkus.registry.client.maven.MavenRegistryArtifactResolver;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.ArtifactNotFoundException;

public class MavenPlatformExtensionsResolver
implements RegistryPlatformExtensionsResolver {
    private final MavenRegistryArtifactResolver artifactResolver;
    private final MessageWriter log;

    public MavenPlatformExtensionsResolver(MavenRegistryArtifactResolver artifactResolver, MessageWriter log) {
        this.artifactResolver = Objects.requireNonNull(artifactResolver);
        this.log = Objects.requireNonNull(log);
    }

    @Override
    public ExtensionCatalog.Mutable resolvePlatformExtensions(ArtifactCoords platformCoords) throws RegistryResolutionException {
        Path jsonPath;
        String version = platformCoords.getVersion() == null ? this.resolveLatestBomVersion(platformCoords, "[0-alpha,)") : (MavenPlatformExtensionsResolver.isVersionRange(platformCoords.getVersion()) ? this.resolveLatestBomVersion(platformCoords, platformCoords.getVersion()) : platformCoords.getVersion());
        String groupId = platformCoords.getGroupId();
        String artifactId = PlatformArtifacts.ensureCatalogArtifactId(platformCoords.getArtifactId());
        String classifier = version;
        DefaultArtifact catalogArtifact = new DefaultArtifact(groupId, artifactId, classifier, "json", version);
        this.log.debug("Resolving platform extension catalog %s", new Object[]{catalogArtifact});
        try {
            jsonPath = this.artifactResolver.resolve((Artifact)catalogArtifact);
        }
        catch (Exception e) {
            RemoteRepository repo = null;
            for (Throwable t = e; t != null; t = t.getCause()) {
                if (!(t instanceof ArtifactNotFoundException)) continue;
                repo = ((ArtifactNotFoundException)t).getRepository();
                break;
            }
            StringBuilder buf = new StringBuilder();
            buf.append("Failed to resolve extension catalog of ").append(PlatformArtifacts.ensureBomArtifact(platformCoords).toCompactCoords());
            if (repo != null) {
                buf.append(" from Maven repository ").append(repo.getId()).append(" (").append(repo.getUrl()).append(")");
                List mirrored = repo.getMirroredRepositories();
                if (!mirrored.isEmpty()) {
                    buf.append(" which is a mirror of ");
                    buf.append(((RemoteRepository)mirrored.get(0)).getId()).append(" (").append(((RemoteRepository)mirrored.get(0)).getUrl()).append(")");
                    for (int i = 1; i < mirrored.size(); ++i) {
                        buf.append(", ").append(((RemoteRepository)mirrored.get(i)).getId()).append(" (").append(((RemoteRepository)mirrored.get(i)).getUrl()).append(")");
                    }
                    buf.append(". The mirror may be out of sync.");
                }
            }
            throw new RegistryResolutionException(buf.toString(), e);
        }
        try {
            return ExtensionCatalog.mutableFromFile(jsonPath);
        }
        catch (IOException e) {
            throw new RegistryResolutionException("Failed to parse Quarkus extension catalog " + String.valueOf(jsonPath), e);
        }
    }

    private String resolveLatestBomVersion(ArtifactCoords bom, String versionRange) throws RegistryResolutionException {
        DefaultArtifact bomArtifact = new DefaultArtifact(bom.getGroupId(), PlatformArtifacts.ensureBomArtifactId(bom.getArtifactId()), "", "pom", bom.getVersion());
        this.log.debug("Resolving the latest version of %s:%s:%s:%s in the range %s", new Object[]{bom.getGroupId(), bom.getArtifactId(), bom.getClassifier(), bom.getType(), versionRange});
        try {
            return this.artifactResolver.getLatestVersionFromRange((Artifact)bomArtifact, versionRange);
        }
        catch (Exception e) {
            throw new RegistryResolutionException("Failed to resolve the latest version of " + bomArtifact.getGroupId() + ":" + bom.getArtifactId() + ":" + bom.getClassifier() + ":" + bom.getType() + ":" + versionRange, e);
        }
    }

    private static boolean isVersionRange(String versionStr) {
        if (versionStr == null || versionStr.isEmpty()) {
            return false;
        }
        char c = versionStr.charAt(0);
        if (c == '[' || c == '(') {
            return true;
        }
        c = versionStr.charAt(versionStr.length() - 1);
        if (c == ']' || c == ')') {
            return true;
        }
        return versionStr.indexOf(44) >= 0;
    }
}

