/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.catalog.PlatformRelease;
import io.quarkus.registry.catalog.PlatformReleaseImpl;
import io.quarkus.registry.catalog.PlatformReleaseVersion;
import io.quarkus.registry.catalog.PlatformStream;
import io.quarkus.registry.json.JsonBuilder;
import io.quarkus.registry.json.JsonEntityWithAnySupport;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"id", "name", "releases", "metadata"})
public class PlatformStreamImpl
extends JsonEntityWithAnySupport
implements PlatformStream {
    private final String id;
    private final String name;
    private final Map<PlatformReleaseVersion, PlatformRelease> releases;

    private PlatformStreamImpl(Builder builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.releases = JsonBuilder.buildUnmodifiableMap(builder.releases, LinkedHashMap::new);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<PlatformRelease> getReleases() {
        return this.releases.values();
    }

    @Override
    @JsonIgnore
    public PlatformRelease getRelease(PlatformReleaseVersion version) {
        return this.releases.get(version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof PlatformStream)) {
            return false;
        }
        PlatformStream that = (PlatformStream)o;
        return Objects.equals(this.id, that.getId());
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id='" + this.id + "', name='" + this.name + "', releases=" + String.valueOf(this.releases) + "}";
    }

    public static class Builder
    extends JsonEntityWithAnySupport.Builder
    implements PlatformStream.Mutable {
        private String id;
        private String name;
        private Map<PlatformReleaseVersion, PlatformRelease> releases;

        public Builder() {
        }

        Builder(PlatformStream source) {
            this.id = source.getId();
            this.name = source.getName();
            this.setReleases((Collection)source.getReleases());
            this.setMetadata((Map)source.getMetadata());
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Collection<PlatformRelease> getReleases() {
            return this.releases == null ? Collections.emptyList() : this.releases.values();
        }

        @Override
        @JsonDeserialize(contentAs=PlatformReleaseImpl.Builder.class)
        public Builder setReleases(Collection<PlatformRelease> newReleases) {
            if (this.releases != null) {
                this.releases.clear();
            }
            for (PlatformRelease r : newReleases) {
                this.addRelease(r);
            }
            return this;
        }

        @Override
        @JsonIgnore
        public PlatformRelease getRelease(PlatformReleaseVersion version) {
            return this.releases == null ? null : this.releases.get(version);
        }

        @Override
        public Builder addRelease(PlatformRelease platformRelease) {
            if (this.releases == null) {
                this.releases = new LinkedHashMap<PlatformReleaseVersion, PlatformRelease>();
            }
            this.releases.put(platformRelease.getVersion(), platformRelease);
            return this;
        }

        @Override
        public Builder setMetadata(Map<String, Object> metadata) {
            super.setMetadata(metadata);
            return this;
        }

        @Override
        public Builder setMetadata(String name, Object value) {
            super.setMetadata(name, value);
            return this;
        }

        @Override
        public Builder removeMetadata(String key) {
            super.removeMetadata(key);
            return this;
        }

        @Override
        public PlatformStreamImpl build() {
            return new PlatformStreamImpl(this);
        }
    }
}

