/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph;

import java.util.Iterator;
import java.util.List;
import org.hibernate.internal.log.SubSystemLogging;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultGraphNode;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.jboss.logging.Logger;

public class DomainResultGraphPrinter {
    private final StringBuilder buffer;
    private final Stack<FetchParent> fetchParentStack = new StandardStack<FetchParent>(FetchParent.class);

    public static void logDomainResultGraph(List<DomainResult<?>> domainResults) {
        DomainResultGraphPrinter.logDomainResultGraph("DomainResult Graph", domainResults);
    }

    public static void logDomainResultGraph(String header, List<DomainResult<?>> domainResults) {
        if (!Logging.AST_LOGGER.isDebugEnabled()) {
            return;
        }
        DomainResultGraphPrinter graphPrinter = new DomainResultGraphPrinter(header);
        graphPrinter.visitDomainResults(domainResults);
    }

    private DomainResultGraphPrinter(String header) {
        this.buffer = new StringBuilder(header + ":" + System.lineSeparator());
    }

    private void visitDomainResults(List<DomainResult<?>> domainResults) {
        for (int i = 0; i < domainResults.size(); ++i) {
            DomainResult<?> domainResult = domainResults.get(i);
            assert (this.fetchParentStack.isEmpty());
            boolean lastInBranch = i + 1 == domainResults.size();
            this.visitGraphNode(domainResult, lastInBranch);
        }
        Logging.AST_LOGGER.debug((Object)this.buffer.toString());
        if (Logging.AST_LOGGER.isTraceEnabled()) {
            Logging.AST_LOGGER.tracef((Throwable)new Exception(), "Stack trace calling DomainResultGraphPrinter", new Object[0]);
        }
    }

    private void visitGraphNode(DomainResultGraphNode node, boolean lastInBranch) {
        this.visitGraphNode(node, lastInBranch, node.getClass().getSimpleName());
    }

    private void visitGraphNode(DomainResultGraphNode node, boolean lastInBranch, String nodeText) {
        this.indentLine();
        if (lastInBranch) {
            this.buffer.append(" \\-");
        } else {
            this.buffer.append(" +-");
        }
        this.buffer.append(nodeText);
        if (node.getNavigablePath() != null) {
            this.buffer.append(" [").append(node.getNavigablePath().getFullPath()).append("]");
        }
        this.buffer.append('\n');
        if (node instanceof FetchParent) {
            this.visitFetches((FetchParent)node);
        }
    }

    private void visitKeyGraphNode(DomainResultGraphNode node, boolean lastInBranch) {
        this.visitGraphNode(node, lastInBranch, "(key) " + node.getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitFetches(FetchParent fetchParent) {
        this.fetchParentStack.push(fetchParent);
        try {
            Iterator<Fetch> iterator = fetchParent.getFetches().iterator();
            while (iterator.hasNext()) {
                Fetch fetch = iterator.next();
                boolean lastInBranch = !iterator.hasNext();
                this.visitGraphNode(fetch, lastInBranch);
            }
        }
        finally {
            this.fetchParentStack.pop();
        }
    }

    private void indentLine() {
        this.fetchParentStack.visitRootFirst(fetchParent -> {
            boolean hasSubFetches;
            boolean bl = hasSubFetches = !fetchParent.getFetches().isEmpty();
            if (hasSubFetches) {
                this.buffer.append(" | ");
            } else {
                this.buffer.append("   ");
            }
        });
    }

    @SubSystemLogging(name="org.hibernate.orm.results.graph.AST", description="Logging of `DomainResult` graphs")
    static interface Logging {
        public static final String LOGGER_NAME = "org.hibernate.orm.results.graph.AST";
        public static final Logger AST_LOGGER = Logger.getLogger((String)"org.hibernate.orm.results.graph.AST");
    }
}

