/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class AsWrappedExpression<B>
implements Expression,
DomainResultProducer<B> {
    private final Expression wrappedExpression;
    private final BasicType<B> expressionType;

    public AsWrappedExpression(Expression wrappedExpression, BasicType<B> expressionType) {
        assert (wrappedExpression instanceof DomainResultProducer) : "AsWrappedExpression expected to be an instance of DomainResultProducer";
        this.wrappedExpression = wrappedExpression;
        this.expressionType = expressionType;
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.expressionType;
    }

    @Override
    public ColumnReference getColumnReference() {
        return this.wrappedExpression.getColumnReference();
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, JavaType javaType, boolean virtual, TypeConfiguration typeConfiguration) {
        return this.wrappedExpression.createSqlSelection(jdbcPosition, valuesArrayPosition, javaType, virtual, typeConfiguration);
    }

    @Override
    public SqlSelection createDomainResultSqlSelection(int jdbcPosition, int valuesArrayPosition, JavaType javaType, boolean virtual, TypeConfiguration typeConfiguration) {
        return this.wrappedExpression.createDomainResultSqlSelection(jdbcPosition, valuesArrayPosition, javaType, virtual, typeConfiguration);
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.wrappedExpression.accept(sqlTreeWalker);
    }

    @Override
    public DomainResult<B> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlSelection sqlSelection = sqlAstCreationState.getSqlExpressionResolver().resolveSqlSelection(this.wrappedExpression, this.wrappedExpression.getExpressionType().getSingleJdbcMapping().getJdbcJavaType(), null, sqlAstCreationState.getCreationContext().getMappingMetamodel().getTypeConfiguration());
        return new BasicResult<B>(sqlSelection.getValuesArrayPosition(), resultVariable, this.expressionType.getExpressibleJavaType(), null, null, false, false);
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        ((DomainResultProducer)((Object)this.wrappedExpression)).applySqlSelections(creationState);
    }
}

