/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.ScrollMode;
import org.hibernate.internal.EmptyScrollableResults;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.sql.results.spi.ResultsConsumer;

public class AggregatedSelectQueryPlanImpl<R>
implements SelectQueryPlan<R> {
    private final SelectQueryPlan<R>[] aggregatedQueryPlans;

    public AggregatedSelectQueryPlanImpl(SelectQueryPlan<R>[] aggregatedQueryPlans) {
        this.aggregatedQueryPlans = aggregatedQueryPlans;
    }

    @Override
    public <T> T executeQuery(DomainQueryExecutionContext executionContext, ResultsConsumer<T, R> resultsConsumer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<R> performList(DomainQueryExecutionContext executionContext) {
        Limit effectiveLimit = executionContext.getQueryOptions().getEffectiveLimit();
        int maxRowsJpa = effectiveLimit.getMaxRowsJpa();
        if (maxRowsJpa == 0) {
            return Collections.emptyList();
        }
        int elementsToSkip = effectiveLimit.getFirstRowJpa();
        ArrayList<R> overallResults = new ArrayList<R>();
        for (SelectQueryPlan<R> aggregatedQueryPlan : this.aggregatedQueryPlans) {
            List<R> list = aggregatedQueryPlan.performList(executionContext);
            int size = list.size();
            if (size <= elementsToSkip) {
                elementsToSkip -= size;
                continue;
            }
            int availableElements = size - elementsToSkip;
            if (overallResults.size() + availableElements >= maxRowsJpa) {
                int end = elementsToSkip + (maxRowsJpa - overallResults.size());
                for (int i = elementsToSkip; i < end; ++i) {
                    overallResults.add(list.get(i));
                }
                break;
            }
            if (elementsToSkip > 0) {
                for (int i = availableElements; i < size; ++i) {
                    overallResults.add(list.get(i));
                }
                elementsToSkip = 0;
                continue;
            }
            overallResults.addAll(list);
        }
        return overallResults;
    }

    @Override
    public ScrollableResultsImplementor<R> performScroll(ScrollMode scrollMode, DomainQueryExecutionContext executionContext) {
        if (executionContext.getQueryOptions().getEffectiveLimit().getMaxRowsJpa() == 0) {
            return EmptyScrollableResults.INSTANCE;
        }
        throw new UnsupportedOperationException();
    }
}

