/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import java.lang.reflect.Method;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.internal.PropertyAccessStrategyBasicImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.GetterMethodImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.property.access.spi.SetterMethodImpl;
import org.jboss.logging.Logger;

public class PropertyAccessBasicImpl
implements PropertyAccess {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = Logger.getLogger(PropertyAccessBasicImpl.class);
    private final @UnknownKeyFor @NonNull @Initialized PropertyAccessStrategyBasicImpl strategy;
    private final @UnknownKeyFor @NonNull @Initialized GetterMethodImpl getter;
    private final @Nullable @UnknownKeyFor @Initialized SetterMethodImpl setter;

    public PropertyAccessBasicImpl(@UnknownKeyFor @NonNull @Initialized PropertyAccessStrategyBasicImpl strategy, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized boolean setterRequired) {
        this.strategy = strategy;
        Method getterMethod = ReflectHelper.findGetterMethod(containerJavaType, propertyName);
        this.getter = new GetterMethodImpl(containerJavaType, propertyName, getterMethod);
        Method setterMethod = setterRequired ? ReflectHelper.findSetterMethod(containerJavaType, propertyName, getterMethod.getReturnType()) : ReflectHelper.setterMethodOrNull(containerJavaType, propertyName, getterMethod.getReturnType());
        this.setter = setterMethod != null ? new SetterMethodImpl(containerJavaType, propertyName, setterMethod) : null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.strategy;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Getter getGetter() {
        return this.getter;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Setter getSetter() {
        return this.setter;
    }
}

