/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;

public class Index
implements Exportable,
Serializable {
    private Identifier name;
    private Table table;
    private boolean unique;
    private final List<Selectable> selectables = new ArrayList<Selectable>();
    private final Map<Selectable, String> selectableOrderMap = new HashMap<Selectable, String>();

    @Deprecated(forRemoval=true)
    public static String buildSqlDropIndexString(String name, String tableName) {
        return "drop index " + StringHelper.qualify(tableName, name);
    }

    @Deprecated(forRemoval=true)
    public static String buildSqlCreateIndexString(Dialect dialect, String name, String tableName, List<Column> columns, Map<Column, String> columnOrderMap, boolean unique) {
        StringBuilder statement = new StringBuilder(dialect.getCreateIndexString(unique)).append(" ").append(dialect.qualifyIndexName() ? name : StringHelper.unqualify(name)).append(" on ").append(tableName).append(" (");
        boolean first = true;
        for (Column column : columns) {
            if (first) {
                first = false;
            } else {
                statement.append(", ");
            }
            statement.append(column.getQuotedName(dialect));
            if (!columnOrderMap.containsKey(column)) continue;
            statement.append(" ").append(columnOrderMap.get(column));
        }
        statement.append(")");
        statement.append(dialect.getCreateIndexTail(unique, columns));
        return statement.toString();
    }

    @Deprecated(forRemoval=true)
    public static String buildSqlCreateIndexString(SqlStringGenerationContext context, String name, Table table, List<Column> columns, Map<Column, String> columnOrderMap, boolean unique, Metadata metadata) {
        return Index.buildSqlCreateIndexString(context.getDialect(), name, context.format(table.getQualifiedTableName()), columns, columnOrderMap, unique);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public int getColumnSpan() {
        return this.selectables.size();
    }

    public List<Selectable> getSelectables() {
        return Collections.unmodifiableList(this.selectables);
    }

    public Map<Selectable, String> getSelectableOrderMap() {
        return Collections.unmodifiableMap(this.selectableOrderMap);
    }

    @Deprecated(since="6.3")
    public List<Column> getColumns() {
        return this.selectables.stream().map(s -> (Column)s).collect(Collectors.toUnmodifiableList());
    }

    @Deprecated(since="6.3")
    public Map<Column, String> getColumnOrderMap() {
        return this.selectableOrderMap.entrySet().stream().collect(Collectors.toUnmodifiableMap(e -> (Column)e.getKey(), Map.Entry::getValue));
    }

    public void addColumn(Selectable selectable) {
        if (!this.selectables.contains(selectable)) {
            this.selectables.add(selectable);
        }
    }

    public void addColumn(Selectable selectable, String order) {
        this.addColumn(selectable);
        if (StringHelper.isNotEmpty(order)) {
            this.selectableOrderMap.put(selectable, order);
        }
    }

    @Deprecated(since="6.3", forRemoval=true)
    public void addColumns(List<Column> extraColumns) {
        for (Column column : extraColumns) {
            this.addColumn(column);
        }
    }

    @Deprecated(since="6.3", forRemoval=true)
    public boolean containsColumn(Column column) {
        return this.selectables.contains(column);
    }

    public String getName() {
        return this.name == null ? null : this.name.getText();
    }

    public void setName(String name) {
        this.name = Identifier.toIdentifier(name);
    }

    public String getQuotedName(Dialect dialect) {
        return this.name == null ? null : this.name.render(dialect);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getName() + ")";
    }

    @Override
    public String getExportIdentifier() {
        return StringHelper.qualify(this.getTable().getExportIdentifier(), "IDX-" + this.getName());
    }
}

