/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.query.spi.Limit;

public abstract class AbstractSimpleLimitHandler
extends AbstractLimitHandler {
    protected abstract String limitClause(boolean var1);

    protected String offsetOnlyClause() {
        return null;
    }

    @Override
    public String processSql(String sql, Limit limit) {
        if (!AbstractSimpleLimitHandler.hasMaxRows(limit)) {
            String offsetOnlyClause = this.offsetOnlyClause();
            if (offsetOnlyClause != null && AbstractSimpleLimitHandler.hasFirstRow(limit)) {
                return this.insert(offsetOnlyClause, sql);
            }
            return sql;
        }
        return this.insert(this.limitClause(AbstractSimpleLimitHandler.hasFirstRow(limit)), sql);
    }

    protected String insert(String limitClause, String sql) {
        return this.insertBeforeForUpdate(limitClause, sql);
    }

    @Override
    public final boolean supportsLimit() {
        return true;
    }

    @Override
    public final boolean supportsVariableLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return super.supportsOffset();
    }
}

