/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.type.BasicPluralType;

public class ArrayContainsArgumentTypeResolver
implements FunctionArgumentTypeResolver {
    public static final FunctionArgumentTypeResolver INSTANCE = new ArrayContainsArgumentTypeResolver();

    @Override
    public MappingModelExpressible<?> resolveFunctionArgumentType(SqmFunction<?> function, int argumentIndex, SqmToSqlAstConverter converter) {
        if (argumentIndex == 0) {
            MappingModelExpressible<?> expressible;
            SqmTypedNode<?> node = function.getArguments().get(1);
            if (node instanceof SqmExpression && (expressible = converter.determineValueMapping((SqmExpression)node)) != null) {
                if (expressible.getSingleJdbcMapping() instanceof BasicPluralType) {
                    return expressible;
                }
                return DdlTypeHelper.resolveArrayType((DomainType)((Object)expressible.getSingleJdbcMapping()), converter.getCreationContext().getSessionFactory().getTypeConfiguration());
            }
        } else if (argumentIndex == 1) {
            MappingModelExpressible<?> expressible;
            SqmTypedNode<?> nodeToResolve = function.getArguments().get(1);
            if (nodeToResolve.getExpressible() instanceof MappingModelExpressible) {
                return null;
            }
            SqmTypedNode<?> node = function.getArguments().get(0);
            if (node instanceof SqmExpression && (expressible = converter.determineValueMapping((SqmExpression)node)) instanceof BasicPluralType) {
                return expressible;
            }
        }
        return null;
    }
}

