/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.SessionFactoryRegistry;

class SessionFactoryObserverForRegistration
implements SessionFactoryObserver {
    private JndiService jndiService;
    private boolean registeredInJndi;

    SessionFactoryObserverForRegistration() {
    }

    @Override
    public void sessionFactoryCreated(SessionFactory factory) {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)factory;
        this.jndiService = sessionFactory.getServiceRegistry().getService(JndiService.class);
        this.registeredInJndi = sessionFactory.getSessionFactoryOptions().isSessionFactoryNameAlsoJndiName();
        SessionFactoryRegistry.INSTANCE.addSessionFactory(sessionFactory.getUuid(), sessionFactory.getName(), this.registeredInJndi, sessionFactory, this.jndiService);
    }

    @Override
    public void sessionFactoryClosed(SessionFactory factory) {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)factory;
        SessionFactoryRegistry.INSTANCE.removeSessionFactory(sessionFactory.getUuid(), sessionFactory.getName(), this.registeredInJndi, this.jndiService);
    }
}

