/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.PessimisticLockScope;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hibernate.LockMode;

public class LockOptions
implements Serializable {
    public static final LockOptions NONE = new LockOptions(true, LockMode.NONE);
    public static final LockOptions READ = new LockOptions(true, LockMode.READ);
    static final LockOptions OPTIMISTIC = new LockOptions(true, LockMode.OPTIMISTIC);
    static final LockOptions OPTIMISTIC_FORCE_INCREMENT = new LockOptions(true, LockMode.OPTIMISTIC_FORCE_INCREMENT);
    static final LockOptions PESSIMISTIC_READ = new LockOptions(true, LockMode.PESSIMISTIC_READ);
    static final LockOptions PESSIMISTIC_WRITE = new LockOptions(true, LockMode.PESSIMISTIC_WRITE);
    static final LockOptions PESSIMISTIC_FORCE_INCREMENT = new LockOptions(true, LockMode.PESSIMISTIC_FORCE_INCREMENT);
    static final LockOptions UPGRADE_NOWAIT = new LockOptions(true, LockMode.UPGRADE_NOWAIT);
    static final LockOptions UPGRADE_SKIPLOCKED = new LockOptions(true, LockMode.UPGRADE_SKIPLOCKED);
    public static final LockOptions UPGRADE = PESSIMISTIC_WRITE;
    public static final int NO_WAIT = 0;
    public static final int WAIT_FOREVER = -1;
    @Deprecated
    public static final int SKIP_LOCKED = -2;
    private final boolean immutable;
    private LockMode lockMode;
    private int timeout;
    private boolean scope;
    private Boolean followOnLocking;
    private Map<String, LockMode> aliasSpecificLockModes;

    public LockOptions() {
        this.immutable = false;
        this.lockMode = LockMode.NONE;
        this.timeout = -1;
    }

    public LockOptions(LockMode lockMode) {
        this.immutable = false;
        this.lockMode = lockMode;
        this.timeout = -1;
    }

    public LockOptions(LockMode lockMode, int timeout) {
        this.immutable = false;
        this.lockMode = lockMode;
        this.timeout = timeout;
    }

    public LockOptions(LockMode lockMode, int timeout, PessimisticLockScope scope) {
        this.immutable = false;
        this.lockMode = lockMode;
        this.timeout = timeout;
        this.scope = scope == PessimisticLockScope.EXTENDED;
    }

    private LockOptions(boolean immutable, LockMode lockMode) {
        this.immutable = immutable;
        this.lockMode = lockMode;
        this.timeout = -1;
    }

    public boolean isEmpty() {
        return this.lockMode == LockMode.NONE && this.timeout == -1 && this.followOnLocking == null && !this.scope && !this.hasAliasSpecificLockModes();
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public LockOptions setLockMode(LockMode lockMode) {
        if (this.immutable) {
            throw new UnsupportedOperationException("immutable global instance of LockMode");
        }
        this.lockMode = lockMode;
        return this;
    }

    public LockOptions setAliasSpecificLockMode(String alias, LockMode lockMode) {
        if (this.immutable) {
            throw new UnsupportedOperationException("immutable global instance of LockMode");
        }
        if (this.aliasSpecificLockModes == null) {
            this.aliasSpecificLockModes = new LinkedHashMap<String, LockMode>();
        }
        if (lockMode == null) {
            this.aliasSpecificLockModes.remove(alias);
        } else {
            this.aliasSpecificLockModes.put(alias, lockMode);
        }
        return this;
    }

    public LockMode getAliasSpecificLockMode(String alias) {
        return this.aliasSpecificLockModes == null ? null : this.aliasSpecificLockModes.get(alias);
    }

    public LockMode getEffectiveLockMode(String alias) {
        LockMode lockMode = this.getAliasSpecificLockMode(alias);
        if (lockMode == null) {
            lockMode = this.lockMode;
        }
        return lockMode == null ? LockMode.NONE : lockMode;
    }

    public boolean hasAliasSpecificLockModes() {
        return this.aliasSpecificLockModes != null && !this.aliasSpecificLockModes.isEmpty();
    }

    public int getAliasLockCount() {
        return this.aliasSpecificLockModes == null ? 0 : this.aliasSpecificLockModes.size();
    }

    @Deprecated
    public Iterator<Map.Entry<String, LockMode>> getAliasLockIterator() {
        return this.getAliasSpecificLocks().iterator();
    }

    public Set<Map.Entry<String, LockMode>> getAliasSpecificLocks() {
        return this.aliasSpecificLockModes == null ? Collections.emptySet() : Collections.unmodifiableSet(this.aliasSpecificLockModes.entrySet());
    }

    public LockMode findGreatestLockMode() {
        LockMode lockModeToUse = this.getLockMode();
        if (lockModeToUse == null) {
            lockModeToUse = LockMode.NONE;
        }
        if (this.aliasSpecificLockModes == null) {
            return lockModeToUse;
        }
        for (LockMode lockMode : this.aliasSpecificLockModes.values()) {
            if (!lockMode.greaterThan(lockModeToUse)) continue;
            lockModeToUse = lockMode;
        }
        return lockModeToUse;
    }

    public int getTimeOut() {
        return this.timeout;
    }

    public LockOptions setTimeOut(int timeout) {
        if (this.immutable) {
            throw new UnsupportedOperationException("immutable global instance of LockMode");
        }
        this.timeout = timeout;
        return this;
    }

    public PessimisticLockScope getLockScope() {
        return this.scope ? PessimisticLockScope.EXTENDED : PessimisticLockScope.NORMAL;
    }

    public LockOptions setLockScope(PessimisticLockScope scope) {
        if (this.immutable) {
            throw new UnsupportedOperationException("immutable global instance of LockMode");
        }
        return this.setScope(scope == PessimisticLockScope.EXTENDED);
    }

    @Deprecated(since="6.2")
    public boolean getScope() {
        return this.scope;
    }

    @Deprecated(since="6.2")
    public LockOptions setScope(boolean scope) {
        if (this.immutable) {
            throw new UnsupportedOperationException("immutable global instance of LockMode");
        }
        this.scope = scope;
        return this;
    }

    public Boolean getFollowOnLocking() {
        return this.followOnLocking;
    }

    public LockOptions setFollowOnLocking(Boolean followOnLocking) {
        if (this.immutable) {
            throw new UnsupportedOperationException("immutable global instance of LockMode");
        }
        this.followOnLocking = followOnLocking;
        return this;
    }

    public LockOptions makeCopy() {
        LockOptions copy = new LockOptions();
        LockOptions.copy(this, copy);
        return copy;
    }

    public LockOptions makeDefensiveCopy() {
        if (this.immutable) {
            return this;
        }
        LockOptions copy = new LockOptions();
        LockOptions.copy(this, copy);
        return copy;
    }

    public void overlay(LockOptions lockOptions) {
        this.setLockMode(lockOptions.getLockMode());
        this.setScope(lockOptions.getScope());
        this.setTimeOut(lockOptions.getTimeOut());
        if (lockOptions.aliasSpecificLockModes != null) {
            lockOptions.aliasSpecificLockModes.forEach(this::setAliasSpecificLockMode);
        }
        this.setFollowOnLocking(lockOptions.getFollowOnLocking());
    }

    public static LockOptions copy(LockOptions source, LockOptions destination) {
        destination.setLockMode(source.getLockMode());
        destination.setScope(source.getScope());
        destination.setTimeOut(source.getTimeOut());
        if (source.aliasSpecificLockModes != null) {
            destination.aliasSpecificLockModes = new HashMap<String, LockMode>(source.aliasSpecificLockModes);
        }
        destination.setFollowOnLocking(source.getFollowOnLocking());
        return destination;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LockOptions)) {
            return false;
        }
        LockOptions that = (LockOptions)object;
        return this.timeout == that.timeout && this.scope == that.scope && this.lockMode == that.lockMode && Objects.equals(this.aliasSpecificLockModes, that.aliasSpecificLockModes) && Objects.equals(this.followOnLocking, that.followOnLocking);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lockMode, this.timeout, this.aliasSpecificLockModes, this.followOnLocking, this.scope});
    }
}

