/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MessageDigestUtil {
    private MessageDigestUtil() {
    }

    public static @NonNull MessageDigest createMessageDigest(@NonNull String hashAlgorithm) {
        try {
            switch (hashAlgorithm) {
                case "S256": {
                    return MessageDigest.getInstance("SHA-256");
                }
                case "S384": {
                    return MessageDigest.getInstance("SHA-384");
                }
                case "S512": {
                    return MessageDigest.getInstance("SHA-512");
                }
            }
            return MessageDigest.getInstance(hashAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static @NonNull MessageDigest createSHA256() {
        return MessageDigestUtil.createMessageDigest("SHA-256");
    }
}

