/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.datagram;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyDelegate;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.datagram.DatagramPacket;
import io.vertx.mutiny.core.metrics.Measured;
import io.vertx.mutiny.core.net.SocketAddress;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

@MutinyGen(value=io.vertx.core.datagram.DatagramSocket.class)
public class DatagramSocket
implements MutinyDelegate,
ReadStream<DatagramPacket>,
Measured {
    public static final TypeArg<DatagramSocket> __TYPE_ARG = new TypeArg(obj -> new DatagramSocket((io.vertx.core.datagram.DatagramSocket)obj), DatagramSocket::getDelegate);
    private final io.vertx.core.datagram.DatagramSocket delegate;
    static final TypeArg<DatagramPacket> TYPE_ARG_0 = new TypeArg(o1 -> DatagramPacket.newInstance((io.vertx.core.datagram.DatagramPacket)o1), o1 -> o1.getDelegate());
    static final TypeArg<Buffer> TYPE_ARG_1 = new TypeArg(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
    private SocketAddress cached_0;
    private Multi<DatagramPacket> multi;

    public DatagramSocket(io.vertx.core.datagram.DatagramSocket delegate) {
        this.delegate = delegate;
    }

    public DatagramSocket(Object delegate) {
        this.delegate = (io.vertx.core.datagram.DatagramSocket)delegate;
    }

    DatagramSocket() {
        this.delegate = null;
    }

    public io.vertx.core.datagram.DatagramSocket getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatagramSocket that = (DatagramSocket)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    @Override
    public Pipe<DatagramPacket> pipe() {
        Pipe<DatagramPacket> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> pipeTo(WriteStream<DatagramPacket> dst) {
        return AsyncResultUni.toUni(handler -> this.delegate.pipeTo(dst.getDelegate(), handler));
    }

    @Override
    public Void pipeToAndAwait(WriteStream<DatagramPacket> dst) {
        return (Void)this.pipeTo(dst).await().indefinitely();
    }

    @Override
    public void pipeToAndForget(WriteStream<DatagramPacket> dst) {
        this.pipeTo(dst).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> send(Buffer packet, int port, String host) {
        return AsyncResultUni.toUni(handler -> this.delegate.send(packet.getDelegate(), port, host, handler));
    }

    public Void sendAndAwait(Buffer packet, int port, String host) {
        return (Void)this.send(packet, port, host).await().indefinitely();
    }

    @Fluent
    public DatagramSocket sendAndForget(Buffer packet, int port, String host) {
        this.send(packet, port, host).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public WriteStream<Buffer> sender(int port, String host) {
        WriteStream<Buffer> ret = WriteStream.newInstance(this.delegate.sender(port, host), TYPE_ARG_1);
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> send(String str, int port, String host) {
        return AsyncResultUni.toUni(handler -> this.delegate.send(str, port, host, handler));
    }

    public Void sendAndAwait(String str, int port, String host) {
        return (Void)this.send(str, port, host).await().indefinitely();
    }

    @Fluent
    public DatagramSocket sendAndForget(String str, int port, String host) {
        this.send(str, port, host).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> send(String str, String enc, int port, String host) {
        return AsyncResultUni.toUni(handler -> this.delegate.send(str, enc, port, host, handler));
    }

    public Void sendAndAwait(String str, String enc, int port, String host) {
        return (Void)this.send(str, enc, port, host).await().indefinitely();
    }

    @Fluent
    public DatagramSocket sendAndForget(String str, String enc, int port, String host) {
        this.send(str, enc, port, host).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close(handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> listenMulticastGroup(String multicastAddress) {
        return AsyncResultUni.toUni(handler -> this.delegate.listenMulticastGroup(multicastAddress, handler));
    }

    public Void listenMulticastGroupAndAwait(String multicastAddress) {
        return (Void)this.listenMulticastGroup(multicastAddress).await().indefinitely();
    }

    @Fluent
    public DatagramSocket listenMulticastGroupAndForget(String multicastAddress) {
        this.listenMulticastGroup(multicastAddress).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> listenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return AsyncResultUni.toUni(handler -> this.delegate.listenMulticastGroup(multicastAddress, networkInterface, source, handler));
    }

    public Void listenMulticastGroupAndAwait(String multicastAddress, String networkInterface, String source) {
        return (Void)this.listenMulticastGroup(multicastAddress, networkInterface, source).await().indefinitely();
    }

    @Fluent
    public DatagramSocket listenMulticastGroupAndForget(String multicastAddress, String networkInterface, String source) {
        this.listenMulticastGroup(multicastAddress, networkInterface, source).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> unlistenMulticastGroup(String multicastAddress) {
        return AsyncResultUni.toUni(handler -> this.delegate.unlistenMulticastGroup(multicastAddress, handler));
    }

    public Void unlistenMulticastGroupAndAwait(String multicastAddress) {
        return (Void)this.unlistenMulticastGroup(multicastAddress).await().indefinitely();
    }

    @Fluent
    public DatagramSocket unlistenMulticastGroupAndForget(String multicastAddress) {
        this.unlistenMulticastGroup(multicastAddress).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> unlistenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return AsyncResultUni.toUni(handler -> this.delegate.unlistenMulticastGroup(multicastAddress, networkInterface, source, handler));
    }

    public Void unlistenMulticastGroupAndAwait(String multicastAddress, String networkInterface, String source) {
        return (Void)this.unlistenMulticastGroup(multicastAddress, networkInterface, source).await().indefinitely();
    }

    @Fluent
    public DatagramSocket unlistenMulticastGroupAndForget(String multicastAddress, String networkInterface, String source) {
        this.unlistenMulticastGroup(multicastAddress, networkInterface, source).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> blockMulticastGroup(String multicastAddress, String sourceToBlock) {
        return AsyncResultUni.toUni(handler -> this.delegate.blockMulticastGroup(multicastAddress, sourceToBlock, handler));
    }

    public Void blockMulticastGroupAndAwait(String multicastAddress, String sourceToBlock) {
        return (Void)this.blockMulticastGroup(multicastAddress, sourceToBlock).await().indefinitely();
    }

    @Fluent
    public DatagramSocket blockMulticastGroupAndForget(String multicastAddress, String sourceToBlock) {
        this.blockMulticastGroup(multicastAddress, sourceToBlock).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) {
        return AsyncResultUni.toUni(handler -> this.delegate.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, handler));
    }

    public Void blockMulticastGroupAndAwait(String multicastAddress, String networkInterface, String sourceToBlock) {
        return (Void)this.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock).await().indefinitely();
    }

    @Fluent
    public DatagramSocket blockMulticastGroupAndForget(String multicastAddress, String networkInterface, String sourceToBlock) {
        this.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<DatagramSocket> listen(int port, String host) {
        return AsyncResultUni.toUni(handler -> this.delegate.listen(port, host, MutinyHelper.convertHandler((Handler)handler, ar -> ar.map(event -> DatagramSocket.newInstance(event)))));
    }

    public DatagramSocket listenAndAwait(int port, String host) {
        return (DatagramSocket)this.listen(port, host).await().indefinitely();
    }

    @Fluent
    public DatagramSocket listenAndForget(int port, String host) {
        this.listen(port, host).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Deprecated
    @Fluent
    public DatagramSocket pause() {
        this.delegate.pause();
        return this;
    }

    @Deprecated
    @Fluent
    public DatagramSocket resume() {
        this.delegate.resume();
        return this;
    }

    @Deprecated
    @Fluent
    public DatagramSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Deprecated
    @Fluent
    private DatagramSocket __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    @Deprecated
    public DatagramSocket endHandler(Runnable endHandler) {
        return this.__endHandler((Handler<Void>)((Handler)ignored -> endHandler.run()));
    }

    @Fluent
    private DatagramSocket __handler(Handler<DatagramPacket> handler) {
        this.delegate.handler(MutinyHelper.convertHandler(handler, event -> DatagramPacket.newInstance(event)));
        return this;
    }

    public DatagramSocket handler(Consumer<DatagramPacket> handler) {
        return this.__handler((Handler<DatagramPacket>)MutinyHelper.convertConsumer(handler));
    }

    @Fluent
    private DatagramSocket __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public DatagramSocket exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)MutinyHelper.convertConsumer(handler));
    }

    @Override
    @CheckReturnValue
    public synchronized Multi<DatagramPacket> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.datagram.DatagramPacket, DatagramPacket> conv = DatagramPacket::newInstance;
            this.multi = MultiHelper.toMulti((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<DatagramPacket> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<DatagramPacket> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static DatagramSocket newInstance(io.vertx.core.datagram.DatagramSocket arg) {
        return arg != null ? new DatagramSocket(arg) : null;
    }
}

