/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.reflection;

import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.core.reflection.ReflectionConstructorParameterConverter;
import org.jboss.resteasy.reactive.server.core.reflection.ReflectionValueOfParameterConverter;

public class ReflectionConstructorParameterConverterSupplier
implements ParameterConverterSupplier {
    private String targetTypeName;

    public ReflectionConstructorParameterConverterSupplier() {
    }

    public ReflectionConstructorParameterConverterSupplier(String targetTypeName) {
        this.targetTypeName = targetTypeName;
    }

    @Override
    public ParameterConverter get() {
        try {
            return new ReflectionConstructorParameterConverter(Thread.currentThread().getContextClassLoader().loadClass(this.targetTypeName).getDeclaredConstructor(String.class));
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getClassName() {
        return ReflectionValueOfParameterConverter.class.getName();
    }

    public String getTargetTypeName() {
        return this.targetTypeName;
    }

    public ReflectionConstructorParameterConverterSupplier setTargetTypeName(String targetTypeName) {
        this.targetTypeName = targetTypeName;
        return this;
    }
}

