/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.vertx.http.runtime.PolicyMappingConfig;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.quarkus.vertx.http.runtime.security.AbstractPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.AuthorizationPolicyStorage;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Instance;
import java.util.HashMap;
import java.util.Map;

public class JaxRsPathMatchingHttpSecurityPolicy {
    private final AbstractPathMatchingHttpSecurityPolicy delegate;
    private final boolean foundNoAnnotatedMethods;
    private final HttpSecurityPolicy.AuthorizationRequestContext requestContext;
    private final Map<String, HttpSecurityPolicy> policyNameToPolicy;
    private final AuthorizationPolicyStorage storage;

    JaxRsPathMatchingHttpSecurityPolicy(AuthorizationPolicyStorage storage, Instance<HttpSecurityPolicy> installedPolicies, VertxHttpConfig httpConfig, VertxHttpBuildTimeConfig httpBuildTimeConfig, BlockingSecurityExecutor blockingSecurityExecutor) {
        this.storage = storage;
        this.delegate = new AbstractPathMatchingHttpSecurityPolicy(httpConfig.auth().permissions(), httpConfig.auth().rolePolicy(), httpBuildTimeConfig.rootPath(), installedPolicies, PolicyMappingConfig.AppliesTo.JAXRS);
        this.foundNoAnnotatedMethods = storage.getMethodToPolicyName().isEmpty();
        this.requestContext = new HttpSecurityPolicy.DefaultAuthorizationRequestContext(blockingSecurityExecutor);
        if (storage.getMethodToPolicyName().isEmpty()) {
            this.policyNameToPolicy = Map.of();
        } else {
            HashMap<String, HttpSecurityPolicy> allPolicies = new HashMap<String, HttpSecurityPolicy>();
            for (HttpSecurityPolicy installedPolicy : installedPolicies) {
                if (installedPolicy.name() == null) continue;
                allPolicies.put(installedPolicy.name(), installedPolicy);
            }
            HashMap<String, HttpSecurityPolicy> annotationPoliciesOnly = new HashMap<String, HttpSecurityPolicy>();
            for (Map.Entry<MethodDescription, String> e : storage.getMethodToPolicyName().entrySet()) {
                String policyName = e.getValue();
                if (annotationPoliciesOnly.containsKey(policyName)) continue;
                if (allPolicies.containsKey(policyName)) {
                    annotationPoliciesOnly.put(policyName, (HttpSecurityPolicy)allPolicies.get(policyName));
                    continue;
                }
                String classAndMethodName = e.getKey().getClassName() + "#" + e.getKey().getMethodName();
                throw new RuntimeException("Endpoint '%s' requires named HttpSecurityPolicy '%s' specified with '@AuthorizationPolicy',\nbut no such policies has bean found. Please provide required policy as CDI bean.\n".formatted(classAndMethodName, policyName));
            }
            this.policyNameToPolicy = Map.copyOf(annotationPoliciesOnly);
        }
    }

    public boolean requiresAuthorizationPolicy(MethodDescription securedMethodDesc) {
        return this.storage.requiresAuthorizationPolicy(securedMethodDesc);
    }

    public boolean hasNoPermissions() {
        return this.delegate.hasNoPermissions() && this.foundNoAnnotatedMethods;
    }

    public Uni<HttpSecurityPolicy.CheckResult> checkPermission(RoutingContext routingContext, Uni<SecurityIdentity> identity, MethodDescription description) {
        HttpSecurityPolicy authorizationPolicy = this.findAuthorizationPolicy(description);
        if (authorizationPolicy == null) {
            return this.delegate.checkPermissions(routingContext, identity, this.requestContext, new HttpSecurityPolicy[0]);
        }
        return this.delegate.checkPermissions(routingContext, identity, this.requestContext, authorizationPolicy);
    }

    private HttpSecurityPolicy findAuthorizationPolicy(MethodDescription description) {
        String policyName;
        if (description != null && (policyName = this.storage.getMethodToPolicyName().get(description)) != null) {
            return this.policyNameToPolicy.get(policyName);
        }
        return null;
    }
}

