/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.logstream;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtFormatter;
import org.jboss.logmanager.ExtLogRecord;

public class JsonFormatter
extends ExtFormatter {
    private static final String TYPE = "type";
    private static final String LEVEL = "level";
    private static final String MESSAGE = "message";
    private static final String FORMATTED_MESSAGE = "formattedMessage";
    private static final String LOGGER_NAME_SHORT = "loggerNameShort";
    private static final String LOGGER_NAME = "loggerName";
    private static final String LOGGER_CLASS_NAME = "loggerClassName";
    private static final String HOST_NAME = "hostName";
    private static final String SOURCE_LINE_NUMBER = "sourceLineNumber";
    private static final String SOURCE_CLASS_NAME_FULL = "sourceClassNameFull";
    private static final String SOURCE_CLASS_NAME_FULL_SHORT = "sourceClassNameFullShort";
    private static final String SOURCE_CLASS_NAME = "sourceClassName";
    private static final String SOURCE_FILE_NAME = "sourceFileName";
    private static final String SOURCE_METHOD_NAME = "sourceMethodName";
    private static final String THREAD_ID = "threadId";
    private static final String THREAD_NAME = "threadName";
    private static final String PROCESS_ID = "processId";
    private static final String PROCESS_NAME = "processName";
    private static final String TIMESTAMP = "timestamp";
    private static final String STACKTRACE = "stacktrace";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String DOT = ".";
    private static final String LOG_LINE = "logLine";
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public String format(ExtLogRecord logRecord) {
        return this.toJsonObject(logRecord).encodePrettily();
    }

    JsonObject toJsonObject(ExtLogRecord logRecord) {
        String formattedMessage = this.formatMessage((LogRecord)logRecord);
        JsonObject jsonObject = JsonObject.of();
        jsonObject.put(TYPE, (Object)LOG_LINE);
        if (logRecord.getLoggerName() != null) {
            jsonObject.put(LOGGER_NAME_SHORT, (Object)this.getShortFullClassName(logRecord.getLoggerName(), ""));
            jsonObject.put(LOGGER_NAME, (Object)logRecord.getLoggerName());
        }
        if (logRecord.getLoggerClassName() != null) {
            jsonObject.put(LOGGER_CLASS_NAME, (Object)logRecord.getLoggerClassName());
        }
        if (logRecord.getHostName() != null) {
            jsonObject.put(HOST_NAME, (Object)logRecord.getHostName());
        }
        if (logRecord.getLevel() != null) {
            jsonObject.put(LEVEL, (Object)logRecord.getLevel().getName());
        }
        if (formattedMessage != null) {
            jsonObject.put(FORMATTED_MESSAGE, (Object)formattedMessage);
        }
        if (logRecord.getMessage() != null) {
            jsonObject.put(MESSAGE, (Object)logRecord.getMessage());
        }
        jsonObject.put(SOURCE_LINE_NUMBER, (Object)logRecord.getSourceLineNumber());
        if (logRecord.getSourceClassName() != null) {
            String justClassName = this.getJustClassName(logRecord.getSourceClassName());
            jsonObject.put(SOURCE_CLASS_NAME_FULL_SHORT, (Object)this.getShortFullClassName(logRecord.getSourceClassName(), justClassName));
            jsonObject.put(SOURCE_CLASS_NAME_FULL, (Object)logRecord.getSourceClassName());
            jsonObject.put(SOURCE_CLASS_NAME, (Object)justClassName);
        }
        if (logRecord.getSourceFileName() != null) {
            jsonObject.put(SOURCE_FILE_NAME, (Object)logRecord.getSourceFileName());
        }
        if (logRecord.getSourceMethodName() != null) {
            jsonObject.put(SOURCE_METHOD_NAME, (Object)logRecord.getSourceMethodName());
        }
        if (logRecord.getThrown() != null) {
            jsonObject.put(STACKTRACE, (Object)this.getStacktraces(logRecord.getThrown()));
        }
        jsonObject.put(THREAD_ID, (Object)logRecord.getThreadID());
        jsonObject.put(THREAD_NAME, (Object)logRecord.getThreadName());
        jsonObject.put(PROCESS_ID, (Object)logRecord.getProcessId());
        jsonObject.put(PROCESS_NAME, (Object)logRecord.getProcessName());
        jsonObject.put(TIMESTAMP, (Object)this.getTimeStampInCurrentZone(logRecord.getMillis()));
        jsonObject.put(SEQUENCE_NUMBER, (Object)logRecord.getSequenceNumber());
        return jsonObject;
    }

    private String getTimeStampInCurrentZone(long epochMilli) {
        Instant instant = Instant.ofEpochMilli(epochMilli);
        ZonedDateTime dateTime = instant.atZone(ZoneId.systemDefault());
        return dateTime.format(this.formatter);
    }

    private JsonArray getStacktraces(Throwable t) {
        LinkedList<String> traces = new LinkedList<String>();
        this.addStacktrace(traces, t);
        JsonArray jsonArray = JsonArray.of((Object[])new Object[0]);
        traces.forEach(trace -> jsonArray.add(trace));
        return jsonArray;
    }

    private void addStacktrace(List<String> traces, Throwable t) {
        traces.add(this.getStacktrace(t));
        if (t.getCause() != null) {
            this.addStacktrace(traces, t.getCause());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getStacktrace(Throwable t) {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                t.printStackTrace(pw);
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            return null;
        }
    }

    private String getJustClassName(String fullName) {
        int lastDot = fullName.lastIndexOf(DOT) + 1;
        return fullName.substring(lastDot);
    }

    private String getShortFullClassName(String fullName, String justClassName) {
        String string;
        String[] parts = fullName.split("\\.");
        StringWriter buffer = new StringWriter();
        try {
            for (int i = 0; i < parts.length - 1; ++i) {
                String part = parts[i];
                if (part.equals(justClassName) || part.length() < 3) {
                    buffer.write(part);
                } else {
                    buffer.write(part.substring(0, 3));
                }
                buffer.write(DOT);
            }
            buffer.write(parts[parts.length - 1]);
            string = buffer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return fullName;
            }
        }
        buffer.close();
        return string;
    }
}

