/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

final class IndexClassLookupUtils {
    private static final Logger LOGGER = Logger.getLogger(IndexClassLookupUtils.class);
    private static final Set<DotName> alreadyKnown = ConcurrentHashMap.newKeySet();

    private IndexClassLookupUtils() {
    }

    static ClassInfo getClassByName(IndexView index, Type type) {
        if (type != null && (type.kind() == Type.Kind.CLASS || type.kind() == Type.Kind.PARAMETERIZED_TYPE)) {
            return IndexClassLookupUtils.getClassByName(index, type.name());
        }
        return null;
    }

    static ClassInfo getClassByName(IndexView index, DotName dotName) {
        return IndexClassLookupUtils.getClassByName(index, dotName, true);
    }

    static ClassInfo getClassByName(IndexView index, DotName dotName, boolean withLogging) {
        if (dotName == null) {
            throw new IllegalArgumentException("Cannot lookup class, provided DotName was null.");
        }
        if (index == null) {
            throw new IllegalArgumentException("Cannot lookup class, provided Jandex Index was null.");
        }
        ClassInfo info = index.getClassByName(dotName);
        if (info == null && withLogging && !alreadyKnown.contains(dotName)) {
            LOGGER.infof("Class for name: %s was not found in Jandex index. Please ensure the class is part of the index.", (Object)dotName);
            alreadyKnown.add(dotName);
        }
        return info;
    }
}

