/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.selector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aesh.command.shell.Shell;
import org.aesh.readline.Prompt;
import org.aesh.readline.terminal.Key;
import org.aesh.selector.MultiSelect;
import org.aesh.selector.SelectorType;
import org.aesh.terminal.utils.ANSI;

public class Selector {
    private final SelectorType type;
    private final ArrayList<String> defaultValues;
    private final String message;

    public Selector(SelectorType type, String[] defaultValues, String message) {
        this(type, Arrays.asList(defaultValues), message);
    }

    public Selector(SelectorType type, List<String> defaultValues, String message) {
        if (type == null) {
            throw new IllegalArgumentException("SelectorType can not be null");
        }
        this.type = type;
        this.defaultValues = new ArrayList();
        if (defaultValues != null) {
            this.defaultValues.addAll(defaultValues);
        }
        this.message = message;
    }

    public List<String> doSelect(Shell shell) throws InterruptedException {
        if (this.type == SelectorType.INPUT) {
            return this.input(shell);
        }
        if (this.type == SelectorType.PASSWORD) {
            return this.passwd(shell);
        }
        if (this.type == SelectorType.SELECT) {
            return this.select(shell);
        }
        if (this.type == SelectorType.SELECTIONS) {
            return this.multiSelect(shell);
        }
        return new ArrayList<String>();
    }

    private List<String> multiSelect(Shell shell) {
        MultiSelect multiSelect = new MultiSelect(shell, this.defaultValues, this.message);
        return multiSelect.doSelect();
    }

    private List<String> select(Shell shell) {
        ArrayList<String> out = new ArrayList<String>(1);
        shell.writeln(this.message + "  [Use arrow up/down to move and enter/space to select]");
        for (int i = 0; i < this.defaultValues.size(); ++i) {
            if (i == 0) {
                shell.writeln("> " + this.defaultValues.get(i));
                continue;
            }
            shell.writeln("  " + this.defaultValues.get(i));
        }
        shell.write("\u001b[?25l");
        int[] moveToFirstLine = new int[]{27, 91, 48 + this.defaultValues.size(), 65};
        shell.write(moveToFirstLine);
        boolean waitingForEnter = true;
        int focusLine = 0;
        while (waitingForEnter) {
            int moveDown;
            try {
                Key in = shell.read();
                if (in == Key.ENTER || in == Key.ENTER_2 || in == Key.CTRL_M || in == Key.SPACE) {
                    waitingForEnter = false;
                    out.add(this.defaultValues.get(focusLine));
                    moveDown = this.defaultValues.size() - focusLine;
                    shell.write(new int[]{27, 91, 48 + moveDown, 66});
                    shell.write("\u001b[?25h");
                    continue;
                }
                if (in == Key.UP || in == Key.UP_2) {
                    if (focusLine <= 0) continue;
                    --focusLine;
                    shell.write(' ');
                    shell.write(ANSI.MOVE_LINE_UP);
                    shell.write(ANSI.CURSOR_START);
                    shell.write('>');
                    shell.write(ANSI.CURSOR_START);
                    continue;
                }
                if (in != Key.DOWN && in != Key.DOWN_2 || focusLine >= this.defaultValues.size() - 1) continue;
                ++focusLine;
                shell.write(' ');
                shell.write(ANSI.MOVE_LINE_DOWN);
                shell.write(ANSI.CURSOR_START);
                shell.write('>');
                shell.write(ANSI.CURSOR_START);
            }
            catch (InterruptedException e) {
                moveDown = this.defaultValues.size() - focusLine;
                shell.write(new int[]{27, 91, 48 + moveDown, 66});
                shell.write("\u001b[?25h");
            }
        }
        return out;
    }

    private List<String> passwd(Shell shell) throws InterruptedException {
        ArrayList<String> out = new ArrayList<String>(1);
        out.add(shell.readLine(new Prompt(this.message + " ", Character.valueOf('*'))));
        return out;
    }

    private List<String> input(Shell shell) throws InterruptedException {
        ArrayList<String> out = new ArrayList<String>(1);
        out.add(shell.readLine(new Prompt(this.message + " ")));
        return out;
    }
}

