/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public abstract class CacheInitializer {
    private static final Logger log = Logger.getLogger(CacheInitializer.class);

    public void loadSessions() {
        Instant loadingMustContinueBy = Instant.now().plusSeconds(this.getStalledTimeoutInSeconds());
        boolean loadingStalledInPreviousStep = false;
        int lastProgressIndicator = 0;
        while (!this.isFinished()) {
            if (!this.isCoordinator()) {
                try {
                    boolean loadingStalled;
                    TimeUnit.SECONDS.sleep(1L);
                    int progressIndicator = this.getProgressIndicator();
                    boolean bl = loadingStalled = lastProgressIndicator == progressIndicator;
                    if (loadingStalled) {
                        if (loadingStalledInPreviousStep) {
                            if (Instant.now().isAfter(loadingMustContinueBy)) {
                                throw new RuntimeException("Loading sessions has stalled for " + this.getStalledTimeoutInSeconds() + " seconds, possibly caused by split-brain");
                            }
                            log.tracef("Loading sessions stalled. Waiting until %s", (Object)loadingMustContinueBy);
                        } else {
                            loadingMustContinueBy = Instant.now().plusSeconds(this.getStalledTimeoutInSeconds());
                            loadingStalledInPreviousStep = true;
                        }
                    } else {
                        loadingStalledInPreviousStep = false;
                    }
                    lastProgressIndicator = progressIndicator;
                    continue;
                }
                catch (InterruptedException ie) {
                    log.error((Object)"Interrupted", (Throwable)ie);
                    throw new RuntimeException("Loading sessions failed", ie);
                }
            }
            this.startLoading();
        }
    }

    protected abstract boolean isFinished();

    protected abstract boolean isCoordinator();

    protected abstract int getProgressIndicator();

    protected abstract void startLoading();

    protected abstract int getStalledTimeoutInSeconds();
}

