/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.infinispan.module.factory;

import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.keycloak.infinispan.module.certificates.CertificateReloadManager;
import org.keycloak.infinispan.module.certificates.JGroupsCertificateHolder;
import org.keycloak.infinispan.module.configuration.global.KeycloakConfiguration;
import org.keycloak.models.KeycloakSessionFactory;

@DefaultFactoryFor(classes={CertificateReloadManager.class})
public class CertificateReloadManagerFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    public Object construct(String componentName) {
        KeycloakConfiguration kcConfig = (KeycloakConfiguration)this.globalConfiguration.module(KeycloakConfiguration.class);
        if (kcConfig == null) {
            return null;
        }
        KeycloakSessionFactory sessionFactory = kcConfig.keycloakSessionFactory();
        JGroupsCertificateHolder certificateHolder = kcConfig.jGroupsCertificateHolder();
        if (sessionFactory == null || certificateHolder == null) {
            throw new IllegalStateException("KeycloakConfiguration is not null when the certificate reload is required.");
        }
        return new CertificateReloadManager(sessionFactory, certificateHolder, kcConfig.jgroupsCertificateRotation());
    }
}

