/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.infinispan.module.certificates;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.jboss.logging.Logger;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.infinispan.module.certificates.JGroupsCertificate;
import org.keycloak.infinispan.module.certificates.ReloadingX509ExtendedKeyManager;
import org.keycloak.infinispan.module.certificates.ReloadingX509ExtendedTrustManager;

public class JGroupsCertificateHolder {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private static final char[] KEY_PASSWORD = "jgroups-password".toCharArray();
    private volatile JGroupsCertificate certificate;
    private final ReloadingX509ExtendedKeyManager keyManager;
    private final ReloadingX509ExtendedTrustManager trustManager;

    private JGroupsCertificateHolder(ReloadingX509ExtendedKeyManager keyManager, ReloadingX509ExtendedTrustManager trustManager, JGroupsCertificate certificate) {
        this.keyManager = keyManager;
        this.trustManager = trustManager;
        this.certificate = certificate;
    }

    public static JGroupsCertificateHolder create(JGroupsCertificate certificate) throws GeneralSecurityException, IOException {
        Objects.requireNonNull(certificate);
        X509ExtendedKeyManager km = JGroupsCertificateHolder.createKeyManager(certificate);
        X509ExtendedTrustManager tm = JGroupsCertificateHolder.createTrustManager(null, certificate);
        X509Certificate crt = certificate.getCertificate();
        logger.debugf("Using JGroups certificate (serial: %s). Valid until %s", (Object)crt.getSerialNumber(), (Object)crt.getNotAfter());
        return new JGroupsCertificateHolder(new ReloadingX509ExtendedKeyManager(km), new ReloadingX509ExtendedTrustManager(tm), certificate);
    }

    public JGroupsCertificate getCertificateInUse() {
        return this.certificate;
    }

    public void useCertificate(JGroupsCertificate certificate) throws GeneralSecurityException, IOException {
        Objects.requireNonNull(certificate);
        if (Objects.equals(certificate.getAlias(), this.certificate.getAlias())) {
            return;
        }
        X509Certificate crt = certificate.getCertificate();
        logger.debugf("Using JGroups certificate (serial: %s). Valid until %s", (Object)crt.getSerialNumber(), (Object)crt.getNotAfter());
        if (this.certificate != null) {
            crt = this.certificate.getCertificate();
            logger.debugf("Old JGroups certificate (serial: %s). Valid until %s", (Object)crt.getSerialNumber(), (Object)crt.getNotAfter());
        }
        X509ExtendedKeyManager km = JGroupsCertificateHolder.createKeyManager(certificate);
        X509ExtendedTrustManager tm = JGroupsCertificateHolder.createTrustManager(this.certificate, certificate);
        this.keyManager.reload(km);
        this.trustManager.reload(tm);
        this.certificate = certificate;
    }

    public X509ExtendedKeyManager keyManager() {
        return this.keyManager;
    }

    public X509ExtendedTrustManager trustManager() {
        return this.trustManager;
    }

    public void setExceptionHandler(Runnable runnable) {
        this.trustManager.setExceptionHandler(runnable);
    }

    private static X509ExtendedKeyManager createKeyManager(JGroupsCertificate newCertificate) throws GeneralSecurityException, IOException {
        KeystoreUtil.KeystoreFormat keystoreFormat = (KeystoreUtil.KeystoreFormat)CryptoIntegration.getProvider().getSupportedKeyStoreTypes().findFirst().orElseThrow(() -> new RuntimeException("No supported keystore types found"));
        KeyStore ks = CryptoIntegration.getProvider().getKeyStore(keystoreFormat);
        ks.load(null, null);
        ks.setKeyEntry(newCertificate.getAlias(), newCertificate.getPrivateKey(), KEY_PASSWORD, new Certificate[]{newCertificate.getCertificate()});
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, KEY_PASSWORD);
        for (KeyManager km : kmf.getKeyManagers()) {
            if (!(km instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)km;
        }
        throw new GeneralSecurityException("Could not obtain an X509ExtendedKeyManager");
    }

    private static X509ExtendedTrustManager createTrustManager(JGroupsCertificate oldCertificate, JGroupsCertificate newCertificate) throws GeneralSecurityException, IOException {
        KeystoreUtil.KeystoreFormat keystoreFormat = (KeystoreUtil.KeystoreFormat)CryptoIntegration.getProvider().getSupportedKeyStoreTypes().findFirst().orElseThrow(() -> new RuntimeException("No supported keystore types found"));
        KeyStore ks = CryptoIntegration.getProvider().getKeyStore(keystoreFormat);
        ks.load(null, null);
        if (oldCertificate != null) {
            JGroupsCertificateHolder.addCertificateEntry(ks, oldCertificate);
        }
        JGroupsCertificateHolder.addCertificateEntry(ks, newCertificate);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509ExtendedTrustManager)) continue;
            return (X509ExtendedTrustManager)tm;
        }
        throw new GeneralSecurityException("Could not obtain an X509TrustManager");
    }

    private static void addCertificateEntry(KeyStore store, JGroupsCertificate certificate) throws KeyStoreException {
        store.setCertificateEntry(certificate.getAlias(), certificate.getCertificate());
    }
}

